<?php

#**********************************
# THIS SCRIPT SCHEDULED IN CRONTAB,
# OR CALLED BY FORM SUBMISSIONS
# AND INCOMING WEB SERVICE CALLS
#**********************************
define('AREA', 'CRON');
require('settings.php');
require('class_framework.php');		$frmwkObj = new Framework;	# FRAMEWORK
require('class_squaretrade.php');	$sqrtObj = new Squaretrade;	# EXTENDS FRAMEWORK
require('class_database.php');		$dbObj = new Database;		# EXTENDS FRAMEWORK
require('class_payment.php');		$pmtObj = new Payment;		# EXTENDS DATABASE
require('class_admin.php');			$adminObj = new Admin;		# EXTENDS DATABASE
require('class_order.php');			$orderObj = new Order;		# EXTENDS DATABASE
require('class_search.php');		$searchObj = new Search;	# EXTENDS DATABASE
require('class_customer.php');		$custObj = new Customer;	# EXTENDS DATABASE
require('class_cart.php');			$cartObj = new Cart;		# EXTENDS DATABASE
require('class_ups.php');			$upsObj = new Ups;			# EXTENDS DATABASE
require('class_socialnet.php');		$socialObj = new SocialNet;
require('class_gsx.php');               $gsxObj = new GSX();
require('class_google_contacts.php');   $googleObj = new GoogleContacts();
require('class_wufoo.php');             $wufooObj = new Wufoo();
require('class_timesheet.php');         $timesheetObj = new Timesheet;
require('class_zoho.php');              $zohoObj = new Zoho;
require('class_ebay.php');              $ebayObj = new eBay;
require('class_paypal.php');            $paypalObj = new Paypal;
require('classes/class_imaging.php'); $imagingObj = new Imaging;
require('classes/class_inventory.php');	$invObj = new Inventory;
require('apis/shopify/class_shopify.php'); $shopifyObj = new Shopify;
require('apis/backmarket/class_backmarket.php'); $backmarketObj = new BackmarketAPI;
require('apis/ebay/class_ebay_api.php'); $ebayApiObj = new EbayAPI;
require('apis/newegg/class_newegg_api.php'); $neweggApiObj = new NeweggAPI;
require('apis/amazon/AmazonMWS.php');
require_once(HTML_FOLDER . "classes/Generic/loadGeneric.php");
require_once('config/errorconfig.php');

$systemProfilerKey = "SKB2kMnLcmvS4YYA8ZhmyU0DgegjtJae";

# HANDLE SALESFORCE FORM SUBMISSIONS
if ($arg = $_POST['entry']) {
	require('class_salesforce.php');
	$sfrceObj = new Salesforce;
	switch ($arg) {
		case 'Education Connection':
			if ($sfrceObj->create_lead($_POST)) {
				$frmwkObj->goToUrl('eduok.html');
			}
		break;
		case 'Business Connection':
			if ($sfrceObj->create_lead($_POST)) {
				$frmwkObj->goToUrl('busok.html');
			}
		break;
		default:
			$frmwkObj->error_page(MISSING_URL_DATA);
	}
	exit;
}

# HANDLE GOOGLE CHECKOUT ASYNCHRONOUS SERVICE CALLS
if ($_GET['m'] == 'Google') {
	$xml = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : file_get_contents('php://input');
	if (get_magic_quotes_gpc()) {
		$xml = stripslashes($xml);
	}
	if (!$xml) {
		header('HTTP/1.0 400 Bad Request');
		exit;
	}
	$pmtObj->google_service_incoming($xml);
	exit;
}

# HANDLE RSS REQUEST
if ($arg = $_GET['rss']) {
	echo $custObj->rss($arg);
	exit;
}

# HANDLE RSS FOR FEEDBACKS FOR GOOGLE MAP
if ($_GET['m'] == 'testimonials_map_xml') {
        header("content-type: text/xml");
	echo $socialObj->rss_feedbacks($custObj->get_feedback(100,0,$_GET['zip']), 'map');
	exit;
}

# HANDLE RSS FOR FEEDBACKS
if ($_GET['m'] == 'testimonials_xml') {
	echo $socialObj->rss_feedbacks($custObj->get_feedback(10));
	exit;
}

# HANDLE SHIP METHODS LOOKUP QUERY
if ($_POST['action'] == 'shipmethods') {
        $_POST['maxtab'] = 3;
        $cartObj->store_temp_cart($_POST);
        echo $upsObj->get_shipmethods($_POST, session_id());
	exit;
}

# HANDLE ARGUMENTS
if ($arg = $_SERVER['argv'][2]) {
	require('class_cron.php');
	$cronObj = new Cron;
	$cronObj->run($arg);
	exit;
}

if ($_GET['m'] == 'zohoorderexports') {
	require('class_cron.php');
	$cronObj = new Cron;
	$cronObj->run($_GET['m']);
	exit;
}

# IPHONE INTEGRATION
if ($_GET['m'] == 'iPhone') {
	$xml = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : file_get_contents('php://input');
	if (get_magic_quotes_gpc()) {
		$xml = stripslashes($xml);
	} else {
		$xml = $_GET['xml'];
	}
	if (!$xml) {
		die('Unable to process XML.');
	}
	$custObj->account_detail_iphone($xml);
	exit;
}

if ($_GET['m'] == 'insert_system_profiler_entry') {
	$data = $_POST;
	if ($data['key'] == $systemProfilerKey) {
		unset($data['key']);
		echo print_r($imagingObj->insertSystemProfilerEntry($data));
	}
	exit;
}

if ($_GET['m'] == 'pre_install_system_profiler_entry') {
	$data = $_POST;
	if ($data['key'] == $systemProfilerKey) {
		unset($data['key']);
		echo print_r($imagingObj->preInstallSystemProfilerEntry($data));
	}
	exit;
}

if ($_GET['m'] == 'post_install_system_profiler_update') {
	$data = $_POST;
	if ($data['key'] == $systemProfilerKey) {
		unset($data['key']);
		echo print_r($imagingObj->postInstallSystemProfilerUpdate($data));
	}
	exit;
}

if ($_GET['m'] == 'update_shopify_inventory' || $_GET['m'] == 'updateshopifyinventory') {
	// echo "test2";
	$results = $invObj->updateShopifyInventory();
	// $cronObj = new Cron;
	// $results = $cronObj->run($_GET['m']);
	// echo print_r($results);
	exit;
}

if ($_GET['m'] == 'validateeligibleorders') {
	require('class_cron.php');
	$cronObj = new Cron;
	$results = $cronObj->run($_GET['m']);
	exit;
}

if ($_GET['m'] == 'updateopenorders') {
	echo "<h2>Beginning updating open orders</h2>";
	require('class_cron.php');
	$cronObj = new Cron;
	echo "<h4>Cron obj instantiated</h4>";
	$results = $cronObj->updateAmazonOrders(true);
	exit;
}

if ($_GET['m'] == 'amazonorderhistory') {
	require('class_cron.php');
	$cronObj = new Cron;
	$results = $cronObj->run($_GET['m']);
	exit;
}

if ($_GET['m'] == 'wufoo_tts_service_request') {
	require_once(HTML_FOLDER . "classes/RMA/RMAManager.php");
	$key = $_POST['HandshakeKey'];
	if (!RMAManager::validateHandshake($key)) {
		$entryString = "Failed to validate handshake at $date. Passed key was $key.\n";
		RMAManager::insertLogEntry($entryString);
		exit; // If the handshake is not valid, quit without taking any further action.
	}
	$formResultPath = HTML_FOLDER . "wufoo_forms/testform.txt";
	try {
		if (!file_exists($formResultPath)) {
			mkdir($formResultPath, 0700, true);
		}
		file_put_contents($formResultPath, json_encode($_POST));
	}
	catch (Exception $e) {
		echo $e;
	}
	$data = (object)$_POST;
	// $contents = file_get_contents(HTML_FOLDER . "wufoo_forms/testform.txt");
	// $decodedContents = json_decode($contents);

	$newOrderNumber = RMAManager::handleNewOrder($data);


	exit;
}

if ($_GET['m'] == 'test_read_wufoo_form') {
	require_once(HTML_FOLDER . "classes/RMA/RMAManager.php");
	$formResultPath = HTML_FOLDER . "wufoo_forms/testform.txt";
	$contents = file_get_contents(HTML_FOLDER . "wufoo_forms/testform.txt");
	$decodedContents = json_decode($contents);
	// $contents = json_decode(file_get_contents($formResultPath));

	echo "<pre>";
	print_r(json_decode($contents));
	echo "</pre>";
	echo RMAManager::handleNewOrder($decodedContents);
	exit;
}

if ($_GET['m'] == 'get_wufoo_entries_today') {
	require_once(HTML_FOLDER . "classes/RMA/RMAManager.php");
	$file = HTML_FOLDER . "wufoo_forms/tech-to-school-service-request_entries.csv";
	$string = str_replace("\n", ' ', file_get_contents($file));

	// echo "<pre>";
	// print_r(str_getcsv($string));
	// echo "</pre>";
	$csv = array_map('str_getcsv', file($file));
	array_walk($csv, function(&$a) use ($csv) {
		$a = array_combine($csv[0], $a);
	});
	array_shift($csv); # remove column header
	echo "<pre>";
	print_r($csv);
	echo "</pre>";
	foreach ($csv as $entry) {
		$parsedEntry = (object)$entry;
		// $customer = RMACustomer::fromCsvEntry($parsedEntry);
		// $order = RMAOrder::fromCsvEntry($parsedEntry);
		echo RMAManager::handleNewOrder($parsedEntry, true) . "\n";
	}

	exit;
}


# INVALID ACTION - REDIRECT
$frmwkObj->goToUrl(CONTROLLER);

?>
