const CONTROLLER_BASE_URL = 'admin_controller.php';


/**
 * @type {HTMLDivElement}
 */
const accountsDiv = document.getElementById('accounts');
/**
 * @type {HTMLDivElement}
 */
const resultsDiv = document.getElementById('results');
/**
 * @type {HTMLInputElement}
 */
const searchBar = document.getElementById('search');
/**
 * @type {HTMLHeadingElement}
 */
const resultsHeader = document.getElementById('resultsheader');

const shipToResults = [];

function prepareSearch(searchBar) {
	clearTimeout();
	setTimeout(function() {upsAccountSearch(searchBar)}, 1500);
}

/**
 *
 * @param {HTMLInputElement} searchBar The searchbar
 */
function upsAccountSearch(searchBar) {
	const url = `${CONTROLLER_BASE_URL}?m=worldship_search`, poststr = `searchstring=${searchBar.value}`;
	if(searchBar.value && searchBar.value.length > 0) {
		makeAjaxRequest(url, poststr, "POST", returnAccounts);
	}

	function returnAccounts(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					// console.log(http_request);
					// console.log(http_request.response);
					const data = receiveJson(http_request.response);
					accountsDiv.innerHTML = '';
					resultsDiv.innerHTML = '';
					for (const datum in data) {
						if (typeof data[datum] == "object") {
							const schoolNameEscaped = escapeString(data[datum]['shipto']);
							const schoolName = data[datum]['shipto'];
							accountsDiv.innerHTML += `<p><a href="javascript:void(0)" onclick="getvariants(\`${schoolName}\`)">${schoolName}</a></p>`;
						}
					}
					if (accountsDiv.innerHTML == '') {
						accountsDiv.innerHTML = "<p>No Results Found</p>";
					}
					resultsHeader.hidden = false;
					break;
				default:
						alert("Error with AJAX request.");
			}
		}
	}

	function escapeString(str) {
		return str.replace(`'`, `\'`);
	}
}

function getvariants(str) {
	console.log(str);
	accountsDiv.innerHTML = '';
	searchBar.value = '';
	resultsHeader.hidden = true;
	const url = `${CONTROLLER_BASE_URL}?m=worldship_get_variants`, poststr = `searchstring=${str}`;
	makeAjaxRequest(url, poststr, 'POST', returnVariants);
	function returnVariants(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					// console.log(http_request);
					// console.log(http_request.response);
					console.log(http_request.response);
					const data = receiveJson(http_request.response);
					console.log(data);
					resultsDiv.innerHTML = '';
					shipToResults.length = 0;
					for (const row of data) {
						shipToResults.push(row);
						// outputDiv.innerHTML += stringifySelections(row);
					}
					stringifyResults(shipToResults);
					// outputDiv.innerHTML = '';
					// for (const datum in data) {
					// 	if (typeof data[datum] == "object") {
					// 		outputDiv.innerHTML += `<p><a href="javascript:void(0)" onclick="getvariants(${data[datum]['shipto']})">${data[datum]['shipto']}</a></p>`;
					// 	}
					// }
					break;
				default:
						alert("Error with AJAX request.");
			}
		}
	}
}

function stringifyResults(results) {
	if (results.length == 1) {
		selectOption(0);
	}
	else {
		resultsHeader.hidden = false;
		for (let i = 0; i < results.length; i++) {
			resultsDiv.innerHTML += stringifySelections(results[i], i);
		}
	}


	function stringifySelections(row, idx) {
		return `
			<div class="addressbox" onclick="selectOption(${idx})">
				<p style='margin:0;'>Ship to: ${row['shipto']}</p>
				${row['attention'] ? `<p style='margin:0;'>Attn: ${row['attention']}</p>` : ''}
				<p style='margin:0;'>Address 1: ${row['address1']}</p>
				${row['address2'] ? `<p style='margin:0;'>Address 2: ${row['address2']}` : ''}
				${row['address3'] ? `<p style='margin:0;'>Address 3: ${row['address3']}` : ''}
				${row['city'] ? `<p style='margin:0;'>City: ${row['city']}` : ''}
				${row['state'] ? `<p style='margin:0;'>State: ${row['state']}` : ''}
				${row['zip'] ? `<p style='margin:0;'>ZIP: ${row['zip']}` : ''}
				${row['email'] ? `<p style='margin:0;'>Email: ${row['email']}` : ''}
				${row['phone'] ? `<p style='margin:0;'>Phone: ${row['phone']}` : ''}
			</div>
			`;
	}
}

function selectOption(idx) {
	document.getElementById("company").value = shipToResults[idx]['shipto'] || '';
	document.getElementById("name").value = shipToResults[idx]['attention'] || '';
	document.getElementById("address1").value = shipToResults[idx]['address1'] || '';
	document.getElementById("address2").value = shipToResults[idx]['address2'] || '';
	document.getElementById("address3").value = shipToResults[idx]['address3'] || '';
	document.getElementById("city").value = shipToResults[idx]['city'] || '';
	document.getElementById("state").value = shipToResults[idx]['state'] || '';
	document.getElementById("zip").value = shipToResults[idx]['zip'] || '';
	document.getElementById("phone").value = shipToResults[idx]['phone'] || '';
	document.getElementById("email").value = shipToResults[idx]['email'] || '';
}

function receiveJson(str) {
	try {
		return JSON.parse(str);
	} catch(e) {
		return e;
	}
}

function updateDimensions(obj){
	document.getElementById("length").value = obj.options[obj.selectedIndex].getAttribute("length");
	document.getElementById("width").value = obj.options[obj.selectedIndex].getAttribute("width");
	document.getElementById("height").value = obj.options[obj.selectedIndex].getAttribute("height");
}

function selectShipTo(obj){

	var ship_id = obj.options[obj.selectedIndex].value;

	for ( i = 0 ; i < shiptoJSONObj.shipaddresses.length; i++){
		if (shiptoJSONObj.shipaddresses[i].ship_id == ship_id){
			document.getElementById("company").value = shiptoJSONObj.shipaddresses[i].ship_to;
			document.getElementById("name").value = shiptoJSONObj.shipaddresses[i].attention;
			document.getElementById("address1").value = shiptoJSONObj.shipaddresses[i].address1;
			document.getElementById("address2").value = shiptoJSONObj.shipaddresses[i].address2;
			document.getElementById("address3").value = shiptoJSONObj.shipaddresses[i].address3;
			document.getElementById("city").value = shiptoJSONObj.shipaddresses[i].city;
			document.getElementById("state").value = shiptoJSONObj.shipaddresses[i].state;
			document.getElementById("zip").value = shiptoJSONObj.shipaddresses[i].zip;
			document.getElementById("phone").value = shiptoJSONObj.shipaddresses[i].phone;
			document.getElementById("email").value = shiptoJSONObj.shipaddresses[i].email;
			break;
		}
	}

}

function disableBoxes(obj){
	if (obj.selectedIndex != 0){
		document.getElementById("add_boxes").selectedIndex = 0;
		document.getElementById("add_boxes").disabled = true;
	}else{
		document.getElementById("add_boxes").disabled = false;
	}
}

/**
 *
 * @param {HTMLButtonElement} btn
 */
function copyAllTrackingNumsToClipboard(btn) {
	/**
	 * @type {HTMLTextAreaElement}
	 */
	const trackingList = document.getElementById('trackingList');
	const el = document.createElement('textarea');
	el.value = trackingList.value.split(' ').join('\n');
	el.setAttribute('readonly', '');
	el.style.position = 'absolute';
	el.style.left = '-9999px';
	document.body.appendChild(el);
	el.select();
	document.execCommand('copy');
	document.body.removeChild(el);
	btn.innerText = "Copied!";
	return false;
}
