class OpenOrderStatus {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		if (data['dbId']) {
			this.id = data['dbId'];
		}
		/**
		 * @type {string}
		 */
		this.status = data['status'];
		/**
		 * @type {string}
		 */
		this.identifier = data['identifier'];
		/**
		 * @type {number}
		 */
		this.displayOrder = parseInt(data['displayOrder']);
	}

	getId() {
		return this.id;
	}

	getStatus() {
		return this.status;
	}

	getIdentifier() {
		return this.identifier;
	}

	getDisplayOrder() {
		return this.displayOrder;
	}

	getStatusOption(selected=false) {
		const option = document.createElement('option');
		option.value = this.getId();
		option.innerText = this.getStatus();
		option.selected = selected;
		return option;
	}
}
