class OpenOrderLineItem {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = '';
		if (data['id']) {
			this.id = data['id'];
		}
		else if (data['dbId']) {
			this.id = data['dbId'];
		}
		/**
		 * @type {string}
		 */
		this.zohoId = data['zohoId'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.code = data['code'];
		/**
		 * @type {string}
		 */
		this.description = data['description'];
		this.deducted = (data['deducted'] || data['deductedOnOpenOrders']);

		this.quantity = parseInt(data['quantity']);
		this.total = parseFloat(data['total']) || 0.0;

		/**
		 * @type {string}
		 */
		this.filter = (data['code']) ? data['code'] : data['name'];

		this.originalPassedData = data;

		this.isVisible = true;
	}


	/**
	 * Fetches line item ID
	 * @returns ID of line item
	 */
	getId() {
		return this.id;
	}

	/**
	 * Fetches line item zoho ID
	 * @returns Zoho ID of line item
	 */
	getZohoId() {
		return this.zohoId;
	}

	getCode() {
		return this.code;
	}

	getName() {
		return this.name;
	}

	getDescription() {
		return this.description;
	}

	getDeducted() {
		return this.deducted;
	}

	getQuantity() {
		return this.quantity;
	}

	getTotal() {
		return this.total;
	}

	getIsVisible() {
		return this.isVisible;
	}

	getSkuCell() {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		cell.appendChild(link);
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Products/${this.getZohoId()}`;
		link.target = "_blank";
		link.innerText = this.getFieldByName('lineItemSku');
		cell.appendChild(this.getHideSkuLink());
		return cell;
	}

	getHideSkuLink() {
		const small = document.createElement('small');
		const span = document.createElement('span');
		small.appendChild(span);
		span.innerText = " | ";
		const link = document.createElement('a');
		small.appendChild(link);
		small.classList.add('updateElement');
		small.hidden = !updateElementsVisible;
		link.href = "javascript:void(0)";
		link.innerText = "(deduct)";
		link.setAttribute('onclick', `addToDeductions('${this.getId()}')`);
		return small;
	}

	getQuantityCell() {
		const cell = document.createElement('td');
		cell.innerText = this.getQuantity().toLocaleString();
		cell.classList.add('halign-center');
		return cell;
	}

	/**
	 * Fetches a parameter by name, or false if no such name
	 * @param {string} fieldName Name of the field to fetch
	 */
	getFieldByName(fieldName) {
		if (fieldName == 'id') {
			return this.getId();
		}
		else if (fieldName == 'zohoId') {
			return this.getZohoId();
		}
		else if (fieldName == 'name') {
			return this.getName();
		}
		else if (fieldName == 'code') {
			return this.getCode();
		}
		else if (fieldName == 'description') {
			return this.getDescription();
		}
		else if (fieldName == 'quantity' || fieldName == 'lineItemQuantity') {
			return this.getQuantity();
		}
		else if (fieldName == 'lineItemSku') {
			return (this.getCode()) ? this.getCode() : this.getName();
		}
	}

	getFieldByNameAsText(fieldName) {
		const returnedValue = this.getFieldByName(fieldName);
		if (typeof returnedValue == 'string') {
			return returnedValue;
		}
		else if (typeof returnedValue == 'number') {
			return returnedValue.toLocaleString();
		}
	}

	/**
	 *
	 * @param {boolean} isVisible
	 */
	setIsVisible(isVisible) {
		if (typeof isVisible == 'boolean') {
			this.isVisible = isVisible;
		}
	}

	getSaveableFieldsAsObject() {
		const toSave = {
			id : this.getId(),
			zohoId: this.getZohoId(),
			fields: {
			}
		};
		return toSave;
	}
}
