class Account {
	constructor(data) {
		this.id = '';
		if (data['id']) {
			this.id = data['id'];
		}
		else if (data['dbId']) {
			this.id = data['dbId'];
		}
		/**
		 * @type {string}
		 */
		this.zohoId = data['zohoId'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
	}

	getId() {
		return this.id;
	}
	getZohoId() {
		return this.zohoId;
	}
	getName() {
		return this.name;
	}

	getAccountLink() {
		const link = document.createElement('a');
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Accounts/${this.getZohoId()}`;
		link.innerText = this.getName();
		link.target = "_blank";
		return link;
	}

	getAccountCell() {
		const cell = document.createElement('td');
		cell.appendChild(this.getAccountLink());
		return cell;
	}
}
