const CONTROLLER_BASE_URL = 'admin_controller.php';

const SORT_ASC_URL = '../svg/sort_asc_white.svg';
const SORT_DESC_URL = '../svg/sort_desc_white.svg';
const SORT_NONE_URL = '../svg/sort_white.svg';
const DEFAULT_SORT = 'ship_date';

/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');



setLoadingModalVisible(false);



const TODAY = new Date();

const this_year = {
	as_number : TODAY.getFullYear(),
	as_string : TODAY.getFullYear().toString()
}
const last_year = {
	as_number : TODAY.getFullYear() - 1,
	as_string : ''
}
last_year.as_string = last_year.as_number.toString();
const this_month = {
	as_number : TODAY.getMonth() + 1,
	as_string : '',
};
this_month.as_string =  '0'.repeat(2 - this_month.as_number.toString().length).concat(this_month.as_number.toString())
const last_month = {
	as_number : (TODAY.getMonth() >= 1) ? TODAY.getMonth() : 12,
	as_string : '',
	last_day : ''
};
last_month.as_string = '0'.repeat(2 - last_month.as_number.toString().length).concat(last_month.as_number.toString());
last_month.last_day = getMonthLastDay((last_month.as_number == 12) ? last_year.as_number : this_year.as_number, last_month.as_number);
const day_of_month = {
	as_number : TODAY.getDate(),
	as_string : '0'.repeat(2 - TODAY.getDate().toString().length).concat(TODAY.getDate().toString())
};

const searchParameters = {
	startDate : `${this_year.as_string}-${this_month.as_string}-01`,
	endDate : '',
	salespersons : []
};

let showSalespersonColumn = true;


const SHIP_LOG_DICT = {};

/**
 * @type {ShipLogRecord[]}
 */
const SHIP_LOG_ARRAY = [];

/**
 * @type {ShipLogRecord[]}
 */
const validEntries = [];


const UNKNOWN_DATE_SHIP_LOG_DICT = {};

/**
 * @type {ShipLogRecord[]}
 */
const UNKNOWN_DATE_SHIP_LOG_ARRAY = [];

/**
 * @type {HTMLSelectElement}
 */
const DATE_RANGE_SELECT = document.getElementById('date_range_select');
/**
 * @type {HTMLInputElement}
 */
const START_DATE_INPUT = document.getElementById('start_date_input');
/**
 * @type {HTMLInputElement}
 */
const END_DATE_INPUT = document.getElementById('end_date_input');
/**
 * @type {HTMLButtonElement}
 */
const NEXT_MONTH_BUTTON = document.getElementById("next_month_button");
/**
 * @type {HTMLButtonElement}
 */
const PREVIOUS_MONTH_BUTTON = document.getElementById("previous_month_button");

START_DATE_INPUT.max = TODAY.toJSON().substring(1, TODAY.toJSON().indexOf('T'));

END_DATE_INPUT.max = START_DATE_INPUT.max;

const COLUMN_DEFINITIONS = {
	salesperson: new ColumnDefinition('Sales', 'salesperson', {isSortable: true, isFilterable: true}),
	mts_number: new ColumnDefinition('MTS', 'mts_number', {isSortable: true, isFilterable: true}),
	account_name: new ColumnDefinition('School', 'account_name', {isSortable: true, isFilterable: true}),
	invoice_date: new ColumnDefinition('Invoice Date', 'invoice_date', {isSortable: true}),
	ship_date: new ColumnDefinition('Ship Date', 'ship_date', {isSortable: true}),
	products: new ColumnDefinition('SKU', 'products', {isFilterable: true}),
	quantity: new ColumnDefinition('Quantity', 'quantity'),
	notes: new ColumnDefinition('Notes', 'notes'),
	tracking_numbers: new ColumnDefinition('Tracking Numbers', 'tracking_numbers'),
	subtotal: new ColumnDefinition('Subtotal', 'subtotal', {isSortable: true}),
	updateRecord: new ColumnDefinition('Update', 'updateRecord', {classNames: 'updateElement'}),
	stateAbbreviation: new ColumnDefinition('State', 'stateAbbreviation', {isFilterable: true, isSortable: true})
};

/**
 * @type {ColumnDefinition[]}
 */
const columns = [
	COLUMN_DEFINITIONS.salesperson,
	COLUMN_DEFINITIONS.mts_number,
	COLUMN_DEFINITIONS.account_name,
	COLUMN_DEFINITIONS.ship_date,
	COLUMN_DEFINITIONS.products,
	COLUMN_DEFINITIONS.quantity,
	COLUMN_DEFINITIONS.notes,
	COLUMN_DEFINITIONS.tracking_numbers,
	COLUMN_DEFINITIONS.updateRecord,
	COLUMN_DEFINITIONS.subtotal,
];

/**
 * @type {ColumnDefinition[]}
 */
const unknownShipDateColumns = [
	COLUMN_DEFINITIONS.salesperson,
	COLUMN_DEFINITIONS.mts_number,
	COLUMN_DEFINITIONS.account_name,
	COLUMN_DEFINITIONS.invoice_date,
	COLUMN_DEFINITIONS.products,
	COLUMN_DEFINITIONS.quantity,
	COLUMN_DEFINITIONS.notes,
	COLUMN_DEFINITIONS.tracking_numbers,
	COLUMN_DEFINITIONS.subtotal,
];


/**
 * @type {HTMLTableSectionElement}
 */
const SHIP_LOG_BODY = document.getElementById('ship_log_body');
/**
 * @type {HTMLTableRowElement}
 */
const SHIP_LOG_HEADER_ROW = document.getElementById('ship_log_header_row');
/**
 * @type {HTMLTableSectionElement}
 */
const UNKNOWN_SHIP_DATE_BODY = document.getElementById('unknown_ship_date_body');
/**
 * @type {HTMLTableRowElement}
 */
const UNKNOWN_SHIP_DATE_HEADER_ROW = document.getElementById('unknown_ship_date_header_row');
/**
 * @type {HTMLHeadingElement}
 */
const UNKNOWN_SHIP_DATE_TITLE = document.getElementById('unknown_ship_date_title');
/**
 * @type {HTMLTableElement}
 */
const UNKNOWN_SHIP_DATE_TABLE = document.getElementById('unknown_ship_date_table');

const filter = {};
const sort = {
	by: DEFAULT_SORT,
	order: 1,
};

const pagination = {
	entriesPerPage: 50,
	currentPage: 0,
	maxPages: 1
}

let totalValue = 0;
let initialLoad = true;
let updateElementsVisible = false;

init();

function init() {
	START_DATE_INPUT.value = searchParameters.startDate;
	getShipLog();
}

/**
 *
 * @param {(HTMLSelectElement|HTMLInputElement|HTMLButtonElement)} input
 */
function updateDateRange(input) {
	const isSelect = input.id.includes("select");
	const isStart = input.id.includes("start");
	const isEnd = input.id.includes("end");
	const isButton = input.id.includes('button');
	if (isSelect) {
		START_DATE_INPUT.hidden = true;
		END_DATE_INPUT.hidden = true;
		document.getElementById("custom_date_search").hidden = true;
		switch(input.value) {
			case "this_month":
				searchParameters.startDate = `${this_year.as_string}-${this_month.as_string}-01`;
				searchParameters.endDate = '';
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "this_year":
				searchParameters.startDate = `${this_year.as_string}-01-01`;
				searchParameters.endDate = '';
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "last_month":
				searchParameters.startDate = `${(last_month.as_number == 12) ? last_year.as_string : this_year.as_string}-${last_month.as_string}-01`;
				searchParameters.endDate = `${(last_month.as_number == 12) ? last_year.as_string : this_year.as_string}-${last_month.as_string}-${last_month.last_day}`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "last_year":
				searchParameters.startDate = `${last_year.as_string}-01-01`;
				searchParameters.endDate = `${last_year.as_string}-12-31`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "previous_30":
				searchParameters.startDate = `${(this_month.as_number == 1 && day_of_month.as_number < 30) ? last_year.as_string : this_year.as_string}-${(day_of_month.as_number < 30) ? last_month.as_string : this_month.as_string}-${(day_of_month.as_number < 30) ? day_of_month.as_string : '01'}`;
				searchParameters.endDate = `${this_year.as_string}-${this_month.as_string}-${day_of_month.as_string}`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "custom":
				START_DATE_INPUT.hidden = false;
				END_DATE_INPUT.hidden = false;
				document.getElementById("custom_date_search").hidden = false;
				break;
		}
	} else if (isStart) {
		searchParameters.startDate = input.value;
	} else if (isEnd) {
		searchParameters.endDate = input.value;
	}
	else if (isButton) {
		DATE_RANGE_SELECT.value = 'custom';
		START_DATE_INPUT.hidden = false;
		END_DATE_INPUT.hidden = false;
		document.getElementById("custom_date_search").hidden = false;

		const currentSearchYear = parseInt(searchParameters.startDate.substr(0, 4));
		const currentSearchMonth = parseInt(searchParameters.startDate.substr(5, 2));
		if (input.id.includes('next')) {
			const nextSearchMonth = (currentSearchMonth == 12) ? 1 : currentSearchMonth + 1;
			const nextSearchYear = (nextSearchMonth == 1) ? currentSearchYear + 1 : currentSearchYear;
			const nextSearchLastDay = getMonthDayCount(nextSearchMonth, nextSearchYear);

			const nextSearchMonthString = (nextSearchMonth < 10) ? '0' + nextSearchMonth.toString() : nextSearchMonth.toString();
			const nextSearchLastDayString = (nextSearchLastDay < 10) ? '0' + nextSearchLastDay.toString() : nextSearchLastDay.toString();

			searchParameters.startDate = `${nextSearchYear}-${nextSearchMonthString}-01`;
			searchParameters.endDate = `${nextSearchYear}-${nextSearchMonthString}-${nextSearchLastDayString}`;
			NEXT_MONTH_BUTTON.disabled = (nextSearchMonth == this_month.as_number && nextSearchYear == this_year.as_number);
		}
		else if (input.id.includes('previous')) {
			const nextSearchMonth = (currentSearchMonth == 1) ? 12 : currentSearchMonth - 1;
			const nextSearchYear = (nextSearchMonth == 12) ? currentSearchYear - 1 : currentSearchYear;
			const nextSearchLastDay = getMonthDayCount(nextSearchMonth, nextSearchYear);

			const nextSearchMonthString = (nextSearchMonth < 10) ? '0' + nextSearchMonth.toString() : nextSearchMonth.toString();
			const nextSearchLastDayString = (nextSearchLastDay < 10) ? '0' + nextSearchLastDay.toString() : nextSearchLastDay.toString();

			searchParameters.startDate = `${nextSearchYear}-${nextSearchMonthString}-01`;
			searchParameters.endDate = `${nextSearchYear}-${nextSearchMonthString}-${nextSearchLastDayString}`;
			NEXT_MONTH_BUTTON.disabled = (nextSearchMonth == this_month.as_number && nextSearchYear == this_year.as_number);
		}
		START_DATE_INPUT.value = searchParameters.startDate;
		END_DATE_INPUT.value = searchParameters.endDate;
		getShipLog();
	}
	START_DATE_INPUT.max = END_DATE_INPUT.value;
	END_DATE_INPUT.min = START_DATE_INPUT.value;
}

function getShipLog() {
	const url = `${CONTROLLER_BASE_URL}?m=get_tts_ship_log`, poststr = `startDate=${searchParameters.startDate}&endDate=${searchParameters.endDate}&salespersons=${searchParameters.salespersons.join(',')}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnShipLog);
	/**
	 * Get the records from Zoho
	 */
	function returnShipLog(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const getData = () => {
						try {
							return JSON.parse(http_request.response);
						} catch (e) {
							return http_request.response;
						}
					}
					const data = getData();
					//console.log(data);
					if (typeof data == 'object') {
						showSalespersonColumn = data['showSales'];
						const records = data['results'];
						const unknownShipDate = data['unknownShipDate'];
						if (records && typeof records == 'object') {
							SHIP_LOG_ARRAY.length = 0;
							for (const member in SHIP_LOG_DICT) {
								delete SHIP_LOG_DICT[member];
							}
							for (const record of records) {
								const newRecord = new ShipLogRecord(record);
								const order_id = record['order_id'];
								if (SHIP_LOG_DICT[order_id]) {
									SHIP_LOG_DICT[order_id].addProduct(newRecord.products[0]);
								} else {
									SHIP_LOG_DICT[order_id] = newRecord;
								}
							}
							for (const record in SHIP_LOG_DICT) {
								SHIP_LOG_ARRAY.push(SHIP_LOG_DICT[record]);
							}
							clearFilter();
							renderHeader();
							renderBody();
						} else {
							alert("No records found for given criteria.");
						}
						if (unknownShipDate && typeof unknownShipDate == 'object') {
							UNKNOWN_DATE_SHIP_LOG_ARRAY.length = 0;
							for (const member in UNKNOWN_DATE_SHIP_LOG_DICT) {
								delete UNKNOWN_DATE_SHIP_LOG_DICT[member];
							}
							for (const record of unknownShipDate) {
								const newRecord = new ShipLogRecord(record);
								const order_id = record['order_id'];
								if (UNKNOWN_DATE_SHIP_LOG_DICT[order_id]) {
									UNKNOWN_DATE_SHIP_LOG_DICT[order_id].addProduct(newRecord.products[0]);
								} else {
									UNKNOWN_DATE_SHIP_LOG_DICT[order_id] = newRecord;
								}
							}
							for (const record in UNKNOWN_DATE_SHIP_LOG_DICT) {
								UNKNOWN_DATE_SHIP_LOG_ARRAY.push(UNKNOWN_DATE_SHIP_LOG_DICT[record]);
							}
							clearFilter();
							renderHeader();
							renderBody();
						}
					} else {
						alert("No records found for given criteria.");
					}
					if (initialLoad) {
						setSort(DEFAULT_SORT);
					}
					else {
						sortRecords();
						renderBody();
					}
					initialLoad = false;
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}


function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortRecords();
	renderBody();
}

function sortRecords() {
	SHIP_LOG_ARRAY.sort((a, b) => sortFunction(a,b));
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
	function sortFunction(a,b) {
		if(isNaN(a[sort.by]) || sort.by == 'ship_date' || sort.by == 'invoice_date') {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}


/**
 *
 * @param {HTMLInputElement} input
 */
function filterInput(input) {
	filter[input.getAttribute('filter')] = input.value;
	const sameNameInputs = document.getElementsByClassName(input.getAttribute('filter') + '_filter');
	for(const elem of sameNameInputs) {
		elem.value = input.value;
	}
	renderBody();
}

function renderHeader() {
	SHIP_LOG_HEADER_ROW.innerHTML = '';
	UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML = '';
	for (const column of columns) {
		if (!showSalespersonColumn && column.identifier == "salesperson") {
			// Do nothing if salesperson column disabled
		} else {
			SHIP_LOG_HEADER_ROW.innerHTML += column.buildHeader();
		}
	}
	if (UNKNOWN_DATE_SHIP_LOG_ARRAY.length > 0) {
		for (const column of unknownShipDateColumns) {
			if (!showSalespersonColumn && column.identifier == "salesperson") {
				// Do nothing if salesperson column disabled
			} else {
				UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML += column.buildHeader();
			}
		}
		UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML += `<th class="header_cell">Get Updated Ship Date</th>`
	}
}

function renderBody(renewValidEntries = true) {
	if (renewValidEntries) {
		getValidEntries();
	}
	SHIP_LOG_BODY.innerHTML = '';
	UNKNOWN_SHIP_DATE_BODY.innerHTML = '';
	let shipLogRowNum = 0;
	for (let i = 0; i < pagination.entriesPerPage; i++) {
		const record = validEntries[i+(pagination.currentPage * pagination.entriesPerPage)];
		if (record) {
			// const numProducts = record.getNumProducts();
			const visibleProducts = record.getVisibleProducts();
			// SHIP_LOG_BODY.innerHTML += record.createRecordRow(showSalespersonColumn, shipLogRowNum);
			SHIP_LOG_BODY.appendChild(record.getMainRecordRow(showSalespersonColumn, shipLogRowNum, false));
			for (let j = 1; j < visibleProducts.length; j++) {
				SHIP_LOG_BODY.appendChild(record.getProductRow(shipLogRowNum, visibleProducts[j]));
			}
			shipLogRowNum++;
		}
	}
	if (validEntries.length > 0) {
		buildPageControls();
	}
	document.getElementById('range_total').innerHTML = `${totalValue.toLocaleString('en-US', {style: 'currency', currency: 'USD'})}`;
	let unknownDateRowNum = 0;
	if (UNKNOWN_DATE_SHIP_LOG_ARRAY.length > 0) {
		UNKNOWN_SHIP_DATE_TITLE.hidden = false;
		UNKNOWN_SHIP_DATE_TABLE.hidden = false;
		for (const record of UNKNOWN_DATE_SHIP_LOG_ARRAY) {
			let valid = true;
			for(const entry in filter) {
				if (filter[entry] == '') {
					delete filter[entry];
				} else if (record[entry] && filter[entry] && !record[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
					valid = false;
				}
			}
			if (valid) {
				const numProducts = record.getNumProducts();
				// UNKNOWN_SHIP_DATE_BODY.innerHTML += record.createRecordRow(showSalespersonColumn, unknownDateRowNum, true);
				UNKNOWN_SHIP_DATE_BODY.appendChild(record.getMainRecordRow(showSalespersonColumn, unknownDateRowNum, true));
				for (let j = 1; j < numProducts; j++) {
					UNKNOWN_SHIP_DATE_BODY.appendChild(record.getProductRow(unknownDateRowNum, j));
				}
				unknownDateRowNum++;
			}
		}
	}
	else {
		UNKNOWN_SHIP_DATE_TITLE.hidden = true;
		UNKNOWN_SHIP_DATE_TABLE.hidden = true;
	}
	setUpdateElementsVisible(updateElementsVisible);

	function buildPageControls() {
		const pageControls = document.getElementById('pages');
		pageControls.innerHTML = "";
		pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.max(pagination.currentPage - 1, 0)})" pnum="prev" class="select-page-button">&laquo;</li>`;
		for (let i = 0; i < pagination.maxPages; i++) {
			if (i == pagination.currentPage) {
				pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button active">${i+1}</li>`;
			} else {
				pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button">${i+1}</li>`;
			}
		}
		pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.min(pagination.currentPage + 1, pagination.maxPages - 1)})" pnum="next" class="select-page-button">&raquo;</li>`;
	}

}

function getMonthLastDay(year, month) {
	const num = new Date(year, month, 0).getDate().toString();
	return '0'.repeat(2 - num.length).concat(num);
}

function clearFilter() {
	for (const entry in filter) {
		delete filter[entry];
	}
}

function getValidEntries() {
	totalValue = 0;
	validEntries.length = 0;
	pagination.currentPage = 0;
	for (const record of SHIP_LOG_ARRAY) {
		for (const product of record.products) {
			product.visible = true;
		}
		let valid = true;
		for(const entry in filter) {
			if (filter[entry] == '') {
				delete filter[entry];
			}
			else if (entry == 'products') {
				valid = validateProducts(record, filter[entry]);
			}
			else if (record[entry] && filter[entry] && !record[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
				valid = false;
			}
		}
		if (valid) {
			if (isNaN(record.getSubtotal())) {
				console.log('nan detected');
				console.log(record);
			}
			else {
				totalValue += parseFloat(record.subtotal);
			}
			validEntries.push(record);
		}
	}
	pagination.maxPages = Math.ceil(validEntries.length / pagination.entriesPerPage);

	/**
	 * Filter valid products
	 * @param {ShipLogRecord} record Record to check
	 * @param {string} filterValue Value to filter on
	 */
	function validateProducts(record, filterValue) {
		let valid = false;
		for (const product of record.products) {
			if (product.filter.toLowerCase().includes(filterValue.toLowerCase())) {
				product.visible = true;
				valid = true;
			}
			else {
				product.visible = false;
			}
		}
		return valid;
	}
}

function setCurrentPage(num) {
	/**
	 * @type {HTMLCollectionOf<HTMLLIElement}
	 */
	const pageSelectButtons = document.getElementsByClassName('page-select-button');
	pagination.currentPage = num;
	renderBody(false);
}

function getUpdatedShipDate(zohoId) {
	const url = `${CONTROLLER_BASE_URL}?m=get_updated_zoho_ship_date`, poststr = `zoho_id=${zohoId}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnReply);
	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					setLoadingModalVisible(false);
					try {
						const data = JSON.parse(http_request.response);
						if (data['updated']) {
							getShipLog();
						}
					}
					catch (err) {
						console.error(err);
					}
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 *
 * @param {string} zohoId
 */
function refreshRecord(zohoId) {
	const url = `${CONTROLLER_BASE_URL}?m=zoho_refresh_record&zohoId=${zohoId}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, '', 'POST', returnReply);
	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					setLoadingModalVisible(false);
					getShipLog();
					break;
				default:
					alert(`Error with AJAX request. Request status: ${http_request.status}\nRequest response: ${http_request.response}`);
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 * Toggle the ship date editing on/off
 * @param {HTMLAnchorElement} editButton
 */
function toggleDisplayEdit(editButton) {
	const orderId = editButton.getAttribute('order_id');
	const dateDisplay = document.getElementById(`ship_date_display_${orderId}`);
	const editControls = document.getElementById(`ship_date_edit_controls_${orderId}`)
	const dateEdit = document.getElementById(`ship_date_edit_${orderId}`);
	/**
	 * @type {HTMLAnchorElement}
	 */
	const cancelButton = document.getElementById(`ship_date_cancel_${orderId}`)
	dateDisplay.hidden = !dateDisplay.hidden;
	editControls.hidden = !editControls.hidden;
	dateEdit.hidden = !dateEdit.hidden;
	const editIsDisplayed = !dateEdit.hidden;
	if (editIsDisplayed) {
		cancelButton.hidden = false;
	} else {
		cancelButton.hidden = true;
	}
}

/**
 * Saves ship date
 * @param {HTMLAnchorElement} saveButton
 */
function saveShipDate(saveButton) {
	const orderId = saveButton.getAttribute('order_id');
	const dateEdit = document.getElementById(`ship_date_edit_${orderId}`);
	const newDate = dateEdit.value;
	if (validateDate(newDate)) {
		const url = `${CONTROLLER_BASE_URL}?m=update_order_ship_date`;
		const poststr = `zoho_id=${saveButton.getAttribute('order_id')}&ship_date=${newDate}`;
		setLoadingModalVisible(true);
		makeAjaxRequest(url, poststr, 'POST', returnReply);
	}
	else {
		alert ('Invalid date entered.');
	}
	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					setLoadingModalVisible(false);
					getShipLog();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}

}

/**
 * Validates if a date is valid
 * @param {string} dateString
 */
function validateDate(dateString) {
	const datePattern = /^(\d{4}-\d{2}-\d{2})$/
	if (!datePattern.test(dateString)) {
		return false;
	}

	const monthLengths = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	if (isLeapYear(parseInt(dateString.substr(0, 4)))) {
		monthLengths[1] = 29;
	}
	const monthIndex = parseInt(dateString.substr(5, 2)) - 1;
	const days = parseInt(dateString.substr(8, 2));
	if (monthIndex > 11 || days > monthLengths[monthIndex]) {
		return false;
	}

	return true;

	/**
	 * Check if is a leap year
	 * @param {Number} year
	 */
	function isLeapYear(year) {
		if (year % 4 == 0) {
			if (year % 100 == 0 && year % 400 != 0) {
				return false;
			}
			else {
				return true;
			}
		}
		else {
			return false;
		}
	}
}

function toggleUpdateElementsVisible() {
	updateElementsVisible = !updateElementsVisible;
	setUpdateElementsVisible(updateElementsVisible);
}

/**
 *
 * @param {boolean} visible
 */
function setUpdateElementsVisible(visible) {
	/**
	 * @type {HTMLCollectionOf<HTMLTableCellElement>}
	 */
	const columnElements = document.getElementsByClassName('updateElement');
	for (const element of columnElements) {
		element.hidden = !visible;
	}
}

function generateCsv() {
	const rows = [generateCsvHeaderRow()];
	let subtotalSum = 0.0;
	let totalSum = 0.0;
	for (const entry of validEntries) {
		subtotalSum += entry.getSubtotal();
		totalSum += entry.getTotal();
		const entryRows = entry.getCsvRows();
		for (const row of entryRows) {
			rows.push(row);
		}
	}
	rows.push(generateSumRow(subtotalSum, totalSum));
	let csvContent = "data:text/csv;charset=utf-8," + rows.map(e => e.join(",")).join("\n");
	const encodedUri = encodeURI(csvContent);
	const link = document.createElement("a");
	link.setAttribute("href", encodedUri);
	link.setAttribute("download", `shiplog_export_${getTimestamp(new Date())}.csv`);
	document.body.appendChild(link); // Required for FF

	link.click();
	delete link;

	function generateCsvHeaderRow() {
		const headerRow = [
			'Salesperson',
			'MTS Number',
			'State',
			'Ship Date',
			'Subtotal',
			'Total'
		];
		return headerRow;
	}

	/**
	 *
	 * @param {number} subtotal
	 * @param {number} total
	 */
	function generateSumRow(subtotal, total) {
		const newRow = [`"Totals:"`, '', '', `"${subtotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})}"`, `"${total.toLocaleString('en-US', {style: 'currency', currency: 'USD'})}"`];
		return newRow;
	}

	/**
	 *
	 * @param {Date} time
	 */
	function getTimestamp(time) {
		let timestamp = time.getFullYear().toString();
		if (time.getMonth()+1 < 10) {
			timestamp += '0';
		}
		timestamp += (time.getMonth()+1).toString();
		if (time.getDate() < 10) {
			timestamp += '0';
		}
		timestamp += time.getDate().toString();
		if (time.getHours() < 10) {
			timestamp += '0';
		}
		timestamp += time.getHours().toString();
		if (time.getMinutes() < 10) {
			timestamp += '0';
		}
		timestamp += time.getMinutes().toString();
		if (time.getSeconds() < 10) {
			timestamp += '0';
		}
		timestamp += time.getSeconds().toString();

		return timestamp
	}
}

/**
 *
 * @param {KeyboardEvent} event
 * @param {HTMLInputElement} input
 */
function processMtsImportInput(event, input) {
	input.value = input.value.trim();
}

function fetchMtsData() {
	const mtsPattern = /^(MTS\d{5,6})$/
	/**
	 * @type {HTMLInputElement}
	 */
	const mtsInput = document.getElementById('mtsNumberImport');
	const mtsNumber = mtsInput.value.trim().toUpperCase();
	if (mtsPattern.test(mtsNumber)) {
		getMtsOrderFromZoho(mtsNumber);
	}
	else {
		alert("Invalid entry.");
	}
}

function getMtsOrderFromZoho(mtsNumber) {
	const url = `${CONTROLLER_BASE_URL}?m=zoho_refresh_record&mtsNumber=${mtsNumber}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, '', 'POST', returnReply);
	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					setLoadingModalVisible(false);
					getShipLog();
					break;
				default:
					alert(`Error with AJAX request. Request status: ${http_request.status}\nRequest response: ${http_request.response}`);
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 *
 * @param {number} month
 * @param {number} year
 */
function getMonthDayCount(month, year) {
	const monthLengths = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	if (isLeapYear(year)) {
		monthLengths[1] = 29;
	}
	return monthLengths[month-1];

	/**
	 * Check if is a leap year
	 * @param {Number} year
	 */
	function isLeapYear(year) {
		if (year % 4 == 0) {
			if (year % 100 == 0 && year % 400 != 0) {
				return false;
			}
			else {
				return true;
			}
		}
		else {
			return false;
		}
	}
}

/**
 *
 * @param {string} zohoId
 */
function addToDeductions(zohoId) {
	const url = `${CONTROLLER_BASE_URL}?m=addToDeductions&module=tts&view=shipped&id=${zohoId}`;
	fetch(url)
	.then(response => response.json())
	.then(data => {
		console.log(data);
		getShipLog();
	});
}
