class ReturnedOrder extends ShipLogRecord {
	constructor(data) {
		const superData = {
			/**
			 * @type {string}
			 */
			order_id : data['order_id'],
			/**
			 * @type {string}
			 */
			sales_channel_identifier : data['sales_channel_identifier'],
			/**
			 * @type {string}
			 */
			sales_channel_name : data['sales_channel_name'],
			ship_date : new Date(`${data['return_date'].replace(' ', 'T')}`),
			subtotal : parseFloat(data['return_amount']) * -1,
			isReturn : true,
		}
		super(superData);
	}
}
