class NeweggShippedOrder extends ShipLogRecord {
	constructor(jsonRecord) {
		super(jsonRecord);
		this.products = (jsonRecord['newegg_item_number']) ? [{sku : jsonRecord['sku'], quantity : jsonRecord['quantity'], newegg_item_number: jsonRecord['newegg_item_number'], title : jsonRecord['title'], visible : true}] : [];
	}


	getOrderIdLink() {
		return `<a href='https://sellerportal.newegg.com/manage-order/orderlist' target='_blank'>${this.getOrderId()}</a>`;
	}
	addProduct({sku, quantity, newegg_item_number, title}) {
		if (newegg_item_number && quantity) {
			const visible = true;
			this.products.push({sku, quantity, newegg_item_number, title, visible});
		}
	}
}
