class EbayShippedOrder extends ShipLogRecord {
	constructor(jsonRecord) {
		super(jsonRecord);
		this.products = (jsonRecord['legacy_item_id']) ? [{sku : jsonRecord['sku'], quantity : jsonRecord['quantity'], legacy_item_id: jsonRecord['legacy_item_id'], title : jsonRecord['title'], visible : true}] : [];
	}


	getOrderIdLink() {
		return `<a href='https://www.ebay.com/sh/ord/details?orderid=${this.getOrderId()}' target='_blank'>${this.getOrderId()}</a>`;
	}
	addProduct({sku, quantity, legacy_item_id, title}) {
		if (legacy_item_id && quantity) {
			const visible = true;
			this.products.push({sku, quantity, legacy_item_id, title, visible});
		}
	}
}
