class AmazonShippedOrder extends ShipLogRecord {
	constructor(jsonRecord) {
		super(jsonRecord);
		this.products = (jsonRecord['order_item_id']) ? [{sku : jsonRecord['sku'], quantity : jsonRecord['quantity'], order_item_id: jsonRecord['order_item_id'], title : jsonRecord['title'], visible : true }] : [];
	}

	getOrderIdLink() {
		return `<a href='https://sellercentral.amazon.com/orders-v3/order/${this.getOrderId()}' target='_blank'>${this.getOrderId()}</a>`;
	}
}
