const CONTROLLER_BASE_URL = 'admin_controller.php';

const SORT_ASC_URL = '../svg/sort_asc_white.svg';
const SORT_DESC_URL = '../svg/sort_desc_white.svg';
const SORT_NONE_URL = '../svg/sort_white.svg';
const DEFAULT_SORT = 'ship_date';

/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');



setLoadingModalVisible(false);



const TODAY = new Date();

const this_year = {
	as_number : TODAY.getFullYear(),
	as_string : TODAY.getFullYear().toString()
}
const last_year = {
	as_number : TODAY.getFullYear() - 1,
	as_string : ''
}
last_year.as_string = last_year.as_number.toString();
const this_month = {
	as_number : TODAY.getMonth() + 1,
	as_string : '',
};
this_month.as_string =  '0'.repeat(2 - this_month.as_number.toString().length).concat(this_month.as_number.toString())
const last_month = {
	as_number : (TODAY.getMonth() > 1) ? TODAY.getMonth() : 12,
	as_string : '',
	last_day : ''
};
last_month.as_string = '0'.repeat(2 - last_month.as_number.toString().length).concat(last_month.as_number.toString());
last_month.last_day = getMonthLastDay((last_month.as_number == 12) ? last_year.as_number : this_year.as_number, last_month.as_number);
const day_of_month = {
	as_number : TODAY.getDate(),
	as_string : '0'.repeat(2 - TODAY.getDate().toString().length).concat(TODAY.getDate().toString())
};

const searchParameters = {
	startDate : `${this_year.as_string}-${this_month.as_string}-01`,
	endDate : ''
};



const SHIP_LOG_DICT = {
	sales : {},
	returns : {}
};

/**
 * @type {ShipLogRecord[]}
 */
const SHIP_LOG_ARRAY = [];

/**
 * @type {ShipLogRecord[]}
 */
const validEntries = [];


const UNKNOWN_DATE_SHIP_LOG_DICT = {};

/**
 * @type {ShipLogRecord[]}
 */
const UNKNOWN_DATE_SHIP_LOG_ARRAY = [];

/**
 * @type {HTMLSelectElement}
 */
const DATE_RANGE_SELECT = document.getElementById('date_range_select');
/**
 * @type {HTMLInputElement}
 */
const START_DATE_INPUT = document.getElementById('start_date_input');
/**
 * @type {HTMLInputElement}
 */
const END_DATE_INPUT = document.getElementById('end_date_input');
/**
 * @type {HTMLButtonElement}
 */
const NEXT_MONTH_BUTTON = document.getElementById("next_month_button");
/**
 * @type {HTMLButtonElement}
 */
const PREVIOUS_MONTH_BUTTON = document.getElementById("previous_month_button");

START_DATE_INPUT.max = TODAY.toJSON().substring(1, TODAY.toJSON().indexOf('T'));

END_DATE_INPUT.max = START_DATE_INPUT.max;

const COLUMN_DEFINITIONS = {
	sales_channel_name: new ColumnDefinition('Channel', 'sales_channel_name', {isSortable: true, isFilterable: true}),
	order_id: new ColumnDefinition('Order ID', 'order_id', {isSortable: true, isFilterable: true}),
	// account_name: new ColumnDefinition('School', 'account_name', {isSortable: true, isFilterable: true}),
	invoice_date: new ColumnDefinition('Invoice Date', 'invoice_date', {isSortable: true}),
	ship_date: new ColumnDefinition('Ship Date', 'ship_date', {isSortable: true}),
	ship_method: new ColumnDefinition('Ship Method', 'ship_method', {isSortable: true, isFilterable: true}),
	products: new ColumnDefinition('SKU', 'products', {isFilterable : true}),
	quantity: new ColumnDefinition('Quantity', 'quantity'),
	notes: new ColumnDefinition('Notes', 'notes'),
	tracking_numbers: new ColumnDefinition('Tracking Numbers', 'tracking_numbers'),
	subtotal: new ColumnDefinition('Subtotal', 'subtotal', {isSortable: true}),
	orderType: new ColumnDefinition('Order Type', 'orderType', {isSortable: true, isFilterable: true})
};

/**
 * @type {ColumnDefinition[]}
 */
const columns = [
	COLUMN_DEFINITIONS.sales_channel_name,
	COLUMN_DEFINITIONS.order_id,
	COLUMN_DEFINITIONS.orderType,
	COLUMN_DEFINITIONS.account_name,
	COLUMN_DEFINITIONS.ship_date,
	COLUMN_DEFINITIONS.products,
	COLUMN_DEFINITIONS.quantity,
	COLUMN_DEFINITIONS.ship_method,
	COLUMN_DEFINITIONS.tracking_numbers,
	COLUMN_DEFINITIONS.subtotal,
];


/**
 * @type {HTMLTableSectionElement}
 */
const SHIP_LOG_BODY = document.getElementById('ship_log_body');
/**
 * @type {HTMLTableRowElement}
 */
const SHIP_LOG_HEADER_ROW = document.getElementById('ship_log_header_row');
/**
 * @type {HTMLTableSectionElement}
 */
const UNKNOWN_SHIP_DATE_BODY = document.getElementById('unknown_ship_date_body');
/**
 * @type {HTMLTableRowElement}
 */
const UNKNOWN_SHIP_DATE_HEADER_ROW = document.getElementById('unknown_ship_date_header_row');
/**
 * @type {HTMLHeadingElement}
 */
const UNKNOWN_SHIP_DATE_TITLE = document.getElementById('unknown_ship_date_title');
/**
 * @type {HTMLTableElement}
 */
const UNKNOWN_SHIP_DATE_TABLE = document.getElementById('unknown_ship_date_table');

const filter = {};
const sort = {
	by: DEFAULT_SORT,
	order: 1,
};

const pagination = {
	entriesPerPage: 50,
	currentPage: 0,
	maxPages: 1
}

let totalValue = 0;
let firstLoad = true;


init();

function init() {
	START_DATE_INPUT.value = searchParameters.startDate;
	getShipLog();
}

/**
 *
 * @param {(HTMLSelectElement|HTMLInputElement|HTMLButtonElement)} input
 */
function updateDateRange(input) {
	const isSelect = input.id.includes("select");
	const isStart = input.id.includes("start");
	const isEnd = input.id.includes("end");
	const isButton = input.id.includes('button');
	if (isSelect) {
		START_DATE_INPUT.hidden = true;
		END_DATE_INPUT.hidden = true;
		document.getElementById("custom_date_search").hidden = true;
		switch(input.value) {
			case "this_month":
				searchParameters.startDate = `${this_year.as_string}-${this_month.as_string}-01`;
				searchParameters.endDate = '';
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "this_year":
				searchParameters.startDate = `${this_year.as_string}-01-01`;
				searchParameters.endDate = '';
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "last_month":
				searchParameters.startDate = `${(last_month.as_number == 12) ? last_year.as_string : this_year.as_string}-${last_month.as_string}-01`;
				searchParameters.endDate = `${(last_month.as_number == 12) ? last_year.as_string : this_year.as_string}-${last_month.as_string}-${last_month.last_day}`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "last_year":
				searchParameters.startDate = `${last_year.as_string}-01-01`;
				searchParameters.endDate = `${last_year.as_string}-12-31`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "previous_30":
				searchParameters.startDate = `${(this_month.as_number == 1 && day_of_month.as_number < 30) ? last_year.as_string : this_year.as_string}-${(day_of_month.as_number < 30) ? last_month.as_string : this_month.as_string}-${(day_of_month.as_number < 30) ? day_of_month.as_string : '01'}`;
				searchParameters.endDate = `${this_year.as_string}-${this_month.as_string}-${day_of_month.as_string}`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getShipLog();
				break;
			case "custom":
				START_DATE_INPUT.hidden = false;
				END_DATE_INPUT.hidden = false;
				document.getElementById("custom_date_search").hidden = false;
				break;
		}
	} else if (isStart) {
		searchParameters.startDate = input.value;
	} else if (isEnd) {
		searchParameters.endDate = input.value;
	}
	else if (isButton) {
		DATE_RANGE_SELECT.value = 'custom';
		START_DATE_INPUT.hidden = false;
		END_DATE_INPUT.hidden = false;
		document.getElementById("custom_date_search").hidden = false;

		const currentSearchYear = parseInt(searchParameters.startDate.substr(0, 4));
		const currentSearchMonth = parseInt(searchParameters.startDate.substr(5, 2));
		if (input.id.includes('next')) {
			const nextSearchMonth = (currentSearchMonth == 12) ? 1 : currentSearchMonth + 1;
			const nextSearchYear = (nextSearchMonth == 1) ? currentSearchYear + 1 : currentSearchYear;
			const nextSearchLastDay = getMonthDayCount(nextSearchMonth, nextSearchYear);

			const nextSearchMonthString = (nextSearchMonth < 10) ? '0' + nextSearchMonth.toString() : nextSearchMonth.toString();
			const nextSearchLastDayString = (nextSearchLastDay < 10) ? '0' + nextSearchLastDay.toString() : nextSearchLastDay.toString();

			searchParameters.startDate = `${nextSearchYear}-${nextSearchMonthString}-01`;
			searchParameters.endDate = `${nextSearchYear}-${nextSearchMonthString}-${nextSearchLastDayString}`;
			NEXT_MONTH_BUTTON.disabled = (nextSearchMonth == this_month.as_number && nextSearchYear == this_year.as_number);
		}
		else if (input.id.includes('previous')) {
			const nextSearchMonth = (currentSearchMonth == 1) ? 12 : currentSearchMonth - 1;
			const nextSearchYear = (nextSearchMonth == 12) ? currentSearchYear - 1 : currentSearchYear;
			const nextSearchLastDay = getMonthDayCount(nextSearchMonth, nextSearchYear);

			const nextSearchMonthString = (nextSearchMonth < 10) ? '0' + nextSearchMonth.toString() : nextSearchMonth.toString();
			const nextSearchLastDayString = (nextSearchLastDay < 10) ? '0' + nextSearchLastDay.toString() : nextSearchLastDay.toString();

			searchParameters.startDate = `${nextSearchYear}-${nextSearchMonthString}-01`;
			searchParameters.endDate = `${nextSearchYear}-${nextSearchMonthString}-${nextSearchLastDayString}`;
			NEXT_MONTH_BUTTON.disabled = (nextSearchMonth == this_month.as_number && nextSearchYear == this_year.as_number);
		}
		START_DATE_INPUT.value = searchParameters.startDate;
		END_DATE_INPUT.value = searchParameters.endDate;
		getShipLog();
	}
	START_DATE_INPUT.max = END_DATE_INPUT.value;
	END_DATE_INPUT.min = START_DATE_INPUT.value;
}

function getShipLog() {
	const url = `${CONTROLLER_BASE_URL}?m=get_ecomm_ship_log`, poststr = `startDate=${searchParameters.startDate}&endDate=${searchParameters.endDate}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnShipLog);
	/**
	 * Get the records from Zoho
	 */
	function returnShipLog(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const getData = () => {
						try {
							return JSON.parse(http_request.response);
						} catch (e) {
							return http_request.response;
						}
					}
					const data = getData();
					if (typeof data == 'object') {
						const records = data['results'];
						const returns = data['returns'];
						if (records && typeof records == 'object') {
							SHIP_LOG_ARRAY.length = 0;
							for (const member in SHIP_LOG_DICT.sales) {
								delete SHIP_LOG_DICT.sales[member];
							}
							for (const member in SHIP_LOG_DICT.returns) {
								delete SHIP_LOG_DICT.returns[member];
							}
							for (const record of records) {
								if (record['sales_channel_identifier'] == 'chanx') {
									//console.log(record);
								}
								// const newRecord = new ShipLogRecord(record);
								const newRecord = getRecordObject(record);
								// console.log(newRecord);
								const order_id = record['order_id'];
								if (SHIP_LOG_DICT.sales[order_id]) {
									if (newRecord.products[0]) {
										SHIP_LOG_DICT.sales[order_id].addProduct(newRecord.products[0]);
									}
								} else {
									SHIP_LOG_DICT.sales[order_id] = newRecord;
								}
							}
							for (const record of returns) {
								const newRecord = new ReturnedOrder(record);
								const orderId = record['order_id'];
								SHIP_LOG_DICT.returns[orderId] = newRecord;
							}
							for (const record in SHIP_LOG_DICT.sales) {
								SHIP_LOG_ARRAY.push(SHIP_LOG_DICT.sales[record]);
							}
							for (const record in SHIP_LOG_DICT.returns) {
								SHIP_LOG_ARRAY.push(SHIP_LOG_DICT.returns[record]);
							}
							clearFilter();
							renderHeader();
							renderBody();
						} else {
							alert("No records found for given criteria.");
						}
					} else {
						alert("No records found for given criteria.");
					}
					if (firstLoad) {
						setSort(DEFAULT_SORT);
					}
					else {
						sortRecords();
						renderBody();
					}
					setLoadingModalVisible(false);
					firstLoad = false;
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
	function getRecordObject(record) {
		/**
		 * @type {string}
		 */
		const salesChannel = record['sales_channel_identifier'];
		if (salesChannel == 'back_market') {
			return new BackMarketShippedOrder(record);
		} else if (salesChannel.startsWith('ebay')) {
			return new EbayShippedOrder(record);
		} else if (salesChannel == 'newegg') {
			return new NeweggShippedOrder(record);
		} else if (salesChannel == 'amazon') {
			return new AmazonShippedOrder(record);
		}
		else {
			//console.log(record);
			return new ShipLogRecord(record);
		}
	}
}


function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortRecords();
	renderBody();
}

function sortRecords() {
	SHIP_LOG_ARRAY.sort((a, b) => sortFunction(a,b));
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
	function sortFunction(a,b) {
		if(isNaN(a[sort.by]) || sort.by == 'ship_date' || sort.by == 'invoice_date') {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}


/**
 *
 * @param {HTMLInputElement} input
 */
function filterInput(input) {
	filter[input.getAttribute('filter')] = input.value;
	const sameNameInputs = document.getElementsByClassName(input.getAttribute('filter') + '_filter');
	for(const elem of sameNameInputs) {
		elem.value = input.value;
	}
	renderBody();
}

function renderHeader() {
	SHIP_LOG_HEADER_ROW.innerHTML = '';
	UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML = '';
	for (const column of columns) {
		SHIP_LOG_HEADER_ROW.innerHTML += column.buildHeader();
	}
	if (UNKNOWN_DATE_SHIP_LOG_ARRAY.length > 0) {
		for (const column of columns) {
			UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML += column.buildHeader();
		}
		UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML += `<th class="header_cell">Get Updated Ship Date</th>`
	}
}

function renderBody(renewValidEntries = true) {
	if (renewValidEntries) {
		getValidEntries();
	}
	SHIP_LOG_BODY.innerHTML = '';
	UNKNOWN_SHIP_DATE_BODY.innerHTML = '';
	let shipLogRowNum = 0;
	for (let i = 0; i < pagination.entriesPerPage; i++) {
		const record = validEntries[i+(pagination.currentPage * pagination.entriesPerPage)];
		if (record) {
			SHIP_LOG_BODY.innerHTML += record.createRecordRow(shipLogRowNum);
			shipLogRowNum++;
		}
	}
	if (validEntries.length > 0) {
		buildPageControls();
	}
	document.getElementById('range_total').innerHTML = `$${Math.round(totalValue).toLocaleString()}`;
	let unknownDateRowNum = 0;
	if (UNKNOWN_DATE_SHIP_LOG_ARRAY.length > 0) {
		UNKNOWN_SHIP_DATE_TITLE.hidden = false;
		UNKNOWN_SHIP_DATE_TABLE.hidden = false;
		for (const record of UNKNOWN_DATE_SHIP_LOG_ARRAY) {
			let valid = true;
			for(const entry in filter) {
				if (filter[entry] == '') {
					delete filter[entry];
				} else if (record[entry] && filter[entry] && !record[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
					valid = false;
				}
			}
			if (valid) {
				UNKNOWN_SHIP_DATE_BODY.innerHTML += record.createRecordRow(unknownDateRowNum, true);
				unknownDateRowNum++;
			}
		}
	}
	else {
		UNKNOWN_SHIP_DATE_TITLE.hidden = true;
		UNKNOWN_SHIP_DATE_TABLE.hidden = true;
	}

	function buildPageControls() {
		const pageControls = document.getElementById('pages');
		pageControls.innerHTML = "";
		pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.max(pagination.currentPage - 1, 0)})" pnum="prev" class="select-page-button">&laquo;</li>`;
		for (let i = 0; i < pagination.maxPages; i++) {
			if (i == pagination.currentPage) {
				pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button active">${i+1}</li>`;
			} else {
				pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button">${i+1}</li>`;
			}
		}
		pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.min(pagination.currentPage + 1, pagination.maxPages - 1)})" pnum="next" class="select-page-button">&raquo;</li>`;
	}

}

function getMonthLastDay(year, month) {
	const num = new Date(year, month, 0).getDate().toString();
	return '0'.repeat(2 - num.length).concat(num);
}

function clearFilter() {
	for (const entry in filter) {
		delete filter[entry];
	}
}

function getValidEntries() {
	totalValue = 0;
	validEntries.length = 0;
	pagination.currentPage = 0;
	for (const record of SHIP_LOG_ARRAY) {
		for (const product of record.products) {
			product.visible = true;
		}
		let valid = true;
		for(const entry in filter) {
			if (filter[entry] == '') {
				delete filter[entry];
			}
			else if (entry == 'products') {
				valid = validateProducts(record, filter[entry]);
			}
			else if (record[entry] && filter[entry] && !record[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
				valid = false;
			}
		}
		if (valid) {
			totalValue += parseFloat(record.subtotal);
			validEntries.push(record);
		}
	}
	pagination.maxPages = Math.ceil(validEntries.length / pagination.entriesPerPage);

	/**
	 * Filter valid products
	 * @param {ShipLogRecord} record Record to check
	 * @param {string} filterValue Value to filter on
	 */
	function validateProducts(record, filterValue) {
		let valid = false;
		for (const product of record.products) {
			if (product.sku && product.sku.toLowerCase().includes(filterValue.toLowerCase())) {
				product.visible = true;
				valid = true;
			}
			else {
				product.visible = false;
			}
		}
		return valid;
	}
}

function setCurrentPage(num) {
	/**
	 * @type {HTMLCollectionOf<HTMLLIElement}
	 */
	const pageSelectButtons = document.getElementsByClassName('page-select-button');
	pagination.currentPage = num;
	renderBody(false);
}

/**
 *
 * @param {number} month
 * @param {number} year
 */
function getMonthDayCount(month, year) {
	const monthLengths = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	if (isLeapYear(year)) {
		monthLengths[1] = 29;
	}
	return monthLengths[month-1];

	/**
	 * Check if is a leap year
	 * @param {Number} year
	 */
	function isLeapYear(year) {
		if (year % 4 == 0) {
			if (year % 100 == 0 && year % 400 != 0) {
				return false;
			}
			else {
				return true;
			}
		}
		else {
			return false;
		}
	}
}


function generateCsv() {
	const rows = [generateCsvHeaderRow()];
	let subtotalSum = 0.0;
	for (const entry of validEntries) {
		subtotalSum += entry.getSubtotal();
		const entryRows = entry.getCsvRow();
		for (const row of entryRows) {
			rows.push(row);
		}
	}
	rows.push(generateSumRow(subtotalSum));
	let csvContent = "data:text/csv;charset=utf-8," + rows.map(e => e.join(",")).join("\n");
	const encodedUri = encodeURI(csvContent);
	const link = document.createElement("a");
	link.setAttribute("href", encodedUri);
	link.setAttribute("download", `ecomm_shiplog_export_${getTimestamp(new Date())}.csv`);
	document.body.appendChild(link); // Required for FF

	link.click();
	delete link;

	function generateCsvHeaderRow() {
		const headerRow = [
			'Channel',
			'Order ID',
			'Order Type',
			'Ship Date',
			'SKU',
			'Quantity',
			'Subtotal'
		];
		return headerRow;
	}

	/**
	 *
	 * @param {number} subtotal
	 */
	function generateSumRow(subtotal) {
		const newRow = [`"Total:"`, '', '', '', `"${subtotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})}"`];
		return newRow;
	}

	/**
	 *
	 * @param {Date} time
	 */
	function getTimestamp(time) {
		let timestamp = time.getFullYear().toString();
		if (time.getMonth()+1 < 10) {
			timestamp += '0';
		}
		timestamp += (time.getMonth()+1).toString();
		if (time.getDate() < 10) {
			timestamp += '0';
		}
		timestamp += time.getDate().toString();
		if (time.getHours() < 10) {
			timestamp += '0';
		}
		timestamp += time.getHours().toString();
		if (time.getMinutes() < 10) {
			timestamp += '0';
		}
		timestamp += time.getMinutes().toString();
		if (time.getSeconds() < 10) {
			timestamp += '0';
		}
		timestamp += time.getSeconds().toString();

		return timestamp
	}
}
