const CONTROLLER_BASE_URL = 'admin_controller.php';
const SORT_ASC_URL = '../svg/sort_asc.svg';
const SORT_DESC_URL = '../svg/sort_desc.svg';
const SORT_NONE_URL = '../svg/sort.svg';
const DEFAULT_SORT = 'oNum';

const columnDefs = {
	salesRep: new ColumnDefinition('Sales', 'salesRep', {isSortable: true, isFilterable: true}),
	oNum: new ColumnDefinition('Order', 'oNum', {isSortable: true, isFilterable: true}),
	organization: new ColumnDefinition('School', 'organization', {isSortable: true, isFilterable: true}),
	dateCreation: new ColumnDefinition('Created', 'dateCreation', {isSortable: true, isFilterable: true}),
	problem: new ColumnDefinition('Service Requested', 'problemn'),
	warrantyId: new ColumnDefinition('Warranty', 'warrantyId', {isSortable: true, isFilterable: true}),
	notes: new ColumnDefinition('Notes', 'notes'),
	status: new ColumnDefinition('Status', 'status'),
	warrantyCheckbox: new ColumnDefinition('W', 'warrantyId'),
	warrantyPlusCheckbox: new ColumnDefinition('W+', 'warrantyId'),
	cameWithACCheckbox: new ColumnDefinition('AC', 'oACAdapter')
}

const columns = {
	/**
	 * @type {ColumnDefinition[]}
	 */
	default : [
		columnDefs.salesRep,
		columnDefs.oNum,
		columnDefs.organization,
		columnDefs.dateCreation,
		columnDefs.problem,
		// columnDefs.warrantyId,
		columnDefs.cameWithACCheckbox,
		columnDefs.warrantyCheckbox,
		columnDefs.warrantyPlusCheckbox,
		columnDefs.notes,
		columnDefs.status,
	]
}

const recordDict = {};
const recordArrays = {
	/**
	 * @type {ServiceRequest[]}
	 */
	newOrder : [],
	/**
	 * @type {ServiceRequest[]}
	 */
	labelSent : [],
	/**
	 * @type {ServiceRequest[]}
	 */
	boxSent : [],
	/**
	 * @type {ServiceRequest[]}
	 */
	received : [],
	/**
	 * @type {ServiceRequest[]}
	 */
	readyToShip : [],
	/**
	 * @type {ServiceRequest[]}
	 */
	replacement : []
};
let unsavedChanges = false;
const sort = {
	by: 'oNum',
	order: 1
};
const pageElements = {
	newOrder : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('new_order_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('new_order_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('new_order_body')
	},
	labelSent : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('label_sent_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('label_sent_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('label_sent_body')
	},
	boxSent : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('box_sent_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('box_sent_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('box_sent_body')
	},
	received : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('received_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('received_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('received_body')
	},
	diagnosticComplete : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('diagnostic_complete_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('diagnostic_complete_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('diagnostic_complete_body')
	},
	approvedDeclined : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('approved_declined_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('approved_declined_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('approved_declined_body')
	},
	readyToShip : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('ready_to_ship_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('ready_to_ship_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('ready_to_ship_body')
	},
	replacement : {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		heading : document.getElementById('replacement_heading'),
		/**
		 * @type {HTMLTableRowElement}
		 */
		headerRow : document.getElementById('replacement_header_row'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		body : document.getElementById('replacement_body')
	},
}

/**
 * @type {WarrantyType[]}
 */
const warrantyTypes = [];

/**
 * @type {Salesperson[]}
 */
const salespeople = [];


/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');

init();

function init() {
	setLoadingModalVisible(false);
	getServiceRequests();
}

function getServiceRequests() {
	const url = `${CONTROLLER_BASE_URL}?m=get_service_requests`, poststr = `type=open`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnRecords);
	function returnRecords() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					try {
						const data = JSON.parse(http_request.response);
						const serviceRequests = data['serviceRequests'];
						const rawWarrantyTypes = data['warrantyTypes'];
						const rawSalespeople = data['salespeople'];
						try {
							for (const warrantyType of rawWarrantyTypes) {
								warrantyTypes.push(new WarrantyType(warrantyType));
							}
						}
						catch (e) {
							console.error(e);
							alert(e);
							console.log(rawWarrantyTypes);
						}
						try {
							for (const salesperson of rawSalespeople) {
								salespeople.push(new Salesperson(salesperson));
							}
						}
						catch (e) {
							console.error(e);
							alert(e);
							console.log(rawSalespeople);
						}
						try {
							for (const status in serviceRequests) {
								recordArrays[status] = [];
								for (const record of serviceRequests[status]) {
									const serviceRequest = new ServiceRequest(record);
									recordDict[serviceRequest.getONum()] = serviceRequest;
									recordArrays[status].push(serviceRequest);
								}
							}
						}
						catch (e) {
							console.error(e);
							alert(e);
							console.log(serviceRequests);
						}
					}
					catch (e) {
						console.error(e);
						alert(e);
						console.log(http_request.response);
					}
					renderHeaders();
					renderBodies();
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

function renderHeaders() {
	if (recordArrays.newOrder.length > 0) {
		pageElements.newOrder.heading.hidden = false;
		renderHeaderRow('newOrder');
	}
	else {
		pageElements.newOrder.heading.hidden = true;
	}
	if (recordArrays.labelSent.length > 0) {
		pageElements.labelSent.heading.hidden = false;
		renderHeaderRow('labelSent');
	}
	else {
		pageElements.labelSent.heading.hidden = true;
	}
	if (recordArrays.boxSent.length > 0) {
		pageElements.boxSent.heading.hidden = false;
		renderHeaderRow('boxSent');
	}
	else {
		pageElements.boxSent.heading.hidden = true;
	}
	if (recordArrays.received.length > 0) {
		pageElements.received.heading.hidden = false;
		renderHeaderRow('received');
	}
	else {
		pageElements.received.heading.hidden = true;
	}
	if (recordArrays.diagnosticComplete.length > 0) {
		pageElements.diagnosticComplete.heading.hidden = false;
		renderHeaderRow('diagnosticComplete');
	}
	else {
		pageElements.diagnosticComplete.heading.hidden = true;
	}
	if (recordArrays.approvedDeclined.length > 0) {
		pageElements.approvedDeclined.heading.hidden = false;
		renderHeaderRow('approvedDeclined');
	}
	else {
		pageElements.approvedDeclined.heading.hidden = true;
	}
	if (recordArrays.readyToShip.length > 0) {
		pageElements.readyToShip.heading.hidden = false;
		renderHeaderRow('readyToShip');
	}
	else {
		pageElements.readyToShip.heading.hidden = true;
	}
	if (recordArrays.replacement.length > 0) {
		pageElements.replacement.heading.hidden = false;
		renderHeaderRow('replacement');
	}
	else {
		pageElements.replacement.heading.hidden = true;
	}

	/**
	 *
	 * @param {string} status
	 */
	function renderHeaderRow(status) {
		/**
		 * @type {HTMLTableRowElement}
		 */
		const headerRow = pageElements[status].headerRow;

		headerRow.innerHTML = '';
		for (const column of columns.default) {
			// headerRow.innerHTML += column.buildHeader();
			headerRow.appendChild(column.getHeaderCellElement());
		}
		headerRow.appendChild(generateActionHeader());


		function generateActionHeader() {
			const headerCell = document.createElement('th');
			const button = document.createElement('button');
			headerCell.appendChild(button);
			button.innerText = "Save All Changes";
			button.setAttribute('onclick', 'saveAllChanges(this)');
			return headerCell;
		}
	}
}

function renderBodies() {
	for (const status in recordArrays) {
		try {
			/**
			 * @type {HTMLTableSectionElement}
			 */
			const body = pageElements[status].body;
			/**
			 * @type {ServiceRequest[]}
			 */
			const recordArr = recordArrays[status];
			body.innerHTML = '';
			for (const record of recordArr) {
				body.appendChild(record.generateRow());
				// body.innerHTML += record.generateRow();
			}
		}
		catch (e) {
			console.error(e);
			console.error(status);
		}
	}

	function renderBody(status) {
		/**
		 * @type {HTMLTableHeaderCellElement}
		 */
		const heading = pageElements[status].heading;
		/**
		 * @type {HTMLTableRowElement}
		 */
		const headerRow = pageElements[status].headerRow;
		/**
		 * @type {HTMLTableSectionElement}
		 */
		const body = pageElements[status].body;
	}
}

function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortRecords();
	renderBodies();
}

function sortRecords() {
	// recordArrays.newOrder.sort((a,b)=>sortFunction(a,b));
	// recordArrays.labelSent.sort((a,b)=>sortFunction(a,b));
	// recordArrays.boxSent.sort((a,b)=>sortFunction(a,b));
	// recordArrays.received.sort((a,b)=>sortFunction(a,b));
	// recordArrays.readyToShip.sort((a,b)=>sortFunction(a,b));
	// recordArrays.replacement.sort((a,b)=>sortFunction(a,b));

	for (const type in recordArrays) {
		recordArrays[type].sort((a,b)=>sortFunction(a,b));
	}
	// recordArray.sort((a, b) => sortFunction(a,b));
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
	function sortFunction(a,b) {
		if(a[sort.by] instanceof Date && b[sort.by] instanceof Date) {
			/**
			 * @type {Date}
			 */
			const aDate = a[sort.by];
			/**
			 * @type {Date}
			 */
			const bDate = b[sort.by];
			if(aDate.getTime() < bDate.getTime()) {
				return -1 * sort.order;
			}
			else if(aDate.getTime() > bDate.getTime()) {
				return 1 * sort.order;
			}
		}
		else if (a[sort.by] instanceof Salesperson && b[sort.by] instanceof Salesperson) {
			/**
			 * @type {Salesperson}
			 */
			const aSales = a[sort.by];
			/**
			 * @type {Salesperson}
			 */
			const bSales = b[sort.by];
			const aId = (aSales.getId()) ? parseInt(aSales.getId()) : 0;
			const bId = (bSales.getId()) ? parseInt(bSales.getId()) : 0;
			if(aId < bId) {
				return -1 * sort.order;
			}
			else if(aId > bId) {
				return 1 * sort.order;
			}
		}
		else if(isNaN(a[sort.by])) {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			else if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			else if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}

/**
 *
 * @param {HTMLInputElement} acAdapterCheckbox
 */
function toggleCameWithACAdapter(acAdapterCheckbox) {
	const oNum = acAdapterCheckbox.getAttribute('oNum');
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		order.setCameWithACAdapter(acAdapterCheckbox.checked);
		order.setChanged(order.determineIfChanged());
		unsavedChanged = true;
	}
	catch (err) {
		console.error(err);
	}
}


/**
 *
 * @param {HTMLSelectElement} warrantySelect
 */
function setWarranty(warrantySelect) {
	const oNum = warrantySelect.getAttribute('oNum');
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		order.warrantyId = warrantySelect.value;
		order.warranty = warrantySelect.innerText;
		order.setChanged(order.determineIfChanged());
		unsavedChanges = true;
	}
	catch (e) {
		console.error(e);
	}
}

/**
 *
 * @param {HTMLInputElement} warrantyCheckbox
 */
function toggleWarranty(warrantyCheckbox) {
	const oNum = warrantyCheckbox.getAttribute('oNum');
	/**
	 * @type {HTMLInputElement}
	 */
	const warrantyPlusCheckbox = document.getElementById(`${oNum}_warrantypluscheckbox`);
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		const warrantySelected = warrantyCheckbox.checked;
		if (warrantySelected) {
			order.warrantyId = warrantyCheckbox.value;
		}
		else {
			order.warrantyId = '1';
			warrantyPlusCheckbox.checked = false;
		}
		order.warranty = 'Warranty';
		order.setChanged(order.determineIfChanged());
		unsavedChanges = true;
	}
	catch (e) {
		console.error(e);
	}
}

/**
 *
 * @param {HTMLInputElement} warrantyPlusCheckbox
 */
function toggleWarrantyPlus(warrantyPlusCheckbox) {
	const oNum = warrantyPlusCheckbox.getAttribute('oNum');
	/**
	 * @type {HTMLInputElement}
	 */
	const warrantyCheckbox = document.getElementById(`${oNum}_warrantycheckbox`);
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		const warrantySelected = warrantyPlusCheckbox.checked;
		if (warrantySelected) {
			order.warrantyId = warrantyPlusCheckbox.value;
			warrantyCheckbox.checked = true;
		}
		else {
			order.warrantyId = '2';
		}
		order.warranty = 'Warranty';
		order.setChanged(order.determineIfChanged());
		unsavedChanges = true;
	}
	catch (e) {
		console.error(e);
	}
}

/**
 *
 * @param {HTMLSelectElement} salesSelect
 */
function setSales(salesSelect) {
	const oNum = salesSelect.getAttribute('oNum');
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		const salesId = salesSelect.value;
		const salesName = salesSelect.innerText;
		/**
		 * @type {Salesperson}
		 */
		let salesRep;
		for (const salesperson of salespeople) {
			if (salesperson.getId() == salesId) {
				salesRep = salesperson;
			}
		}
		if (!salesRep) {
			salesRep = new Salesperson({id : salesId, name : `${salesName} `});
		}
		order.salesRep = salesRep;
		order.setChanged(order.determineIfChanged());
	}
	catch (e) {
		console.error(e);
		alert(e);
	}
}

/**
 *
 * @param {HTMLSelectElement} statusSelect
 */
function setStatus(statusSelect) {
	const oNum = statusSelect.getAttribute('oNum');
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		order.setStatus(statusSelect.value);
		order.setChanged(order.determineIfChanged());
	}
	catch (e) {
		console.error(e);
		alert(e);
	}
}

/**
 *
 * @param {HTMLTextAreaElement} noteTextArea
 */
function setNotes(noteTextArea) {
	const oNum = noteTextArea.getAttribute('oNum');
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		order.setNote(noteTextArea.value);
		order.setChanged(order.determineIfChanged());
	}
	catch (e) {
		console.error(e);
		alert(e);
	}
}

/**
 *
 * @param {HTMLTextAreaElement} problemTextArea
 */
function setProblem(problemTextArea) {
	const oNum = problemTextArea.getAttribute('oNum');
	try {
		/**
		 * @type {ServiceRequest}
		 */
		const order = recordDict[oNum];
		order.setProblem(problemTextArea.value);
		order.setChanged(order.determineIfChanged());
	}
	catch (e) {
		console.error(e);
		alert(e);
	}
}

/**
 *
 * @param {HTMLButtonElement} saveChangesButton
 */
function saveChanges(saveChangesButton) {
	saveChangesButton.disabled = true;
	const oNum = saveChangesButton.getAttribute('oNum');
	/**
	 * @type {ServiceRequest}
	 */
	const order = recordDict[oNum];
	const changes = {
		body : {}
	};
	let hasChanges = false;
	if (order.isChanged()) {
		changes.body[order.getONum()] = order.getChanges();
		hasChanges = true;
	}
	console.log(changes);
	if (!hasChanges) {
		setLoadingModalVisible(false);
		saveChangesButton.disabled = false;
		return false;
	}
	setLoadingModalVisible(true);
	const stringifiedChanges = JSON.stringify(changes);
	const url = `${CONTROLLER_BASE_URL}?m=save_service_request_changes`, poststr = `changes=${stringifiedChanges}`;
	makeAjaxRequest(url, poststr, 'POST', returnRecords);
	function returnRecords() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					console.log(http_request.response);
					saveChangesButton.disabled = false;
					setLoadingModalVisible(false);
					init();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 *
 * @param {HTMLButtonElement} saveAllChangesButton
 */
function saveAllChanges(saveAllChangesButton) {
	saveAllChangesButton.disabled = true;
	const changes = {
		body : {}
	};
	let i = 0;
	for (const status in recordArrays) {
		/**
		 * @type {ServiceRequest[]}
		 */
		const requests = recordArrays[status];
		for (const request of requests) {
			if (request.isChanged()) {
				changes.body[i] = request.getChanges();
				i++;
			}
		}
	}
	console.log(changes);
	if (!i) {
		saveAllChangesButton.disabled = false;
		return false;
	}
	setLoadingModalVisible(true);
	const stringifiedChanges = JSON.stringify(changes);
	const url = `${CONTROLLER_BASE_URL}?m=save_service_request_changes`, poststr = `changes=${stringifiedChanges}`;
	makeAjaxRequest(url, poststr, 'POST', returnRecords);
	function returnRecords() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					console.log(http_request.response);
					saveAllChangesButton.disabled = false;
					setLoadingModalVisible(false);
					init();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}

}
