const CONTROLLER_BASE_URL = 'admin_controller.php';

const SORT_ASC_URL = '../svg/sort_asc_white.svg';
const SORT_DESC_URL = '../svg/sort_desc_white.svg';
const SORT_NONE_URL = '../svg/sort_white.svg';
const DEFAULT_SORT = 'ship_date';

/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');





const TODAY = new Date();

const THIS_YEAR = {
	asNumber : TODAY.getFullYear(),
	asString : TODAY.getFullYear().toString()
}
const LAST_YEAR = {
	asNumber : TODAY.getFullYear() - 1,
	asString : ''
}
LAST_YEAR.asString = LAST_YEAR.asNumber.toString();
const THIS_MONTH = {
	asNumber : TODAY.getMonth() + 1,
	asString : '',
};
THIS_MONTH.asString =  '0'.repeat(2 - THIS_MONTH.asNumber.toString().length).concat(THIS_MONTH.asNumber.toString())
const LAST_MONTH = {
	asNumber : (TODAY.getMonth() > 1) ? TODAY.getMonth() : 12,
	asString : '',
	lastDay : ''
};
LAST_MONTH.asString = '0'.repeat(2 - LAST_MONTH.asNumber.toString().length).concat(LAST_MONTH.asNumber.toString());
LAST_MONTH.lastDay = getMonthLastDay((LAST_MONTH.asNumber == 12) ? LAST_YEAR.asNumber : THIS_YEAR.asNumber, LAST_MONTH.asNumber);
const day_of_month = {
	asNumber : TODAY.getDate(),
	asString : '0'.repeat(2 - TODAY.getDate().toString().length).concat(TODAY.getDate().toString())
};

const searchParameters = {
	startDate : `${THIS_YEAR.asString}-${THIS_MONTH.asString}-01`,
	endDate : '',
	salespersons : []
};

let showSalespersonColumn = true;


const SERVICE_REQUEST_DICT = {};

/**
 * @type {ServiceRequest[]}
 */
const SERVICE_REQUEST_ARRAY = [];

/**
 * @type {ServiceRequest[]}
 */
const validEntries = [];


const UNKNOWN_DATE_DICT = {};

/**
 * @type {ServiceRequest[]}
 */
const UNKNOWN_DATE_ARRAY = [];

/**
 * @type {HTMLInputElement}
 */
const START_DATE_INPUT = document.getElementById('start_date_input');
/**
 * @type {HTMLInputElement}
 */
const END_DATE_INPUT = document.getElementById('end_date_input');

START_DATE_INPUT.max = TODAY.toJSON().substring(1, TODAY.toJSON().indexOf('T'));

END_DATE_INPUT.max = START_DATE_INPUT.max;

const COLUMN_DEFINITIONS = {
	salesperson: new ColumnDefinition('Sales', 'salesperson', {isSortable: true, isFilterable: true}),
	oNum: new ColumnDefinition('MTS', 'oNum', {isSortable: true, isFilterable: true}),
	organization: new ColumnDefinition('School', 'organization', {isSortable: true, isFilterable: true}),
	invoice_date: new ColumnDefinition('Invoice Date', 'invoice_date', {isSortable: true}),
	dateCompleted: new ColumnDefinition('Completion Date', 'dateCompleted', {isSortable: true}),
	products: new ColumnDefinition('SKU', 'products'),
	quantity: new ColumnDefinition('Quantity', 'quantity'),
	problem: new ColumnDefinition('Notes', 'problem'),
	servicesPerformed: new ColumnDefinition('Service Performed', 'servicesPerformed'),
	trackingOut: new ColumnDefinition('Tracking Number', 'trackingOut'),
	subtotal: new ColumnDefinition('Subtotal', 'subtotal', {isSortable: true}),
	warrantyName: new ColumnDefinition('Warranty', 'warrantyName', {isSortable: true, isFilterable: true})
};

/**
 * @type {ColumnDefinition[]}
 */
const columns = [
	COLUMN_DEFINITIONS.salesperson,
	COLUMN_DEFINITIONS.oNum,
	COLUMN_DEFINITIONS.organization,
	COLUMN_DEFINITIONS.dateCompleted,
	// COLUMN_DEFINITIONS.warrantyName,
	COLUMN_DEFINITIONS.servicesPerformed,
	COLUMN_DEFINITIONS.trackingOut,
	// COLUMN_DEFINITIONS.tracking_numbers,
	// COLUMN_DEFINITIONS.subtotal,
];


/**
 * @type {HTMLTableSectionElement}
 */
const SERVICE_REQUEST_BODY = document.getElementById('completed_requests_body');
/**
 * @type {HTMLTableRowElement}
 */
const SERVICE_REQUEST_HEADER_ROW = document.getElementById('completed_requests_header_row');
/**
 * @type {HTMLTableSectionElement}
 */
const UNKNOWN_SHIP_DATE_BODY = document.getElementById('unknown_date_body');
/**
 * @type {HTMLTableRowElement}
 */
const UNKNOWN_SHIP_DATE_HEADER_ROW = document.getElementById('unknown_date_header_row');
/**
 * @type {HTMLHeadingElement}
 */
const UNKNOWN_SHIP_DATE_TITLE = document.getElementById('unknown_date_title');
/**
 * @type {HTMLTableElement}
 */
const UNKNOWN_SHIP_DATE_TABLE = document.getElementById('unknown_date_table');

const filter = {};
const sort = {
	by: DEFAULT_SORT,
	order: 1,
};

const pagination = {
	entriesPerPage: 50,
	currentPage: 0,
	maxPages: 1
}

let totalValue = 0;

init();

function init() {
	getServiceRequests();
}

/**
 *
 * @param {(HTMLSelectElement|HTMLInputElement)} input
 */
function updateDateRange(input) {
	const isSelect = input.id.includes("select");
	const isStart = input.id.includes("start");
	const isEnd = input.id.includes("end");
	if (isSelect) {
		START_DATE_INPUT.hidden = true;
		END_DATE_INPUT.hidden = true;
		document.getElementById("custom_date_search").hidden = true;
		switch(input.value) {
			case "this_month":
				searchParameters.startDate = `${THIS_YEAR.asString}-${THIS_MONTH.asString}-01`;
				searchParameters.endDate = '';
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getServiceRequests();
				break;
			case "this_year":
				searchParameters.startDate = `${THIS_YEAR.asString}-01-01`;
				searchParameters.endDate = '';
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getServiceRequests();
				break;
			case "last_month":
				searchParameters.startDate = `${(LAST_MONTH.asNumber == 12) ? LAST_YEAR.asString : THIS_YEAR.asString}-${LAST_MONTH.asString}-01`;
				searchParameters.endDate = `${(LAST_MONTH.asNumber == 12) ? LAST_YEAR.asString : THIS_YEAR.asString}-${LAST_MONTH.asString}-${LAST_MONTH.lastDay}`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getServiceRequests();
				break;
			case "last_year":
				searchParameters.startDate = `${LAST_YEAR.asString}-01-01`;
				searchParameters.endDate = `${LAST_YEAR.asString}-12-31`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getServiceRequests();
				break;
			case "previous_30":
				searchParameters.startDate = `${(THIS_MONTH.asNumber == 1 && day_of_month.asNumber < 30) ? LAST_YEAR.asString : THIS_YEAR.asString}-${(day_of_month.asNumber < 30) ? LAST_MONTH.asString : THIS_MONTH.asString}-${(day_of_month.asNumber < 30) ? day_of_month.asString : '01'}`;
				searchParameters.endDate = `${THIS_YEAR.asString}-${THIS_MONTH.asString}-${day_of_month.asString}`;
				START_DATE_INPUT.value = searchParameters.startDate;
				END_DATE_INPUT.value = searchParameters.endDate;
				getServiceRequests();
				break;
			case "custom":
				START_DATE_INPUT.hidden = false;
				END_DATE_INPUT.hidden = false;
				document.getElementById("custom_date_search").hidden = false;
				break;
		}
	} else if (isStart) {
		searchParameters.startDate = input.value;
	} else if (isEnd) {
		searchParameters.endDate = input.value;
	}
	START_DATE_INPUT.max = END_DATE_INPUT.value;
	END_DATE_INPUT.min = START_DATE_INPUT.value;
}

function getServiceRequests() {
	const url = `${CONTROLLER_BASE_URL}?m=get_completed_service_requests`, poststr = `startDate=${searchParameters.startDate}&endDate=${searchParameters.endDate}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnServiceRequests);
	/**
	 * Get the records from Zoho
	 */
	function returnServiceRequests(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const getData = () => {
						try {
							return JSON.parse(http_request.response);
						} catch (e) {
							return http_request.response;
						}
					}
					const data = getData();
					console.log(data);
					if (typeof data == 'object') {
						const records = data;
						SERVICE_REQUEST_ARRAY.length = 0;
						for (const member in SERVICE_REQUEST_DICT) {
							delete SERVICE_REQUEST_DICT[member];
						}
						for (const record of records) {
							const newRecord = new ServiceRequest(record);
							SERVICE_REQUEST_DICT[newRecord.getONum()] = newRecord;
						}
						for (const record in SERVICE_REQUEST_DICT) {
							SERVICE_REQUEST_ARRAY.push(SERVICE_REQUEST_DICT[record]);
						}
						clearFilter();
						renderHeader();
						renderBody();
					} else {
						alert("No records found for given criteria.");
					}
					setSort(DEFAULT_SORT);
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}


function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortRecords();
	renderBody();
}

function sortRecords() {
	SERVICE_REQUEST_ARRAY.sort((a, b) => sortFunction(a,b));
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
	function sortFunction(a,b) {
		if(isNaN(a[sort.by]) || sort.by == 'ship_date' || sort.by == 'invoice_date') {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}


/**
 *
 * @param {HTMLInputElement} input
 */
function filterInput(input) {
	filter[input.getAttribute('filter')] = input.value;
	const sameNameInputs = document.getElementsByClassName(input.getAttribute('filter') + '_filter');
	for(const elem of sameNameInputs) {
		elem.value = input.value;
	}
	renderBody();
}

function renderHeader() {
	SERVICE_REQUEST_HEADER_ROW.innerHTML = '';
	UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML = '';
	for (const column of columns) {
		if (!showSalespersonColumn && column.identifier == "salesperson") {
			// Do nothing if salesperson column disabled
		} else {
			SERVICE_REQUEST_HEADER_ROW.innerHTML += column.buildHeader();
		}
	}
	if (UNKNOWN_DATE_ARRAY.length > 0) {
		for (const column of columns) {
			if (!showSalespersonColumn && column.identifier == "salesperson") {
				// Do nothing if salesperson column disabled
			} else {
				UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML += column.buildHeader();
			}
		}
		UNKNOWN_SHIP_DATE_HEADER_ROW.innerHTML += `<th class="header_cell">Get Updated Ship Date</th>`
	}
}

function renderBody(renewValidEntries = true) {
	if (renewValidEntries) {
		getValidEntries();
	}
	SERVICE_REQUEST_BODY.innerHTML = '';
	UNKNOWN_SHIP_DATE_BODY.innerHTML = '';
	let rowNum = 0;
	for (let i = 0; i < pagination.entriesPerPage; i++) {
		const record = validEntries[i+(pagination.currentPage * pagination.entriesPerPage)];
		if (record) {
			// SERVICE_REQUEST_BODY.innerHTML += record.generateCompletedRequestRow(showSalespersonColumn, rowNum);
			const newRow = record.generateCompletedRequestRow();
			newRow.classList.add((rowNum % 2 == 0) ? 'even' : 'odd');
			SERVICE_REQUEST_BODY.appendChild(newRow);
			rowNum++;
		}
	}
	if (validEntries.length > 0) {
		buildPageControls();
	}
	// document.getElementById('range_total').innerHTML = `$${Math.round(totalValue).toLocaleString()}`;
	let unknownDateRowNum = 0;
	if (UNKNOWN_DATE_ARRAY.length > 0) {
		UNKNOWN_SHIP_DATE_TITLE.hidden = false;
		UNKNOWN_SHIP_DATE_TABLE.hidden = false;
		for (const record of UNKNOWN_DATE_ARRAY) {
			let valid = true;
			for(const entry in filter) {
				if (filter[entry] == '') {
					delete filter[entry];
				} else if (record[entry] && filter[entry] && !record[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
					valid = false;
				}
			}
			if (valid) {
				UNKNOWN_SHIP_DATE_BODY.innerHTML += record.generateCompletedRequestRow(showSalespersonColumn, unknownDateRowNum, true);
				unknownDateRowNum++;
			}
		}
	}
	else {
		UNKNOWN_SHIP_DATE_TITLE.hidden = true;
		UNKNOWN_SHIP_DATE_TABLE.hidden = true;
	}

	function buildPageControls() {
		const pageControls = document.getElementById('pages');
		pageControls.innerHTML = "";
		pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.max(pagination.currentPage - 1, 0)})" pnum="prev" class="select-page-button">&laquo;</li>`;
		for (let i = 0; i < pagination.maxPages; i++) {
			if (i == pagination.currentPage) {
				pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button active">${i+1}</li>`;
			} else {
				pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button">${i+1}</li>`;
			}
		}
		pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.min(pagination.currentPage + 1, pagination.maxPages - 1)})" pnum="next" class="select-page-button">&raquo;</li>`;
	}

}

function getMonthLastDay(year, month) {
	const num = new Date(year, month, 0).getDate().toString();
	return '0'.repeat(2 - num.length).concat(num);
}

function clearFilter() {
	for (const entry in filter) {
		delete filter[entry];
	}
}

function getValidEntries() {
	totalValue = 0;
	validEntries.length = 0;
	pagination.currentPage = 0;
	for (const record of SERVICE_REQUEST_ARRAY) {
		let valid = true;
		for(const entry in filter) {
			if (filter[entry] == '') {
				delete filter[entry];
			} else if (record[entry] && filter[entry] && !record[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
				valid = false;
			}
		}
		if (valid) {
			totalValue += parseFloat(record.subtotal);
			validEntries.push(record);
		}
	}
	pagination.maxPages = Math.ceil(validEntries.length / pagination.entriesPerPage);
}

function setCurrentPage(num) {
	/**
	 * @type {HTMLCollectionOf<HTMLLIElement}
	 */
	const pageSelectButtons = document.getElementsByClassName('page-select-button');
	pagination.currentPage = num;
	renderBody(false);
}

function getUpdatedShipDate(zohoId) {
	console.log(`getting updated ship date for ${zohoId}`);

	const url = `${CONTROLLER_BASE_URL}?m=get_updated_zoho_ship_date`, poststr = `zoho_id=${zohoId}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnReply);
	console.log(url, poststr);
	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					setLoadingModalVisible(false);
					try {
						const data = JSON.parse(http_request.response);
						if (data['updated']) {
							console.log('updated!');
							getServiceRequests();
						}
					}
					catch (err) {
						console.error(err);
					}
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 * Toggle the ship date editing on/off
 * @param {HTMLAnchorElement} editButton
 */
function toggleDisplayEdit(editButton) {
	const orderId = editButton.getAttribute('order_id');
	const dateDisplay = document.getElementById(`ship_date_display_${orderId}`);
	const dateEdit = document.getElementById(`ship_date_edit_${orderId}`);
	const saveEdit = document.getElementById(`ship_date_save_${orderId}`);
	/**
	 * @type {HTMLAnchorElement}
	 */
	const cancelButton = document.getElementById(`ship_date_cancel_${orderId}`)
	dateDisplay.hidden = !dateDisplay.hidden;
	dateEdit.hidden = !dateEdit.hidden;
	saveEdit.hidden = !saveEdit.hidden;
	const editIsDisplayed = !dateEdit.hidden;
	if (editIsDisplayed) {
		cancelButton.hidden = false;
	} else {
		cancelButton.hidden = true;
	}
}

/**
 * Saves ship date
 * @param {HTMLAnchorElement} saveButton
 */
function saveShipDate(saveButton) {
	const orderId = saveButton.getAttribute('order_id');
	const dateEdit = document.getElementById(`ship_date_edit_${orderId}`);
	const newDate = dateEdit.value;
	if (validateDate(newDate)) {
		const url = `${CONTROLLER_BASE_URL}?m=update_order_ship_date`;
		const poststr = `zoho_id=${saveButton.getAttribute('order_id')}&ship_date=${newDate}`;
		setLoadingModalVisible(true);
		makeAjaxRequest(url, poststr, 'POST', returnReply);
	}
	else {
		alert ('Invalid date entered.');
	}
	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					setLoadingModalVisible(false);
					getServiceRequests();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}

}

/**
 * Validates if a date is valid
 * @param {string} dateString
 */
function validateDate(dateString) {
	const datePattern = /^(\d{4}-\d{2}-\d{2})$/
	if (!datePattern.test(dateString)) {
		console.log(`doesn't match pattern`);
		return false;
	}

	const monthLengths = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	if (isLeapYear(parseInt(dateString.substr(0, 4)))) {
		monthLengths[1] = 29;
	}
	const monthIndex = parseInt(dateString.substr(5, 2)) - 1;
	const days = parseInt(dateString.substr(8, 2));
	if (monthIndex > 11 || days > monthLengths[monthIndex]) {
		return false;
	}

	return true;

	/**
	 * Check if is a leap year
	 * @param {Number} year
	 */
	function isLeapYear(year) {
		if (year % 4 == 0) {
			if (year % 100 == 0 && year % 400 != 0) {
				return false;
			}
			else {
				return true;
			}
		}
		else {
			return false;
		}
	}
}
