class State {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.abbreviation = data['abbreviation'];
		/**
		 * @type {HTMLTableRowElement}
		 */
		this.row = null;

		this.regionId = data['regionid'] || data['regionId'];

		this.initialValues = {
			id : this.id,
			name : this.name,
			abbreviation : this.abbreviation,
			regionId : this.regionId
		}

	}

	getId() {
		return this.id;
	}

	getName() {
		return this.name;
	}

	getAbbreviation() {
		return this.abbreviation;
	}

	getStateOption() {
		const option = document.createElement('option');
		option.value = this.getId();
		option.innerText = this.getName();
		return option;
	}

	setChangedClass() {
		if (this.changed) {
			this.row.classList.add("changed");
		}
		else {
			this.row.classList.remove("changed");
		}
	}

	getSaveData() {
		const saveData = {
			'id' : this.id,
			'regionId' : this.regionId
		}
		return saveData;
	}

	get changed() {
		let changed = false;
		for (const prop in this.initialValues) {
			if (this[prop] != this.initialValues[prop]) {
				changed = true;
			}
		}
		return changed;
	}
}
