class Region {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.identifier = data['identifier'];
		/**
		 * @type {State[]}
		 */
		this.states = [];
		/**
		 * @type {Salesperson[]}
		 */
		this.salespersons = [];

		if (data['states']) {
			for (const stateData of data['states']) {
				this.states.push(new State(stateData));
			}
		}

		if (data['salespersons']) {
			for (const salespersonData of data['salespersons']) {
				this.salespersons.push(new Salesperson(salespersonData));
			}
		}
		this.salespersonId = (this.salespersons.length > 0) ? this.salespersons[0].id : "";
		/**
		 * @type {HTMLTableRowElement}
		 */
		this.row = null;

		this.initialValues = {
			id : this.id,
			name : this.name,
			identifier : this.identifier,
			salespersonId : this.salespersonId
		}
	}

	getId() {
		return this.id;
	}

	getName() {
		return this.name;
	}

	getIdentifier() {
		return this.identifier;
	}

	getStates() {
		return this.states;
	}

	getRegionOption(selected=false) {
		const option = document.createElement('option');
		option.value = this.getId();
		option.innerText = this.getName();
		option.selected = selected;
		return option;
	}

	setChangedClass() {
		if (this.changed) {
			this.row.classList.add("changed");
		}
		else {
			this.row.classList.remove("changed");
		}
	}

	save() {
		if (this.changed) {

		}
		else {
			return true;
		}
	}

	getSaveData() {
		const saveData = {
			'id' : (this.id == "new") ? '' : this.id,
			'name' : this.name,
			'identifier' : this.identifier,
			'salespersonId' : this.salespersonId
		}
		return saveData;
	}

	get changed() {
		let changed = false;
		for (const prop in this.initialValues) {
			if (this[prop] != this.initialValues[prop]) {
				changed = true;
			}
		}
		return changed;
	}
}
