class Vendor {
	constructor(data) {
		this.id = data['id'];
		this.zohoId = data['zohoId'];
		this.name = data['name'];
	}

	getId() {
		return this.id;
	}

	getZohoId() {
		return this.zohoId;
	}

	getName() {
		return this.name;
	}

	getVendorCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const link = document.createElement('a');
		cell.appendChild(link);
		link.target = "_blank";
		link.innerText = this.getName();
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Vendors/${this.getZohoId()}/`;

		return cell;
	}
}
