class LineItem {
	constructor(data, hasPermissions = false) {
		this.id = data['id'];
		this.orderNumberId = data['orderNumberId'];
		/**
		 * @type {string}
		 */
		this.zohoId = data['zohoId'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.code = data['code'];
		/**
		 * @type {string}
		 */
		this.description = data['description'];
		this.quantity = parseInt(data['quantity']) || 0;
		if (hasPermissions) {
			this.total = parseFloat(data['total']) || 0.0;
		}
		else {
			this.total = 0.0;
		}
		this.isVisible = true;
	}

	getId() {
		return this.id;
	}

	getZohoId() {
		return this.zohoId;
	}

	getName() {
		return this.name;
	}

	getCode() {
		return this.code;
	}

	getDescription() {
		return this.description;
	}

	getQuantity() {
		return this.quantity;
	}

	getTotal() {
		return this.total;
	}

	getIsVisible() {
		return this.isVisible;
	}

	getNameCell(shouldLink=false) {
		const cell = document.createElement('td');
		if (shouldLink) {
			const link = document.createElement('a');
			link.target = "_blank";
			link.href = `https://crm.zoho.com/crm/org26161413/tab/Products/${this.getZohoId()}`;
			link.innerText = this.getName();
			cell.appendChild(link);
		}
		else {
			cell.innerText = this.getName();
		}
		return cell;
	}

	getCodeCell(shouldLink=false) {
		const cell = document.createElement('td');
		if (shouldLink) {
			const link = document.createElement('a');
			link.target = "_blank";
			link.href = `https://crm.zoho.com/crm/org26161413/tab/Products/${this.getZohoId()}`;
			link.innerText = this.getCode();
			cell.appendChild(link);
		}
		else {
			cell.innerText = this.getCode();
		}
		return cell;
	}

	getDescriptionCell(shouldLink=false) {
		const cell = document.createElement('td');
		if (shouldLink) {
			const link = document.createElement('a');
			link.target = "_blank";
			link.href = `https://crm.zoho.com/crm/org26161413/tab/Products/${this.getZohoId()}`;
			link.innerText = `${this.getName()}\n\n${this.getDescription()}`;
			cell.appendChild(link);
		}
		else {
			cell.innerText = `${this.getName()}\n\n${this.getDescription()}`;
		}
		return cell;
	}

	getQuantityCell(shouldLink=false) {
		const cell = document.createElement('td');
		if (shouldLink) {
			const link = document.createElement('a');
			link.target = "_blank";
			link.href = `https://crm.zoho.com/crm/org26161413/tab/Products/${this.getZohoId()}`;
			link.innerText = this.getQuantity().toLocaleString();
			cell.appendChild(link);
		}
		else {
			cell.innerText = this.getQuantity().toLocaleString();
		}
		return cell;
	}
}
