CONTROLLER_BASE_URL = "admin_controller.php";
init();
async function init(searchText = false)
{
    setLoadingModalVisible(true);
    inboundOrders = await getZohoInboudOrders(searchText);
    var rows = '';
    if(inboundOrders.length > 0) {
        inboundOrders.forEach(data => {
            rows += '<tr>';
            rows += '<td>'+data.order.poNumber+'</td>';
            rows += '<td>'+data.vendor.name+'</td>';
            rows += '<td>'+data.order.vendorOrderNumber+'</td>';
            rows += '<td>'+data.order.mtsNumber+'</td>';
            rows += '<td>'+data.lineItems[0].code+'</td>';
            rows += '<td>'+data.lineItems[0].quantity+'</td>';
            rows += '<td>'+data.order.trackingNumber ?? 'N/A'+'</td>';
            rows += '<td>'+data.order.status+'</td>';
            rows += '<td></td>';
            rows += '<td>'+((data.receivedItems) ? data.receivedItems.length : '0')+'/'+data.lineItems[0].quantity+'</td>';
            rows += '<td><a role="button" href="'+CONTROLLER_BASE_URL+'?m=purchase_orders_v2_checkin&po='+data.order.poNumber+'">Check In</a></td>';
            rows += '</tr>';
        });
    }
    else {
        rows += '<tr>';
        rows += '<td colspan="11" align="center">No data found</td>';
        rows += '</tr>';
    }
    
    document.getElementById('inbound_table_body').innerHTML = rows;
    setLoadingModalVisible(false);
}

async function getZohoInboudOrders(searchText = false) {
	const response = await fetch(`${CONTROLLER_BASE_URL}?m=purchase_orders_v2_get_inbound&searchText=`+searchText)
		.then(res => { return res });
	try {
		const data = response.json();
		return data;
	}
	catch (err) {
		console.error(err);
		const data = response.text();
		return data;
	}
}