CONTROLLER_BASE_URL = "admin_controller.php";
init();
async function init()
{
    orders = await fetchOrders();
    var rows = '';

    logs = [];
    receivedItems = [];
    orders.forEach(data => {
        rows += '<tr>';
        rows += '<td>'+data.poNumber+'</td>';
        rows += '<td>'+data.vendor.name+'</td>';
        rows += '<td>'+data.vendorOrderNumber+'</td>';
        rows += '<td>'+data.mtsNumber+'</td>';
        rows += '<td>'+data.lineItems[0].name+'</td>';
        rows += '<td>'+data.lineItems[0].quantity+'</td>';
        rows += '<td>'+(data.trackingNumber != null ? data.trackingNumber : '')+'</td>';
        rows += '<td>'+data.status+'</td>';
        rows += '<td></td>';
        rows += '<td>'+((data.receivedItems) ? data.receivedItems.length : '0')+'/'+data.lineItems[0].quantity+'</td>';
        rows += '</tr>';

        if(data.logs) {
            logs.push(data.logs);
        }

        if(data.receivedItems) {
            receivedItems.push(data.receivedItems);
        }
    });
    
    document.getElementById('checkin_table_body').innerHTML = rows;
    
    if(receivedItems.length > 0) {
        rows = '';
        receivedItems[0].forEach(data => {
            rows += '<tr>';
            rows += '<td>'+data.serialNumber+ '</td>';
            rows += '<td>'+data.oNum+ '</td>';
            rows += '</tr>';
        });
    
        document.getElementById('devices_table').innerHTML = rows;
    }
    
    if(logs.length > 0) {
        rows = '';
        logs[0].forEach(data => {
            rows += '<div>';
            rows += data.created_at+ '&nbsp;&nbsp;';
            rows += data.text;
            rows += '</div>';
        });
    
        document.getElementById('activity_logs').innerHTML = rows;
    }
    setLoadingModalVisible(false);
}

async function fetchOrders() {
	const response = await fetch(`${CONTROLLER_BASE_URL}?m=purchase_orders_v2_checkin_fetch&po=`+(new URL(document.location)).searchParams.get('po'))
		.then(res => { return res });
	try {
		const data = response.json();
		return data;
	}
	catch (err) {
		console.error(err);
		const data = response.text();
		return data;
	}
}

async function submit() {
    serialNumberInput = document.getElementById('serial_numbers');
    serials = new Set(serialNumberInput.value.trim().split('\n').map(s => s.trim().toUpperCase()).filter(el => el != ''));

    const data = {serial_numbers: [...serials]};
    setLoadingModalVisible(true);
	const response = await fetch(`${CONTROLLER_BASE_URL}?m=purchase_orders_v2_receiving&po=`+(new URL(document.location)).searchParams.get('po'), {
        method: "POST",
        headers: {
            'Accept' : 'application/json',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
      }).then(res => { return res });

	try {
		const data = await response.json();
        alert(data.message);
        if(data.success == 1) {
            window.location.reload();
        }
	}
	catch (err) {
        setLoadingModalVisible(false);
		alert(error.message);
	}
}