class TtsOrder {
	constructor(data) {
		this.Account_Id = data['Account_Id'];
		this.Account_Name = data['Account_Name'];
		this.AP_Data_Present = data['AP_Data_Present'];
		this.Created_Time = data['Created_Time'];
		this.Deduction = data['Deduction'];
		this.zoho_id = data['Invoice_Id'];
		this.MTS_Quote_Number = data['MTS_Quote_Number'];
		/**
		 * @type {String}
		 */
		this.Owner = data['Owner'];
		this.Owner_Id = data['Owner_Id'];
		this.Products = data['Products'];
		this.Subject = data['Subject'];
		this.asset_tags = data['asset_tags'];
		this.changed = false;
		this.notes = data['notes'];
		this.status_id = data['status_id'];
		this.Total = data['Total'];
		this.deductions = this.calculateDeductions();
		this.subtotal = this.calculateSubtotal();

		console.log(data);

		this.newCustomer = (data['new_customer_order'] == '1');
	}

	getAccountId() {
		return this.Account_Id;
	}

	getAccountName() {
		return this.Account_Name;
	}

	getCreatedTime() {
		return this.Created_Time;
	}

	getInvoiceDate() {
		return new Date(this.getCreatedTime());
	}

	getDeduction() {
		return this.Deduction;
	}

	getZohoId() {
		return this.zoho_id;
	}

	getMtsQuoteNumber() {
		return this.MTS_Quote_Number;
	}

	getOwnerName() {
		return this.Owner;
	}

	getOwnerId() {
		return this.Owner_Id;
	}

	getSalespersonFirstName() {
		return this.getOwnerName().substring(0, this.getOwnerName().indexOf(' '));
	}

	getSubject() {
		return this.Subject;
	}

	getNotes() {
		return this.notes;
	}

	getTotal() {
		return this.Total;
	}

	getDeductions() {
		return this.deductions;
	}

	getSubtotal() {
		return this.subtotal;
	}

	getAssetTags() {
		return this.asset_tags;
	}

	getApDataPresent() {
		return this.AP_Data_Present;
	}

	getStatusId() {
		return this.status_id;
	}

	getNewCustomer() {
		return this.newCustomer;
	}


	getProducts() {
		return this.Products;
	}

	/**
	 *
	 * @param {number} index
	 */
	getProductId(index) {
		const products = this.getProducts();
		const product = products[index];
		try {
			return product['id'];
		}
		catch (err) {
			console.error(err);
			console.log(index);
			console.log(products);
			console.log(product);
			return undefined;
		}
		// return this.getProducts()[index]['id'];
	}

	/**
	 *
	 * @param {number} index
	 */
	getProductCode(index) {
		const products = this.getProducts();
		const product = products[index];
		try {
			return product['code'];
		}
		catch (err) {
			console.error(err);
			console.log(index);
			console.log(products);
			console.log(product);
			return undefined;
		}
	}

	/**
	 *
	 * @param {number} index
	 */
	getProductName(index) {
		const products = this.getProducts();
		const product = products[index];
		try {
			return product['name'];
		}
		catch (err) {
			console.error(err);
			console.log(index);
			console.log(products);
			console.log(product);
			return undefined;
		}
	}




	getPostString() {
		return `zoho_id=${this.getZohoId()}&notes=${this.notes}&status_id=${this.status_id}&asset_tags=${this.asset_tags}`;
	}

	getObjectRepresentation() {
		return {
			'zoho_id': this.zoho_id,
			'notes': this.notes,
			'status_id' : this.status_id || 1,
			'asset_tags' : this.asset_tags || 0
		};
	}

	/**
	 *
	 * @param {boolean} showSalesperson Whether or not to show the salesperson cell
	 * @param {number} rowNum Which number row this is, for determining if odd or even
	 * @param {boolean} isUnknownDateItem For displaying unknown date options or not
	 */
	getMainRecordRow(showSalesperson=true, rowNum, isUnknownDateItem=false) {
		const firstVisibleProductIndex = this.getFirstVisibleProduct();
		const rowspan = Math.max(this.getVisibleProducts().length, 1);
		const rowClass = (rowNum % 2 == 0) ? 'even' : 'odd';
		const mainRow = document.createElement('tr');
		mainRow.classList.add(rowClass);
		if (this.getAssetTags()) {
			mainRow.classList.add('asset_tags');
		}
		if (showSalesperson) {
			mainRow.appendChild(this.getSalespersonCell(rowspan));
		}
		mainRow.appendChild(this.getMtsNumberCell(rowspan));
		mainRow.appendChild(this.getAccountCell(rowspan));
		mainRow.appendChild(this.getInvoiceDateCell(rowspan));
		mainRow.appendChild(this.getProductNameCell(firstVisibleProductIndex));
		mainRow.appendChild(this.getProductQuantityCell(firstVisibleProductIndex));
		mainRow.appendChild(this.getNotesCell(rowspan));
		mainRow.appendChild(this.getAPStatusCell(rowspan));
		mainRow.appendChild(this.getATStatusCell(rowspan));
		mainRow.appendChild(this.getNewCustomerCell(rowspan));
		mainRow.appendChild(this.getStatusSelectCell(rowspan));
		mainRow.appendChild(this.getSubtotalCell(rowspan));
		mainRow.appendChild(this.getSaveChangesCell(rowspan));
		return mainRow;


	}

	/*
	let returnString =  `
		<tr ${getRowClasses()}>
			<td rowspan='${numProducts}'>$${Math.round(subTotal).toLocaleString()}</td>

		</tr>
	`;
	for (let i=1; i < products.length; i++) {
		returnString += `
			<tr ${getRowClasses()}>
				<td><a href='https://crm.zoho.com/crm/org26161413/tab/Invoices/${record['Invoice_Id']}#secDiv_Product_Details' target='_blank'>${(products[i]['code']) ? products[i]['code'] : products[0]['name']}</a> <a hidden class="updateElement" href="javascript:void(0)" onclick="addToDeductions('${record['Invoice_Id']}')"><small>(deduct)</small></a></td>
				<td class='halign-center'>${products[i]['quantity']}</td>
			</tr>
		`;
	}

	*/


	/**
	 *
	 * @param {number} rowNum Row number for determining even/odd
	 * @param {number} index Product index
	 */
	getProductRow(rowNum, index) {
		const rowClass = (rowNum % 2 == 0) ? 'even' : 'odd';
		const row = document.createElement('tr');
		row.classList.add(rowClass);
		if (this.getAssetTags()) {
			row.classList.add('asset_tags');
		}
		row.appendChild(this.getProductNameCell(index));
		row.appendChild(this.getProductQuantityCell(index));
		return row;
	}

	/**
	 *
	 * @param {number} rowspan Number of rows to span
	 */
	getSalespersonCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		cell.innerText = this.getSalespersonFirstName();
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan Number of rows to span
	 */
	getMtsNumberCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const link = document.createElement('a');
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Invoices/${this.getZohoId()}`;
		link.target = '_blank';
		link.innerText = this.getMtsQuoteNumber();
		cell.appendChild(link);
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan Number of rows to span
	 */
	getAccountCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const link = document.createElement('a');
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Accounts/${this.getAccountId()}`;
		link.target = '_blank';
		link.innerText = this.getAccountName();
		cell.appendChild(link);
		return cell;
	}

	getInvoiceDateCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const dateDisplay = document.createElement('p');
		dateDisplay.id = `invoice_date_display_${this.getZohoId()}`;
		dateDisplay.style.margin = '0';
		dateDisplay.innerText = this.getInvoiceDate().toLocaleDateString();
		cell.appendChild(dateDisplay);
		return cell;
	}

	getProductCodeCell(index) {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		cell.appendChild(link);
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Invoices/${this.getZohoId()}#secDiv_Product_Details`;
		link.target = "_blank";
		link.innerText = (this.getProducts()[index]) ? this.getProductCode(index) : '';
		return cell;
	}

	/**
	 *
	 * @param {number} index
	 */
	getProductNameCell(index) {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		cell.appendChild(link);
		const hideSkuLink = this.getHideSkuLink(this.getProductId(index));
		cell.appendChild(hideSkuLink);
		link.href = `https://crm.zoho.com/crm/org26161413/tab/Invoices/${this.getZohoId()}#secDiv_Product_Details`;
		link.target = "_blank";
		link.innerText = (this.getProductCode(index)) ? this.getProductCode(index) : this.getProductName(index);
		return cell;
	}

	getProductQuantityCell(index) {
		const cell = document.createElement('td');
		cell.classList.add('halign-center');
		cell.innerText = (this.getProducts()[index]) ? this.getProducts()[index].quantity : '';
		return cell;
	}

	getNotesCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const textarea = document.createElement('textarea');
		cell.appendChild(textarea);
		textarea.rows = Math.max(3, rowspan);
		textarea.classList.add('note-input');
		textarea.setAttribute('invoice_id', this.getZohoId());
		textarea.setAttribute('oninput', 'updateNote(this)');
		textarea.innerText = this.getNotes();
		textarea.placeholder = "Enter notes...";
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan
	 */
	getAPStatusCell(rowspan) {
		// <td class='halign-center' rowspan='${numProducts}'><input type='checkbox' name="ap_${record['Invoice_Id']}" id="ap_${record['Invoice_Id']}" invoice_id="${record['Invoice_Id']}" onchange="updateAPStatus(this)" ${(record['AP_Data_Present']) ? 'checked' : ''} readonly /></td>

		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const checkbox = document.createElement('input');
		checkbox.checked = this.getApDataPresent();
		checkbox.type = 'checkbox';
		checkbox.name = `ap_${this.getZohoId()}`;
		checkbox.id = `ap_${this.getZohoId()}`;
		checkbox.setAttribute('invoice_id', this.getZohoId());
		cell.appendChild(checkbox);
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan
	 */
	getATStatusCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		cell.classList.add('halign-center');
		const checkbox = document.createElement('input');
		cell.appendChild(checkbox);
		checkbox.type = 'checkbox';
		checkbox.name = `at_${this.getZohoId()}`;
		checkbox.id = `at_${this.getZohoId()}`;
		checkbox.setAttribute('invoice_id', this.getZohoId());
		checkbox.setAttribute('onchange', 'updateATStatus(this)');
		checkbox.checked = this.getAssetTags();
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan
	 */
	getNewCustomerCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		cell.classList.add('halign-center');
		const checkbox = document.createElement('input');
		cell.appendChild(checkbox);
		checkbox.type = 'checkbox';
		checkbox.name = `nc_${this.getZohoId()}`;
		checkbox.id = `nc_${this.getZohoId()}`;
		checkbox.setAttribute('invoice_id', this.getZohoId());
		checkbox.checked = this.getNewCustomer();
		// checkbox.disabled = true;
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan
	 */
	getStatusSelectCell(rowspan) {
		// <td rowspan='${numProducts}'>${createStatusSelect()}</td>
		/*
			let ret = `<select class="borderless" id="status_select_${record['Invoice_Id']}" invoice_id="${record['Invoice_Id']}" onchange="updateStatus(this)">`;
			for (const status of statuses) {
				ret += `<option value="${status['id']}" ${(record['status_id'] == status['id']) ? "selected" : ""}>${status['status']}</option>`;
			}
			ret += "</select>";
			return ret;
		*/

		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const select = document.createElement('select');
		cell.appendChild(select);
		select.classList.add('borderless');
		select.id = `status_select_${this.getZohoId()}`;
		select.setAttribute('invoice_id', this.getZohoId());
		select.setAttribute('onchange', 'updateStatus(this)');
		for (const status of statuses) {
			const option = document.createElement('option');
			select.appendChild(option);
			option.value = status['id'];
			option.selected = (this.getStatusId() == status['id']);
			option.innerText = status['status'];
		}
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan
	 */
	getSaveChangesCell(rowspan) {
		// <td rowspan='${numProducts}' class="halign-center"><button type='button' id="save_button_${record['Invoice_Id']}" class="save_button" invoice_id="${record['Invoice_Id']}" onclick="saveChanges('${record['Invoice_Id']}')" >Save Changes</button></td>
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		cell.classList.add('halign-center');
		const button = document.createElement('button');
		cell.appendChild(button);
		button.type = "button";
		button.id = `save_button_${this.getZohoId()}`;
		button.classList.add('save_button');
		button.setAttribute('invoice_id', this.getZohoId());
		button.setAttribute('onclick', `saveChanges('${this.getZohoId()}')`);
		button.innerText = "Save Changes";
		return cell;
	}

	/**
	 *
	 * @param {number} rowspan
	 */
	getRefreshRecordCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		cell.classList.add('halign-center');
		cell.classList.add('updateElement');
		const refreshImg = document.createElement('img');
		cell.appendChild(refreshImg);
		refreshImg.alt = "Refresh Record";
		refreshImg.src = "../../img/refresh.png";
		refreshImg.style.width = '16px';
		refreshImg.style.cursor = 'pointer';
		refreshImg.setAttribute('onclick', `refreshRecord('${this.getZohoId()}')`);
		return cell;
	}

	getSubtotalCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		cell.innerText = this.getSubtotal().toLocaleString('en-US', {style: 'currency', currency: 'USD'});
		return cell;
	}

	getUpdatedShipDateButtonCell(rowspan) {
		const cell = document.createElement('td');
		cell.rowSpan = rowspan;
		const button = document.createElement('button');
		cell.appendChild(button);
		button.innerText = 'Get Updated Date';
		button.setAttribute('onclick', `refreshRecord('${this.getZohoId()}')`);
		return cell;
	}

	getHideSkuLink(zohoId) {
		const small = document.createElement('small');
		const span = document.createElement('span');
		small.appendChild(span);
		span.innerText = " | ";
		const link = document.createElement('a');
		small.appendChild(link);
		small.classList.add('updateElement');
		small.hidden = !updateElementsVisible;
		link.href = "javascript:void(0)";
		link.innerText = "(deduct)";
		link.setAttribute('onclick', `addToDeductions('${zohoId}')`);
		return small;
	}

	getCsvRows() {
		const rows = [];
		const newRow = [];
		newRow.push(`"${this.getSalespersonFirstName()}"`);
		newRow.push(`"${this.getMtsQuoteNumber()}"`);
		newRow.push(`"${this.getShipDate().toLocaleDateString()}"`);
		newRow.push(`"${this.getSubtotal().toLocaleString('en-US', {style: 'currency', currency: 'USD'})}"`);
		newRow.push(`"${this.getTotal().toLocaleString('en-US', {style: 'currency', currency: 'USD'})}"`);
		rows.push(newRow);
		return rows;
	}

	getFirstVisibleProduct() {
		const products = this.getProducts();
		for (let i = 0; i < products.length; i++) {
			const product = products[i];
			if (!product.deducted) {
				return i;
			}
		}
	}

	getVisibleProducts() {
		const products = this.getProducts();
		const visibleIndexes = [];
		for (let i = 0; i < products.length; i++) {
			const product = products[i];
			if (!product.deducted) {
				visibleIndexes.push(i);
			}
		}
		return visibleIndexes;
	}

	calculateDeductions() {
		const products = this.getProducts();
		let deductions = 0.0;
		if (products) {
			for (const product of products) {
				if (product.deducted) {
					deductions += parseFloat(product.total);
				}
			}
		}
		return deductions;
	}

	calculateSubtotal() {
		const total = parseFloat(this.getTotal());
		const deductions = parseFloat(this.getDeductions());
		return total - deductions;
	}
}
