class NeweggOrder {
	constructor(orderData) {
		// const shipData = orderData['fulfillmentStartInstructions'][0]['shippingStep']['shipTo'];
		/**
		 * @type {string}
		 */
		this.order_id = orderData['OrderNumber'];
		this.price = parseFloat(orderData['OrderItemAmount']);
		/**
		 * @type {NeweggLineItem[]}
		 */
		this.orderlines = [];
		for (const lineItem of orderData['ItemInfoList']) {
			this.orderlines.push(new NeweggLineItem(lineItem));
		}
		this.date_creation = orderData['OrderDate'];
		/**
		 * @type {string}
		 */
		this.recipient_name = `${orderData['ShipToFirstName']} ${orderData['ShipToLastName']}`;
		/**
		 * @type {string}
		 */
		this.legacy_order_id = orderData['legacyOrderId'];
		this.shipping_address = {
			/**
			 * @type {string}
			 */
			street : orderData['ShipToAddress1'],
			/**
			 * @type {string}
			 */
			street2 : orderData['ShipToAddress2'],
			/**
			 * @type {string}
			 */
			city : orderData['ShipToCityName'],
			/**
			 * @type {string}
			 */
			state : orderData['ShipToStateCode'],
			/**
			 * @type {string}
			 */
			zip : orderData['ShipToZipCode']
		};
		/**
		 * @type {string}
		 */
		this.email = orderData['CustomerEmailAddress'];
		/**
		 * @type {string}
		 */
		this.phone = orderData['CustomerPhoneNumber'];
		/**
		 * @type {string}
		 */
		this.shipper = orderData['ShipService'];
		/**
		 * @type {string}
		 */
		this.status_name = orderData['OrderStatusDescription'];
		this.channel = {
			identifier : 'newegg',
			name : 'Newegg'
		}
		this.errorMsg = orderData['error_msg'] || null;
		this.labelsPrinted = orderData['labels_printed'] || null;
		this.url = `https://sellerportal.newegg.com/manage-order/orderlist`;
	}

	getStandardizedString(str) {
		const translatedNames = {
			'Standard Shipping (5-7 business days)' : 'UPS Ground',
			'One-Day Shipping(Next day)' : 'UPS Next Day Air Saver',
			'Unshipped' : 'Awaiting Shipment'
		}
		return (translatedNames[str]) ? translatedNames[str] : str;
	}

	getTableRow() {
		const date = new Date(Date.parse(this.date_creation)).toLocaleString();
		let returnString =
			`<tr ${(this.errorMsg) ? `class="ship_error"` : ''}>
				<td class='halign-center' rowspan='${this.orderlines.length}'><input channel='${this.channel.identifier}' order_id='${this.order_id}' class='${this.channel.identifier}_select_checkbox' id='checkbox_${this.order_id}' type='checkbox' onchange='updateSelected(this)' /></td>
				<td rowspan='${this.orderlines.length}'><a href='${this.url}' target='_blank'>${this.order_id}</a></td>
				<td rowspan='${this.orderlines.length}'>${this.recipient_name}</td>
				<td rowspan='${this.orderlines.length}'>${date}</td>
				<td>${this.orderlines[0].getTitleCellContents()}</td>
				<td class='halign-center'>${this.orderlines[0]['quantity']}</td>
				<td class='halign-center' rowspan='${this.orderlines.length}'>$${this.price.toLocaleString()}</td>
				<td class='halign-center' rowspan='${this.orderlines.length}'>${this.getStandardizedString(this.shipper)}</td>
				<td class='halign-center' rowspan='${this.orderlines.length}'><p>${this.getStandardizedString(this.status_name)}</p>${(this.errorMsg) ? `<p>${this.errorMsg}</p>` : ''}${(this.labelsPrinted && this.labelsPrinted != '0') ? `<p>Labels Printed</p>` : ''}</td>
				<td rowspan='${this.orderlines.length}' class="halign-center">
					${this.getActionButtons()}
				</td>
			</tr>
			`;
		for (let i=1; i < this.orderlines.length; i++) {
			returnString += `
				<tr>
					<td>${this.orderlines[i].getTitleCellContents()}</td>
					<td class='halign-center'>$${this.orderlines[i].quantity}</td>
				</tr>
			`;
		}
		return returnString;
	}

	getActionButtons() {
		let actionButtons = `
			<!-- <p style="margin-top:6px;">
				<button onclick="viewAndPrint('${this.order_id}', 'newegg')">View And Print Packing Slip</button>
			</p> -->
			<p style="margin-top:6px;">
				<a href="packingslips/${this.order_id}_newegg_packingslip.pdf" target="_blank" class="action_button">View Packing Slip</a>
			</p>
			<p style="margin-top:6px;">
				<a href="${this.getWorldshipUrl()}" target="_blank" class="action_button">Create Shipping Label</a>
			</p>
			`;
		if (this.labelsPrinted) {
			actionButtons += `
				<p style="margin-top:6px;">
					<button type='button' id='reprint_label_button_${this.order_id}' class='action_button' order_id='${this.order_id}' channel='${this.channel.identifier}' onclick="reprintLabel(this)">Reprint Labels</button>
				</p>
			`;
		}
		return actionButtons;
	}

	getWorldshipUrl() {
		const shippers = {
			'Two-Day Shipping(2 business days)' : '2nd Day Air',
			'Standard Shipping (5-7 business days)' : 'Ground',
			"One-Day Shipping(Next day)" : 'Next Day Air Saver'
		}
		const shipper = shippers[this.shipper];
		const urlElements = {
			company : encodeURI(this.recipient_name),
			address1 : encodeURI(sanitizeString(this.shipping_address.street)),
			address2 : encodeURI(sanitizeString(this.shipping_address.street2)),
			city : encodeURI(sanitizeString(this.shipping_address.city)),
			state : encodeURI(sanitizeString(this.shipping_address.state)),
			zip : encodeURI(sanitizeString(this.shipping_address.zip)),
			phone : encodeURI(sanitizeString(this.phone)),
			email : encodeURI(sanitizeString(this.email)),
			ref1 : encodeURI(sanitizeString(this.channel.name)),
			ref2 : encodeURI(sanitizeString(this.order_id)),
			listing_id : this.orderlines[0].listing_id,
			channel : encodeURI(sanitizeString(this.channel.identifier)),
			shipper : encodeURI(shipper),
			origin : 'open_orders'
		}
		let url = `${CONTROLLER_BASE_URL}?m=worldship`;
		for (const element in urlElements) {
			if (urlElements[element] && urlElements[element] != 'null') {
				url += `&${element}=${urlElements[element]}`
			}
		}
		return url;

		/**
		 * Returns URL-safe string
		 * @param {string} str String to sanitize
		 */
		function sanitizeString(str) {
			if (str && typeof str == 'string') {
				str = str.replace('#', 'TTS_NUM');
				str = str.replace('&', 'TTS_AMP');
				str = str.replace('?', 'TTS_QST');
			}
			return str;
		}
	}
}
