const CONTROLLER_BASE_URL = "admin_controller.php";
const SORT_ASC_URL = '../svg/sort_asc.svg';
const SORT_DESC_URL = '../svg/sort_desc.svg';
const SORT_NONE_URL = '../svg/sort.svg';
const DEFAULT_SORT = 'Created_Time';

/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');

/**
 * @type {HTMLButtonElement}
 */
const saveButtons = document.getElementsByClassName('save_button');

/**
 * @type {HTMLTableElement}
 */
const record_table = document.getElementById('record_table');

/**
 * @type {HTMLHeadingElement}
 */
const title_header = document.getElementById('title');

const columnDefinitions = {
	owner: new ColumnDefinition('Sales', 'Owner', {isSortable: true}),
	mts: new ColumnDefinition('MTS', 'MTS_Quote_Number', {isSortable: true, linkBase: 'https://crm.zoho.com/crm/org26161413/tab/Invoices/LINKTO', linksTo: 'Invoice_Id'}),
	account_name: new ColumnDefinition('School', 'Account_Name', {isSortable: true, linkBase: 'https://crm.zoho.com/crm/org26161413/tab/Accounts/LINKTO', linksTo: 'Account_Id'}),
	created_time: new ColumnDefinition('Invoice Date', 'Created_Time', {isSortable: true}),
	products: new ColumnDefinition('SKU', 'Product_Name'),
	quantity: new ColumnDefinition('Quantity', 'Product_Quantity'),
	notes: new ColumnDefinition('Notes', 'notes'),
	ap: new ColumnDefinition('AP', 'ap'),
	at: new ColumnDefinition('AT', 'at'),
	subtotal: new ColumnDefinition('Subtotal', 'Total', {isSortable: true, prefix: '$'}),
	status: new ColumnDefinition('Status', 'Status'),
	newCustomer: new ColumnDefinition('NC', 'newCustomer')
};

/**
 * @type {ColumnDefinition[]}
 */
const columns = [
	columnDefinitions.owner,
	columnDefinitions.mts,
	columnDefinitions.account_name,
	columnDefinitions.created_time,
	columnDefinitions.products,
	columnDefinitions.quantity,
	columnDefinitions.notes,
	columnDefinitions.ap,
	columnDefinitions.at,
	columnDefinitions.newCustomer,
	columnDefinitions.status,
	columnDefinitions.subtotal,
];


const recordDict = {};

/**
 * @type {TtsOrder[]}
 */
const recordArray = [];

const statuses = [];

const values = {
	total: 0,
	new: 0,
	backordered: 0,
	on_order: 0,
	picked: 0,
	ready_to_ship: 0
}

const sort = {
	by: 'Created_Time',
	order: 1
};

let listenerAttached = false;
let updateElementsVisible = false;

init();

function init() {
	getStatuses();
}

function addResizeListener() {
	if (!listenerAttached) {
		window.addEventListener('resize', () => {
			title_header.style.maxWidth = `${record_table.clientWidth}px`;
		});
	}
	listenerAttached = true;
}

function getStatuses() {
	const url = `${CONTROLLER_BASE_URL}?m=get_open_order_statuses`, poststr = ``;
	makeAjaxRequest(url, poststr, 'POST', returnStatuses);
	function returnStatuses() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const data = JSON.parse(http_request.response);
					if (typeof data == 'object') {
						for(const status of data) {
							statuses.push(status);
						}
					}
					getRecords();
					return true;
				default:
					return false;
			}
		}
	}
}

function getRecords() {
	const url = `${CONTROLLER_BASE_URL}?m=zoho_get_records`, poststr = ``;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnZohoRecords);
	/**
	 * Get the records from Zoho
	 */
	function returnZohoRecords(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const response = http_request.response;
					const parseReponse = (res) => {
						try {
							const data = JSON.parse(res);
							return data;
						}
						catch (err) {
							console.error(err);
							const data = false;
							return data;
						}
					}
					const data = parseReponse(response);
					if (typeof data == 'object') {
						console.log(data);
						emptyArrays();
						for (const member in recordDict) {
							delete member;
						}
						const updateItems = [];
						const orderNums = [];
						const recordLineItems = {};
						data.forEach(element => {
							element['changed'] = false; // Set element's changed status to false. Is used to track which items to send to DB for update when "save all changes" is clicked.
							updateItems.push(`('${element['Invoice_Id']}', 1)`) // Insert invoice ID and 1 into update array. 1 represents New Order status.
							orderNums.push(element['Invoice_Id']); // Push the invoice ID into the array of order numbers.

							const newRecordTest = new TtsOrder(element);

							recordArray.push(newRecordTest);
							recordDict[element['Invoice_Id']] = newRecordTest;

							if (Array.isArray(element['Products']) && element['Products'].length > 0) {
								recordLineItems[element['Invoice_Id']] = element['Products'];
							}
						});
						const updateStr = updateItems.join(',');
						const orderNumsStr = `('` + orderNums.join(`','`) + `')`;
						const updateStrNew = orderNums.join(',');
						const recordStr = JSON.stringify(recordLineItems).replace('&', `and`);
						const url = `${CONTROLLER_BASE_URL}?m=update_and_retrieve_local_open_orders`, poststr = `update=${updateStr}&orders=${orderNumsStr}&ordersNew=${updateStrNew}&records=${recordStr}`;
						makeAjaxRequest(url, poststr, 'POST', returnLocalRecords);
					}
					else {
						alert("No open orders found. If this is in error, please contact developer.");
						setLoadingModalVisible(false);
					}
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
	function returnLocalRecords() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const data = JSON.parse(http_request.response);
					if (typeof data == 'object') {
						console.log(data);
						if (!data['orders']) {
							alert("No open orders found.");
							setLoadingModalVisible(false);
							break;
						}
						for(const record of data['orders']) {
							const status = parseInt(record['status_id']);
							const assetTags = parseInt(record['asset_tags']);
							recordDict[record['zoho_id']]['notes'] = record['notes'];
							recordDict[record['zoho_id']]['status_id'] = status;
							recordDict[record['zoho_id']]['asset_tags'] = (assetTags) ? 1 : 0;
							recordDict[record['zoho_id']]['newCustomer'] = (record['new_customer_order'] == '1');
							if (recordDict[record['zoho_id']]['Products'].length > 0) {
								const subtotal = parseFloat(recordDict[record['zoho_id']]['Total']) - parseFloat(recordDict[record['zoho_id']]['Deduction']);
								values.total += subtotal;
								switch (status) {
									case 5:
										values.ready_to_ship += subtotal;
										break;
									case 4:
										values.picked += subtotal;
										break;
									case 3:
										values.on_order += subtotal;
										break;
									case 2:
										values.backordered += subtotal;
										break;
									case 1:
										values.new += subtotal;
										break;
									default:
										break;
								}
							}
						}
						sortRecords();
						renderPage();
					}
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortRecords();
	renderBody();
}

function sortRecords() {
	recordArray.sort((a, b) => sortFunction(a,b));
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
	function sortFunction(a,b) {
		if(isNaN(a[sort.by])) {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}

function saveChanges(orderNum) {
	/**
	 * @type {HTMLButtonElement}
	 */
	const saveButton = document.getElementById(`save_button_${orderNum}`);
	saveButton.disabled = true;
	const record = recordDict[orderNum];
	const url = `${CONTROLLER_BASE_URL}?m=save_open_order_single`, poststr = record.getPostString();
	makeAjaxRequest(url, poststr, 'POST', returnConfirmation);
	function returnConfirmation() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					saveButton.disabled = false;
					console.log(http_request.response);
					renderBody();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

function saveAllChanges() {
	/**
	 * @type {HTMLButtonElement}
	 */
	const saveButton = document.getElementById(`save_button_all`);
	saveButton.disabled = true;
	const recordsToUpdate = {};
	for (const record of recordArray) {
		if (record.changed) {
			recordsToUpdate[record.getZohoId()] = record.getObjectRepresentation();
		}
	}
	const url = `${CONTROLLER_BASE_URL}?m=save_open_order_multiple`, poststr = `orders=${JSON.stringify({records: recordsToUpdate})}`;
	console.log(url, poststr);
	makeAjaxRequest(url, poststr, 'POST', returnConfirmation);
	function returnConfirmation() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					saveButton.disabled = false;
					renderBody();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

function renderPage() {
	/**
	 * @type {HTMLSpanElement}
	 */
	const total_orders_span = document.getElementById('total_orders_span');
	/**
	 * @type {HTMLSpanElement}
	 */
	const total_orders_header_number = document.getElementById('total_orders_header_number');
	/**
	 * @type {HTMLSpanElement}
	 */
	const total_value_header_number = document.getElementById('total_value_header_number');
	total_orders_header_number.innerHTML = '';
	total_orders_header_number.innerHTML = recordArray.length;

	total_value_header_number.innerHTML = '';
	total_value_header_number.innerHTML = `$${Math.round(values.total).toLocaleString()}`;

	clearPage();
	renderHeaders();
	renderBody();
	title_header.style.maxWidth = `${record_table.clientWidth}px`;
	addResizeListener();
	total_orders_span.classList.remove('pseudo_hidden');
	setLoadingModalVisible(false);
}
function renderHeaders() {
	renderHeader('new_orders');
	renderHeader('back_ordered');
	renderHeader('on_order');
	renderHeader('picked');
	renderHeader('ready_to_ship');
	renderValues();
	function renderHeader(section) {
		/**
		 * @type {HTMLTableRowElement}
		 */
		const headerRow = document.getElementById(`${section}_header_row`);
		headerRow.innerHTML = '';
		for (const column of columns) {
			headerRow.innerHTML += column.buildHeader();
		}
		headerRow.innerHTML += `<th><button type="button" id="save_button_all" onclick="saveAllChanges()">Save All Changes</button></th>`;
	}
	function renderValues() {
		const valueHeaders = {
			new: document.getElementById('value_new'),
			backordered: document.getElementById('value_backordered'),
			on_order: document.getElementById('value_on_order'),
			picked: document.getElementById('value_picked'),
			ready_to_ship: document.getElementById('value_ready_to_ship'),
		}
		for (const header in valueHeaders) {
			valueHeaders[header].innerHTML = '';
			valueHeaders[header].innerHTML = `$${Math.round(values[header]).toLocaleString()}`;
		}
	}
}
function renderBody() {
	clearBodies();
	/**
	 * @type {HTMLTableSectionElement}
	 */
	const newOrdersBody = document.getElementById('new_orders_body');
	const backOrderedBody = document.getElementById('back_ordered_body');
	const onOrderBody = document.getElementById('on_order_body');
	const pickedBody = document.getElementById('picked_body');
	const readyToShipBody = document.getElementById('ready_to_ship_body');

	let newOrdersRowNum = backOrderedRowNum = onOrderRowNum = pickedRowNum = readyToShipRowNum = 0;

	recordArray.forEach(record => {
		if (record['Products'].length > 0) {
			if (record['status_id'] == 5) {
				// readyToShipBody.innerHTML += renderRow(record);
				readyToShipBody.appendChild(record.getMainRecordRow(true, newOrdersRowNum));
				const visibleProducts = record.getVisibleProducts();
				for (let i = 1; i < visibleProducts.length; i++) {
					readyToShipBody.appendChild(record.getProductRow(newOrdersRowNum, visibleProducts[i]))
				}
				readyToShipRowNum++;
			} else if (record['status_id'] == 4) {
				// pickedBody.innerHTML += renderRow(record);
				pickedBody.appendChild(record.getMainRecordRow(true, newOrdersRowNum));
				const visibleProducts = record.getVisibleProducts();
				for (let i = 1; i < visibleProducts.length; i++) {
					pickedBody.appendChild(record.getProductRow(newOrdersRowNum, visibleProducts[i]))
				}
				pickedRowNum++;
			} else if (record['status_id'] == 3) {
				// onOrderBody.innerHTML += renderRow(record);
				onOrderBody.appendChild(record.getMainRecordRow(true, newOrdersRowNum));
				const visibleProducts = record.getVisibleProducts();
				for (let i = 1; i < visibleProducts.length; i++) {
					onOrderBody.appendChild(record.getProductRow(newOrdersRowNum, visibleProducts[i]))
				}
				onOrderRowNum++;
			} else if (record['status_id'] == 2) {
				// backOrderedBody.innerHTML += renderRow(record);
				backOrderedBody.appendChild(record.getMainRecordRow(true, newOrdersRowNum));
				const visibleProducts = record.getVisibleProducts();
				for (let i = 1; i < visibleProducts.length; i++) {
					backOrderedBody.appendChild(record.getProductRow(newOrdersRowNum, visibleProducts[i]))
				}
				backOrderedRowNum++;
			}
			else {
				// newOrdersBody.innerHTML += renderRow(record);
				newOrdersBody.appendChild(record.getMainRecordRow(true, newOrdersRowNum));
				const visibleProducts = record.getVisibleProducts();
				for (let i = 1; i < visibleProducts.length; i++) {
					newOrdersBody.appendChild(record.getProductRow(newOrdersRowNum, visibleProducts[i]))
				}
				newOrdersRowNum++;
			}
		}
	});
	function renderRow(record) {
		const numProducts = record['Products'].length;
		const products = record['Products'];
		const date = record['Created_Time'];
		/**
		 * @type {string}
		 */
		const ownerName = record['Owner'];
		/**
		 * @type {number}
		 */
		const subTotal = parseFloat(record['Total']) - parseFloat(record['Deduction']);
		let returnString =  `
			<tr ${getRowClasses()}>
				<td rowspan='${numProducts}'>${ownerName.substring(0, ownerName.indexOf(' '))}</td>
				<td rowspan='${numProducts}'><a href='https://crm.zoho.com/crm/org26161413/tab/Invoices/${record['Invoice_Id']}' target='_blank'>${record['MTS_Quote_Number']}</a></td>
				<td rowspan='${numProducts}'><a href='https://crm.zoho.com/crm/org26161413/tab/Accounts/${record['Account_Id']}' target='_blank'>${record['Account_Name']}</a></td>
				<td rowspan='${numProducts}'>${new Date(Date.parse(date)).toLocaleDateString()}</td>
				<td><a href='https://crm.zoho.com/crm/org26161413/tab/Invoices/${record['Invoice_Id']}#secDiv_Product_Details' target='_blank'>${(products[0]['code']) ? products[0]['code'] : products[0]['name']}</a> <a hidden class="updateElement" href="javascript:void(0)" onclick="addToDeductions('${record['Invoice_Id']}')"><small>(deduct)</small></a></td>
				<td class='halign-center'>${products[0]['quantity']}</td>
				<td rowspan='${numProducts}'><textarea rows='3' class='note-input' placeholder='Enter notes...' invoice_id="${record['Invoice_Id']}" onchange="updateNote(this)">${(record['notes']) ? record['notes'] : ''}</textarea></td>
				<td class='halign-center' rowspan='${numProducts}'><input type='checkbox' name="ap_${record['Invoice_Id']}" id="ap_${record['Invoice_Id']}" invoice_id="${record['Invoice_Id']}" onchange="updateAPStatus(this)" ${(record['AP_Data_Present']) ? 'checked' : ''} readonly /></td>
				<td class='halign-center' rowspan='${numProducts}'><input type='checkbox' name="at_${record['Invoice_Id']}" id="at_${record['Invoice_Id']}" invoice_id="${record['Invoice_Id']}" onchange="updateATStatus(this)" ${(record['asset_tags']) ? 'checked' : ''} readonly /></td>
				<td rowspan='${numProducts}'>${createStatusSelect()}</td>
				<td rowspan='${numProducts}'>$${Math.round(subTotal).toLocaleString()}</td>
				<td rowspan='${numProducts}' class="halign-center"><button type='button' id="save_button_${record['Invoice_Id']}" class="save_button" invoice_id="${record['Invoice_Id']}" onclick="saveChanges('${record['Invoice_Id']}')" >Save Changes</button></td>
			</tr>
		`;
		for (let i=1; i < products.length; i++) {
			returnString += `
				<tr ${getRowClasses()}>
					<td><a href='https://crm.zoho.com/crm/org26161413/tab/Invoices/${record['Invoice_Id']}#secDiv_Product_Details' target='_blank'>${(products[i]['code']) ? products[i]['code'] : products[0]['name']}</a> <a hidden class="updateElement" href="javascript:void(0)" onclick="addToDeductions('${record['Invoice_Id']}')"><small>(deduct)</small></a></td>
					<td class='halign-center'>${products[i]['quantity']}</td>
				</tr>
			`;
		}
		return returnString;

		function getRowClasses() {
			const classes = [];
			if (record['asset_tags']) {
				classes.push('asset_tags');
			}
			return (classes.length > 0) ? `class="${classes.join(' ')}"` : '';
		}

		function createStatusSelect() {
			let ret = `<select class="borderless" id="status_select_${record['Invoice_Id']}" invoice_id="${record['Invoice_Id']}" onchange="updateStatus(this)">`;
			for (const status of statuses) {
				ret += `<option value="${status['id']}" ${(record['status_id'] == status['id']) ? "selected" : ""}>${status['status']}</option>`;
			}
			ret += "</select>";
			return ret;
		}
	}
}

/**
 *
 * @param {HTMLTextAreaElement} obj
 */
function updateNote(obj) {
	const invoice = obj.getAttribute('invoice_id');
	recordDict[invoice].notes = obj.value;
	recordDict[invoice].changed = true;
}

/**
 *
 * @param {HTMLInputElement} input Checkbox of the AT status
 */
function updateATStatus(input) {
	const invoice = input.getAttribute('invoice_id');
	recordDict[invoice].asset_tags = (input.checked) ? 1 : 0;
	recordDict[invoice].changed = true;
}

/**
 *
 * @param {HTMLSelectElement} obj
 */
function updateStatus(obj) {
	const invoice = obj.getAttribute('invoice_id');
	recordDict[invoice].status_id = obj.value;
	recordDict[invoice].changed = true;
}

function clearPage() {
	setLoadingModalVisible(true);
	clearHeaders();
	clearBodies();
}
function clearHeaders(section="all") {
	if (section == 'all') {
		clearHeader('new_orders');
		clearHeader('back_ordered');
		clearHeader('on_order');
		clearHeader('picked');
		clearHeader('ready_to_ship');
	} else {
		clearHeader(section);
	}
	function clearHeader(section) {
		/**
		 * @type {HTMLTableRowElement}
		 */
		const headerRow = document.getElementById(`${section}_header_row`);
		headerRow.innerHTML = '';
	}
}
function clearBodies(section="all") {
	if (section == 'all') {
		clearBody('new_orders');
		clearBody('back_ordered');
		clearBody('on_order');
		clearBody('picked');
		clearBody('ready_to_ship');
	} else {
		clearBody(section);
	}
	function clearBody(section) {
		/**
		 * @type {HTMLTableSectionElement}
		 */
		const tableBody = document.getElementById(`${section}_body`);
		tableBody.innerHTML = '';
	}
}

function emptyArrays() {
	recordArray.length = 0;
	for (const type in values) {
		values[type] = 0;
	}
}

function toggleUpdateElementsVisible() {
	updateElementsVisible = !updateElementsVisible;
	setUpdateElementsVisible(updateElementsVisible);
}

/**
 *
 * @param {boolean} visible
 */
function setUpdateElementsVisible(visible) {
	/**
	 * @type {HTMLCollectionOf<HTMLTableCellElement>}
	 */
	const columnElements = document.getElementsByClassName('updateElement');
	for (const element of columnElements) {
		element.hidden = !visible;
	}
}

/**
 *
 * @param {string} zohoId
 */
function addToDeductions(zohoId) {
	const url = `${CONTROLLER_BASE_URL}?m=addToDeductions&module=tts&view=open&id=${zohoId}`;
	fetch(url)
	.then(response => response.json())
	.then(data => {
		console.log(data);
		getRecords();
	});
}
