class OpenOrder {
	constructor(orderData) {
		/**
		 * @type {string}
		 */
		this.zoho_id = orderData['Invoice_Id'] || '';
		/**
		 * @type {string}
		 */
		this.notes = orderData['notes'] || '';
		/**
		 * @type {number}
		 */
		this.status_id = parseInt(orderData['status_id']) || 1;
		/**
		 * @type {number}
		 */
		this.asset_tags = parseInt(orderData['asset_tags']) || 0;
	}

	getPostString() {
		return `zoho_id=${this.zoho_id}&notes=${this.notes}&status_id=${this.status_id}&asset_tags=${this.asset_tags}`;
	}

	getObjectRepresentation() {
		return {
			'zoho_id': this.zoho_id,
			'notes': this.notes,
			'status_id' : this.status_id || 1,
			'asset_tags' : this.asset_tags || 0
		};
	}
}
