class EbayLineItem {
	constructor(lineItemData) {
		this.listing = lineItemData['title'];
		this.listing_id = lineItemData['lineItemId'];
		this.legacy_id = lineItemData['legacyItemId'];
		this.quantity = lineItemData['quantity'];
		this.sku = lineItemData['sku'];
	}

	getUrl() {
		return `https://www.ebay.com/itm/${this.legacy_id}`;
	}

	getTitle() {
		return this.listing;
	}

	getTitleCellContents() {
		return `<a href='${this.getUrl()}' target='_blank'>${this.getTitle()}</a><p>SKU: ${this.sku}</p>`;
	}
}
