class AmazonLineItem {
	constructor(lineItemData) {
		this.listing = lineItemData['title'];
		this.listing_id = lineItemData['line_item_id'];
		this.quantity = lineItemData['quantity'];
		this.sku = lineItemData['sku'];
	}

	getUrl() {
		return `https://www.amazon.com/gp/product/${this.listing_id}`;
	}

	getTitle() {
		return this.listing;
	}

	getTitleCellContents() {
		return `<a href='${this.getUrl()}' target='_blank'>${this.getTitle()}</a><p>SKU: ${this.sku}</p>`;
	}
}
