const CONTROLLER_BASE_URL = "admin_controller.php";
const SORT_ASC_URL = '../svg/sort_asc.svg';
const SORT_DESC_URL = '../svg/sort_desc.svg';
const SORT_NONE_URL = '../svg/sort.svg';
const DEFAULT_SORT = 'Created_Time';

/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');

/**
 * @type {HTMLButtonElement}
 */
const saveButtons = document.getElementsByClassName('save_button');

/**
 * @type {HTMLTableElement}
 */
const record_table = document.getElementById('record_table');

/**
 * @type {HTMLHeadingElement}
 */
const title_header = document.getElementById('title');

const columnDefinitions = {
	order_id: new ColumnDefinition('Order ID', 'order_id', {isSortable: true, linkBase: 'https://www.backmarket.com/bo_merchant/orders#modalLINKTO', linksTo: 'order_id'}),
	recipient_name: new ColumnDefinition('Recipient Name', 'recipient_name', {isSortable: true}),
	date_creation: new ColumnDefinition('Date Order Placed', 'date_creation', {isSortable: true}),
	products: new ColumnDefinition('SKU', 'listing', {spansMultipleRows: false}),
	quantity: new ColumnDefinition('Quantity', 'quantity', {spansMultipleRows: false}),
	notes: new ColumnDefinition('Notes', 'sp_notes'),
	price: new ColumnDefinition('Subtotal', 'price', {isSortable: true, prefix: '$'}),
	shipper: new ColumnDefinition('Ship Method', 'shipper', {isSortable: true}),
	status_name: new ColumnDefinition('Status', 'status_name', {isSortable: true})
};

const columns = {
	/**
	 * @type {ColumnDefinition[]}
	 */
	amazon: [
		columnDefinitions.order_id,
		columnDefinitions.recipient_name,
		columnDefinitions.date_creation,
		columnDefinitions.products,
		columnDefinitions.quantity,
		// columnDefinitions.notes,
		columnDefinitions.price,
		columnDefinitions.shipper,
		columnDefinitions.status_name
	],
	/**
	 * @type {ColumnDefinition[]}
	 */
	back_market: [
		columnDefinitions.order_id,
		columnDefinitions.recipient_name,
		columnDefinitions.date_creation,
		columnDefinitions.products,
		columnDefinitions.quantity,
		// columnDefinitions.notes,
		columnDefinitions.price,
		columnDefinitions.shipper,
		columnDefinitions.status_name
	],
	/**
	 * @type {ColumnDefinition[]}
	 */
	ebay_auction: [
		columnDefinitions.order_id,
		columnDefinitions.recipient_name,
		columnDefinitions.date_creation,
		columnDefinitions.products,
		columnDefinitions.quantity,
		// columnDefinitions.notes,
		columnDefinitions.price,
		columnDefinitions.shipper,
		columnDefinitions.status_name
	],
	/**
	 * @type {ColumnDefinition[]}
	 */
	ebay_other: [
		columnDefinitions.order_id,
		columnDefinitions.recipient_name,
		columnDefinitions.date_creation,
		columnDefinitions.products,
		columnDefinitions.quantity,
		// columnDefinitions.notes,
		columnDefinitions.price,
		columnDefinitions.shipper,
		columnDefinitions.status_name
	],
	/**
	 * @type {ColumnDefinition[]}
	 */
	newegg: [
		columnDefinitions.order_id,
		columnDefinitions.recipient_name,
		columnDefinitions.date_creation,
		columnDefinitions.products,
		columnDefinitions.quantity,
		// columnDefinitions.notes,
		columnDefinitions.price,
		columnDefinitions.shipper,
		columnDefinitions.status_name
	],
};

const channelNames = {
	back_market : "Back Market",
	ebay_auction : "eBay Auction",
	ebay_fixedprice : "eBay Market",
	ebay_other : "eBay Other"
}

const recordDicts = {};

const recordArrays = {};

const statuses = [];

const values = {
	total: 0
}

const sort = {
	by: 'Created_Time',
	order: 1
};

let listenerAttached = false;

init();

function init() {
	getRecords();
}

function addResizeListener() {
	if (!listenerAttached) {
		window.addEventListener('resize', () => {
			title_header.style.maxWidth = `${record_table.clientWidth}px`;
		});
	}
	listenerAttached = true;
}

function getRecords() {
	const url = `${CONTROLLER_BASE_URL}?m=get_ecommerce_open_orders${(window.location.href.indexOf('debug') != -1) ? '&debug=1' : ''}`, poststr = ``;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, poststr, 'POST', returnRecords);
	/**
	 * Get the records from Zoho
	 */
	function returnRecords(){
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const data = JSON.parse(http_request.response);
					if (typeof data == 'object') {
						values.total = 0;
						for (const type in data) {
							const recordType = data[type]['order_type'];
							recordDicts[type] = {};
							recordArrays[type] = [];
							values[type] = 0;
							for (const record of data[type]['orders']) {
								record['channel_identifier'] = type;
								record['channel_name'] = channelNames[type];
								const recordObj = getRecordObject(record, recordType);
								recordDicts[type][recordObj['order_id']] = recordObj;
								recordArrays[type].push(recordObj);
								values[type] += parseFloat(recordObj['price']);
							}
							values.total += values[type];
						}
						// recordDicts['back_market'] = {};
						// recordArrays['back_market'] = [];
						// values['back_market'] = 0;
						// for (const record of data['back_market']['orders']) {
						// 	recordDicts['back_market'][record['order_id']] = record;
						// 	recordArrays['back_market'].push(record);
						// 	values['back_market'] += parseFloat(record['price']);
						// }
						// values.total += values['back_market'];
						renderPage();
					}
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}

	function getRecordObject(record, recordType) {
		if (recordType == 'ebay') {
			return new EbayOrder(record);
		}
		else if (recordType == 'backmarket') {
			return new BackMarketOrder(record);
		}
		else if (recordType == 'newegg') {
			return new NeweggOrder(record);
		}
		else if (recordType == 'amazon') {
			return new AmazonOrder(record);
		}
		else {
			return record;
		}
	}
}

function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortRecords();
	renderBody();
}

function sortRecords() {
	// recordArray.sort((a, b) => sortFunction(a,b));
	for(const type in recordArrays) {
		recordArrays[type].sort((a,b) => sortFunction(a,b));
	}
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
	function sortFunction(a,b) {
		if(isNaN(a[sort.by])) {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}

function renderPage() {
	/**
	 * @type {HTMLSpanElement}
	 */
	const total_orders_span = document.getElementById('total_orders_span');
	/**
	 * @type {HTMLSpanElement}
	 */
	const total_orders_header_number = document.getElementById('total_orders_header_number');
	/**
	 * @type {HTMLSpanElement}
	 */
	const total_value_header_number = document.getElementById('total_value_header_number');
	let totalNumOrders = 0;
	for (const type in recordArrays) {
		totalNumOrders += recordArrays[type].length;
	}
	total_orders_header_number.innerHTML = '';
	total_orders_header_number.innerHTML = totalNumOrders;

	total_value_header_number.innerHTML = '';
	total_value_header_number.innerHTML = `$${Math.round(values.total).toLocaleString()}`;

	clearPage();
	renderHeaders();
	renderBody();
	title_header.style.maxWidth = `${record_table.clientWidth}px`;
	addResizeListener();
	total_orders_span.classList.remove('pseudo_hidden');
	setLoadingModalVisible(false);
}
function renderHeaders() {
	let hasRecords = false;
	for (const type in recordDicts) {
		if (recordDicts[type] && Object.keys(recordDicts[type]).length > 0) {
			hasRecords = true;
			renderHeader(type);
		}
	}
	renderValues();
	function renderHeader(section) {
		/**
		 * @type {HTMLTableRowElement}
		 */
		document.getElementById(`${section}_thead`).hidden = false;
		const headerRow = document.getElementById(`${section}_header_row`);
		headerRow.innerHTML = `<th><button onclick="selectAll('${section}')">Select All</button></th>`;
		for (const column of columns[section]) {
			headerRow.innerHTML += column.buildHeader();
		}
		// headerRow.innerHTML += `<th><button type="button" id="save_button_all" onclick="saveAllChanges('${section}')">Save All Changes</button></th>`;
		headerRow.innerHTML += `<th>Order Actions</th>`;
	}
	function renderValues() {
		for (const type in recordDicts) {
			const valueHeader = document.getElementById(`value_${type}`)
			valueHeader.innerHTML = '';
			valueHeader.innerHTML = `$${Math.round(values[type]).toLocaleString()}`
		}
	}
}

/**
 *
 * @param {HTMLInputElement} input
 */
function updateSelected(input) {
	const channel = input.getAttribute('channel');
	const orderId = input.getAttribute('order_id');
	recordDicts[channel][orderId]['selected'] = input.checked;
}

function selectAll(section) {
	/**
	 * @type {HTMLCollectionOf<HTMLInputElement>}
	 */
	const checkboxes = document.getElementsByClassName(`${section}_select_checkbox`);

	for (const checkbox of checkboxes) {
		checkbox.checked = !checkbox.checked;
		const orderId = checkbox.getAttribute('order_id');
		const channel = checkbox.getAttribute('channel');
		recordDicts[channel][orderId]['selected'] = checkbox.checked;
	}
}

function renderBody() {
	clearBodies();
	for (const type in recordArrays) {
		for (const record of recordArrays[type]) {
			const typeBody = document.getElementById(`${type}_body`);
			typeBody.innerHTML += renderRow(record);
		}
	}
	/**
	 *
	 * @param {BackMarketOrder|EbayOrder} record
	 * @param {string} type
	 */
	function renderRow(record) {
		return record.getTableRow();
	}
}

/**
 *
 * @param {HTMLButtonElement} button
 */
function printPackingSlip(button) {
	setLoadingModalVisible(true);
	const orderId = button.getAttribute('order_id');
	const channel = button.getAttribute('channel');

	const url = `${CONTROLLER_BASE_URL}?m=print_packing_slip`;
	const postStr = `order_id=${orderId}&channel=${channel}`;
	makeAjaxRequest(url, postStr, 'POST', returnResult);

	function returnResult() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					// getRecords();
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

function shipSelected(channel) {
	const orderIds = [];
	const verboseLogging = document.getElementById('debug_verboselogging').checked;
	for (const order in recordDicts[channel]) {
		if (recordDicts[channel][order]['selected'] && recordDicts[channel][order]['state'] == 3) {
			orderIds.push(order);
		}
	}
	if (orderIds.length > 0) {
		setLoadingModalVisible(true);
		const url = `${CONTROLLER_BASE_URL}?m=ship_${channel}_orders`;
		const postStr = `order_ids=${orderIds.join(',')}${(verboseLogging) ? '&verboselogging=yes' : ''}`;
		makeAjaxRequest(url, postStr, 'POST', returnResult);
		// alert(`This is presently a nonfunctional placeholder.\n${url}\n${postStr}`);
	}

	function returnResult() {
		if (http_request.readyState == 4) {
			// console.log(http_request.response);
			switch (http_request.status) {
				case 200:
					if (verboseLogging) {
						console.log(http_request.response);
					}
					else {
						getRecords();
					}
					setLoadingModalVisible(false);
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
	// alert('This is presently a nonfunctional placeholder.');
}

function validateSelected(channel) {
	const orderIds = [];
	for (const order in recordDicts[channel]) {
		if (recordDicts[channel][order]['selected'] && recordDicts[channel][order]['state'] == 1) {
			orderIds.push(order);
		}
	}
	if (orderIds.length > 0) {
		setLoadingModalVisible(true);
		const url = `${CONTROLLER_BASE_URL}?m=validate_${channel}_orders`;
		const postStr = `order_ids=${orderIds.join(',')}`;
		makeAjaxRequest(url, postStr, 'POST', returnResult);
	}
	function returnResult() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					getRecords();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 *
 * @param {HTMLButtonElement} input
 */
function validateOrder(input) {
	setLoadingModalVisible(true);
	const channel = input.getAttribute('channel');
	const orderId = input.getAttribute('order_id');
	const url = `${CONTROLLER_BASE_URL}?m=validate_${channel}_order`;
	const postStr = `order_id=${orderId}`;
	makeAjaxRequest(url, postStr, 'POST', returnResult);

	function returnResult() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					getRecords();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 *
 * @param {HTMLButtonElement} input
 */
function cancelOrder(input) {
	const channel = input.getAttribute('channel');
	const orderId = input.getAttribute('order_id');
	const url = `${CONTROLLER_BASE_URL}?m=cancel_${channel}_order`;
	const postStr = `order_id=${orderId}`;
	const confirmMessage = `You are about to cancel order ${orderId}.\n\nThis CANNOT be undone.\n\nAre you sure you want to do this?`;
	if (confirm(confirmMessage)) {
		// alert('canceling order');
		setLoadingModalVisible(true);
		makeAjaxRequest(url, postStr, 'POST', returnResult);
	}

	function returnResult() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					getRecords();
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

/**
 * Sends command to server to reprint a label
 * @param {HTMLButtonElement} input Reprint label button
 */
function reprintLabel(input) {
	const channel = input.getAttribute('channel');
	const orderId = input.getAttribute('order_id');
	const url = `${CONTROLLER_BASE_URL}?m=reprint_packing_slip`;
	const postStr = `order_id=${orderId}&channel=${channel}`;
	makeAjaxRequest(url, postStr, 'POST', returnResult);
	function returnResult() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					alert("Packing slip reprinted.");
					break;
				default:
					alert("Error with AJAX request.");
					setLoadingModalVisible(false);
			}
		}
	}
}

function clearPage() {
	setLoadingModalVisible(true);
	clearHeaders();
	clearBodies();
}
function clearHeaders(section="all") {
	if (section == 'all') {
		for (const type in recordDicts) {
			clearHeader(type);
		}
	} else {
		clearHeader(section);
	}
	function clearHeader(section) {
		/**
		 * @type {HTMLTableRowElement}
		 */
		const headerRow = document.getElementById(`${section}_header_row`);
		headerRow.innerHTML = '';
	}
}
function clearBodies(section="all") {
	if (section == 'all') {
		for (const type in recordDicts) {
			clearBody(type);
		}
	} else {
		clearBody(section);
	}
	function clearBody(section) {
		/**
		 * @type {HTMLTableSectionElement}
		 */
		const tableBody = document.getElementById(`${section}_body`);
		tableBody.innerHTML = '';
	}
}

function emptyArrays() {
	recordArray.length = 0;
	for (const type in values) {
		values[type] = 0;
	}
}

function viewAndPrint(orderId, channel) {
	const w = window.open(`packingslips/${orderId}_${channel}_packingslip.pdf`, "", "");
	w.addEventListener('load', function() {
		w.print();
		// w.close();
	});
}
