class OpenOrder {
	constructor(orderData) {
		/**
		 * @type {string}
		 */
		this.order_id = orderData['order_id'] || '';
		/**
		 * @type {string}
		 */
		this.notes = orderData['sp_notes'] || '';
		/**
		 * @type {number}
		 */
		this.price = Math.round(parseFloat(orderData['price'])) || 1;
	}

	getPostString() {
		return `order_id=${this.order_id}&notes=${this.notes}`;
	}

	getObjectRepresentation() {
		return {
			'order_id': this.order_id,
			'notes': this.notes,
			'price' : this.price || 1
		};
	}
}
