/**
 * Defines column parameters.
 * @author Michael Kemper
 * @since 2020-06-22
 */
class ColumnDefinition {
	/**
	 *
	 * @param {string} displayName Set column display name.
	 * @param {string} identifier Set column identifier.
	 * @param options Set column options.
	 */
	constructor(displayName, identifier, options = {isNumeric: false, isSortable: false, isFilterable: false, prefix: ''}) {
		this.displayName = displayName;
		this.identifier = identifier;
		this.isNumeric = options.isNumeric || false;
		this.isSortable = options.isSortable || false;
		this.isFilterable = options.isFilterable || false;
		this.prefix = options.prefix || '';
	}

	buildHeader() {
		const sortString = (this.isSortable) ? `sort_order="${this.identifier}"` : '';

		return `
			<th class="header_cell" ${sortString}>
				${this.getSortSpan()}
				${this.getFilterInput()}
			</th>
		`;
	}

	getFilterInput() {
		return (this.isFilterable) ? `<input type="text" class="filter_input ${this.identifier}_filter width-80pct" is_numeric="${this.isNumeric}" filter="${this.identifier}" placeholder="Filter..." onkeyup="filterInput(this)" />` : '';
	}

	getSortSpan() {
		return (this.isSortable) ? `<span class="sort_icon_span cursor-pointer" sort_order="${this.identifier}" is_numeric="${this.isNumeric}" onclick="setSort(this.getAttribute('sort_order'))">${this.displayName} <img class="sort_icon" src="../svg/sort.svg"></span>` : `${this.displayName}`;
	}
}
