class LineItem {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.productZohoId = data['productZohoId'];
		/**
		 * @type {string}
		 */
		this.productName = data['productName'];
		/**
		 * @type {string}
		 */
		this.productCode = data['productCode'];
		/**
		 * @type {string}
		 */
		this.productDescription = data['productDescription'];
		/**
		 * @type {number}
		 */
		this.productQuantity = parseInt(data['productQuantity']);

		this.aGradePrice = parseInt(data['aGradePrice']);
		this.bGradePrice = parseInt(data['bGradePrice']);
		this.cGradePrice = parseInt(data['cGradePrice']);
		this.dGradePrice = parseInt(data['dGradePrice']);

		this.highPrice = this.calculateHighPrice();
		this.minimumPrice = this.calculateMinimumPrice();

		/**
		 * @type {string}
		 */
		this.filter = (data['productCode']) ? data['productCode'] : data['productName'];

		this.isVisible = true;
	}

	getProductCode() {
		return this.productCode;
	}

	getProductName() {
		return this.productName;
	}

	getProductZohoId() {
		return this.productZohoId;
	}

	getProductQuantity() {
		return this.productQuantity;
	}

	getIsVisible() {
		return this.isVisible;
	}

	getAGradePrice() {
		return this.aGradePrice;
	}

	getBGradePrice() {
		return this.bGradePrice;
	}

	getCGradePrice() {
		return this.cGradePrice;
	}

	getDGradePrice() {
		return this.dGradePrice;
	}

	/**
	 *
	 * @param {boolean} isVisible
	 */
	setIsVisible(isVisible) {
		if (typeof isVisible == 'boolean') {
			this.isVisible = isVisible;
		}
	}

	setAGradePrice(newPrice) {
		this.aGradePrice = parseInt(newPrice) || 0;
		this.highPrice = this.calculateHighPrice();
	}

	setBGradePrice(newPrice) {
		this.bGradePrice = parseInt(newPrice);
	}

	setCGradePrice(newPrice) {
		this.cGradePrice = parseInt(newPrice);
	}

	setDGradePrice(newPrice) {
		this.dGradePrice = parseInt(newPrice) || 0;
		this.minimumPrice = this.calculateMinimumPrice();
	}

	getHighPrice() {
		return this.highPrice;
	}

	getMinimumPrice() {
		return this.minimumPrice;
	}

	calculateHighPrice() {
		return this.getAGradePrice() * this.getProductQuantity();
	}

	calculateMinimumPrice() {
		return this.getDGradePrice() * this.getProductQuantity();
	}

	getSaveableFieldsAsObject() {
		const toSave = {
			zohoId: this.getProductZohoId(),
			fields: {
				aGradePrice: this.getAGradePrice(),
				bGradePrice: this.getBGradePrice(),
				cGradePrice: this.getCGradePrice(),
				dGradePrice: this.getDGradePrice()
			}
		};
		return toSave;
	}
}
