CONTROLLER_BASE_URL = "admin_controller.php";


const channels = {};

const fetchedYears = [];

const regionPermissions = new Set();

const ttsLegacyRegionIdentifiers = ['west', 'north', 'south'];
const ttsRegionIdentifiers = [];
const ecommChannelIdentifiers = ['amazon', 'backmarket', 'ebayAuction', 'ebayMarket', 'newegg', 'others'];
const compositeChannels = ['tts', 'sp'];
const wholesaleChannels = ['wholesale', 'localWholesale'];
const TODAY = new Date();
const currentYear = TODAY.getFullYear();
const currentMonthString = (TODAY.getMonth() + 1 < 10) ? '0' + (TODAY.getMonth()+1).toString() : (TODAY.getMonth()+1).toString();
const currentDayString = (TODAY.getDate() < 10) ? '0' + (TODAY.getDate()).toString() : (TODAY.getDate()).toString();
let otherYear = currentYear-1;
let projectedSales = 0;



init();

async function init() {
	setLoadingModalVisible(false);
	getYearData(currentYear, 'current');
	// getYearData(currentYear-1, 'other');
	await fetch(`${CONTROLLER_BASE_URL}?m=metrics_get_projected_sales`)
	.then(response => response.json())
	.then(data => {
		projectedSales = data['projectedSales'];
		renderProjectedSales();
	});
	await fetch(`${CONTROLLER_BASE_URL}?m=metrics_get_mtd_comparisons&year=${currentYear}&month=${currentMonthString}&day=${currentDayString}&otherYear=${otherYear}`)
	.then(response => response.json())
	.then(data => {
		renderYearComparisonSpans(data);
	});
	fetch(`${CONTROLLER_BASE_URL}?m=metrics_get_legacy_data`)
	.then(response => {
		return response.json();
	})
	.then(data => {
		processLegacyData(data);
	});
}

function renderYearComparisonSpans(data) {

	// MTD calculations
	const otherYearMTDSpTotal = parseFloat(data['otherYearMTDSpTotal']);
	const otherYearMTDTtsTotal = parseFloat(data['otherYearMTDTtsTotal']);
	const thisYearMTDSpTotal = parseFloat(data['thisYearMTDSpTotal']);
	const thisYearMTDTtsTotal = parseFloat(data['thisYearMTDTtsTotal']);
	const otherYearMTDTotal = otherYearMTDSpTotal + otherYearMTDTtsTotal;
	const thisYearMTDTotal = thisYearMTDSpTotal + thisYearMTDTtsTotal;

	const spMTDPercentageDifference = (thisYearMTDSpTotal / otherYearMTDSpTotal) * 100;
	const ttsMTDPercentageDifference = (thisYearMTDTtsTotal / otherYearMTDTtsTotal) * 100;
	const totalMTDPercentageDifference = (thisYearMTDTotal / otherYearMTDTotal) * 100;

	const spMTDDisplayPercentage = (spMTDPercentageDifference >= 100) ? `+${Math.round(spMTDPercentageDifference - 100)}%` : `-${Math.round(100 - spMTDPercentageDifference)}%`;
	const ttsMTDDisplayPercentage = (ttsMTDPercentageDifference >= 100) ? `+${Math.round(ttsMTDPercentageDifference - 100)}%` : `-${Math.round(100 - ttsMTDPercentageDifference)}%`;
	const totalMTDDisplayPercentage = (totalMTDPercentageDifference >= 100) ? `+${Math.round(totalMTDPercentageDifference - 100)}%` : `-${Math.round(100 - totalMTDPercentageDifference)}%`;

	// YTD calculations
	const otherYearYTDSpTotal = parseFloat(data['otherYearYTDSpTotal']);
	const otherYearYTDTtsTotal = parseFloat(data['otherYearYTDTtsTotal']);
	const thisYearYTDSpTotal = parseFloat(data['thisYearYTDSpTotal']);
	const thisYearYTDTtsTotal = parseFloat(data['thisYearYTDTtsTotal']);
	const otherYearYTDTotal = otherYearYTDSpTotal + otherYearYTDTtsTotal;
	const thisYearYTDTotal = thisYearYTDSpTotal + thisYearYTDTtsTotal;

	const spYTDPercentageDifference = (thisYearYTDSpTotal / otherYearYTDSpTotal) * 100;
	const ttsYTDPercentageDifference = (thisYearYTDTtsTotal / otherYearYTDTtsTotal) * 100;
	const totalYTDPercentageDifference = (thisYearYTDTotal / otherYearYTDTotal) * 100;

	const spYTDDisplayPercentage = (spYTDPercentageDifference >= 100) ? `+${Math.round(spYTDPercentageDifference - 100)}%` : `-${Math.round(100 - spYTDPercentageDifference)}%`;
	const ttsYTDDisplayPercentage = (ttsYTDPercentageDifference >= 100) ? `+${Math.round(ttsYTDPercentageDifference - 100)}%` : `-${Math.round(100 - ttsYTDPercentageDifference)}%`;
	const totalYTDDisplayPercentage = (totalYTDPercentageDifference >= 100) ? `+${Math.round(totalYTDPercentageDifference - 100)}%` : `-${Math.round(100 - totalYTDPercentageDifference)}%`;

	/**
	 * @type {HTMLDivElement}
	 */
	const yearComparisonGroup = document.getElementById('yearComparisonHeader');
	/**
	 * @type {HTMLCollectionOf<HTMLSpanElement>}
	 */
	const otherYearDisplaySpans = document.getElementsByClassName('otherYearNumber');
	/**
	 * @type {HTMLCollectionOf<HTMLSpanElement>}
	 */
	const thisYearDisplaySpans = document.getElementsByClassName('thisYearNumber');

	// MTD elements
	/**
	 * @type {HTMLSpanElement}
	 */
	const otherYearSPMTDToNow = document.getElementById('otherYearSPMTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const thisYearSPMTDToNow = document.getElementById('thisYearSPMTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const otherYearTTSMTDToNow = document.getElementById('otherYearTTSMTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const thisYearTTSMTDToNow = document.getElementById('thisYearTTSMTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const otherYearTotalMTDToNow = document.getElementById('otherYearTotalMTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const thisYearTotalMTDToNow = document.getElementById('thisYearTotalMTDToNow');

	// YTD elements
	/**
	 * @type {HTMLSpanElement}
	 */
	const otherYearSPYTDToNow = document.getElementById('otherYearSPYTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const thisYearSPYTDToNow = document.getElementById('thisYearSPYTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const otherYearTTSYTDToNow = document.getElementById('otherYearTTSYTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const thisYearTTSYTDToNow = document.getElementById('thisYearTTSYTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const otherYearTotalYTDToNow = document.getElementById('otherYearTotalYTDToNow');
	/**
	 * @type {HTMLSpanElement}
	 */
	const thisYearTotalYTDToNow = document.getElementById('thisYearTotalYTDToNow');

	yearComparisonGroup.hidden = true;
	for (const element of otherYearDisplaySpans) {
		element.innerText = otherYear;
	}
	for (const element of thisYearDisplaySpans) {
		element.innerText = currentYear
	}
	otherYearSPMTDToNow.innerText = otherYearMTDSpTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'});
	otherYearTTSMTDToNow.innerText = otherYearMTDTtsTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'});

	thisYearSPMTDToNow.innerText = `${thisYearMTDSpTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})} (${spMTDDisplayPercentage})`;
	thisYearTTSMTDToNow.innerText = `${thisYearMTDTtsTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})} (${ttsMTDDisplayPercentage})`;

	otherYearTotalMTDToNow.innerText = otherYearMTDTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'});
	thisYearTotalMTDToNow.innerText = `${thisYearMTDTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})} (${totalMTDDisplayPercentage})`;

	otherYearSPYTDToNow.innerText = otherYearYTDSpTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'});
	otherYearTTSYTDToNow.innerText = otherYearYTDTtsTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'});

	thisYearSPYTDToNow.innerText = `${thisYearYTDSpTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})} (${spYTDDisplayPercentage})`;
	thisYearTTSYTDToNow.innerText = `${thisYearYTDTtsTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})} (${ttsYTDDisplayPercentage})`;

	otherYearTotalYTDToNow.innerText = otherYearYTDTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'});
	thisYearTotalYTDToNow.innerText = `${thisYearYTDTotal.toLocaleString('en-US', {style: 'currency', currency: 'USD'})} (${totalYTDDisplayPercentage})`;

	yearComparisonGroup.hidden = false;
}

/**
 * Fetches data from database for a given year and returns via ajax request
 * @param {number} year The year for which to get the data
 * @param {string} yearType Whether is current or other year
 */
function getYearData(year, yearType) {
	const url = `${CONTROLLER_BASE_URL}?m=metrics_get_year_data&year=${year}`;
	setLoadingModalVisible(true);
	makeAjaxRequest(url, '', 'POST', returnReply);

	function returnReply() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					try {
						ttsRegionIdentifiers.length = 0;
						const data = JSON.parse(http_request.response);
						console.log(data);
						const channelData = data['channels'];
						const permissionsData = data['regionPermissions'];
						for (const permission of permissionsData) {
							if (!regionPermissions.has(permission)) {
								regionPermissions.add(permission);
							}
						}
						for (const channelName in channelData) {
							if (channelName == "regions") {
								for (const regionIdentifier in channelData[channelName]) {
									ttsRegionIdentifiers.push(regionIdentifier);
									if (!channels[regionIdentifier]) {
										channels[regionIdentifier] = new Channel(channelData[channelName][regionIdentifier]);
									}
									else {
										/**
										 * @type {Channel}
										 */
										const existingChannelData = channels[regionIdentifier];
										existingChannelData.addData(channelData[channelName][regionIdentifier]);
									}
								}
							}
							else {
								if (!channels[channelName]) {
									channels[channelName] = new Channel(channelData[channelName]);
								}
								else {
									/**
									 * @type {Channel}
									 */
									const existingChannelData = channels[channelName];
									existingChannelData.addData(channelData[channelName]);
								}
							}
						}
						fetchedYears.push(year);
						renderTableBody(year, yearType);
						if (yearType == 'current') {
							otherYear = year-1;
							getYearData(otherYear, 'other');
							renderTotals();
						}
					}
					catch (err) {
						console.error(err);
						try {
							console.log(JSON.parse(http_request.response));
						}
						catch (err) {
							console.log(http_request.response);
						}
					}
					setLoadingModalVisible(false);
					break;
				default:
					alert(`Error with AJAX request. Request status: ${http_request.status}\nRequest response: ${http_request.response}`);
					setLoadingModalVisible(false);
			}
			return true;
		}
	}
}

/**
 *
 * @param {number} year Year to render. To be converted to string
 * @param {string} yearType Whether it is the current or the other year
 */
function renderTableBody(year, yearType) {
	renderYearTable(year.toString(), yearType);
	/**
	 *
	 * @param {string} year
	 * @param {string} yearType Current or other year
	 */
	function renderYearTable(year, yearType) {
		let even = true;
		const table = document.getElementById(`${yearType}YearTable`);
		const title = document.getElementById(`${yearType}YearTitle`);
		title.innerText = year;
		table.hidden = true;
		const tableBody = document.getElementById(`${yearType}YearTableBody`);
		tableBody.innerHTML = '';
		const totalSalesRow = generateTotalSalesRow(year);
		totalSalesRow.classList.add((even) ? 'even' : 'odd');
		even = !even;
		tableBody.appendChild(totalSalesRow);
		for (const compositeChannel of compositeChannels) {
			/**
			 * @type {Channel}
			 */
			const channelData = channels[compositeChannel];
			const newRow = channelData.generateChannelRow(year)
			newRow.classList.add((even) ? 'even' : 'odd');
			even = !even;
			tableBody.appendChild(newRow);
		}
		// tableBody.appendChild(generateTtsSalesRow(year));
		if (parseInt(year) >= 2020) {
			for (const region of ttsRegionIdentifiers) {
				const isPermittedRegion = regionPermissions.has(region);
				/**
				 * @type {Channel}
				 */
				const channelData = channels[region];
				const newRow = channelData.generateChannelRow(year, isPermittedRegion);
				newRow.classList.add((even) ? 'even' : 'odd');
				even = !even;
				tableBody.appendChild(newRow);
			}
		}
		else {
			for (const region of ttsLegacyRegionIdentifiers) {
				const isPermittedRegion = regionPermissions.has(region);
				/**
				 * @type {Channel}
				 */
				const channelData = channels[region];
				const newRow = channelData.generateChannelRow(year, isPermittedRegion);
				newRow.classList.add((even) ? 'even' : 'odd');
				even = !even;
				tableBody.appendChild(newRow);
			}
		}
		for (const channelIdentifier of ecommChannelIdentifiers) {
			/**
			 * @type {Channel}
			 */
			const channelData = channels[channelIdentifier];
			const newRow = channelData.generateChannelRow(year)
			newRow.classList.add((even) ? 'even' : 'odd');
			even = !even;
			tableBody.appendChild(newRow);
		}
		for (const channelIdentifier of wholesaleChannels) {
			/**
			 * @type {Channel}
			 */
			const channelData = channels[channelIdentifier];
			const newRow = channelData.generateChannelRow(year)
			newRow.classList.add((even) ? 'even' : 'odd');
			even = !even;
			tableBody.appendChild(newRow);
		}
		table.hidden = false;
	}
	/**
	 *
	 * @param {string} year
	 */
	function generateTotalSalesRow(year) {
		const row = document.createElement('tr');
		const rowHead = document.createElement('th');
		row.appendChild(rowHead);
		row.classList.add('padding-y-10');
		rowHead.innerText = 'Total Sales';
		for (let i = 0; i < 12; i++) {
			const monthCell = document.createElement('td');
			row.appendChild(monthCell);
			monthCell.innerText = getMonthTotal(year, i).toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0});
		}
		for (let i = 0; i < 4; i++) {
			const quarter = i+1;
			const quarterCell = document.createElement('td');
			row.appendChild(quarterCell);
			quarterCell.innerText = getQuarterTotal(year, quarter).toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0});
		}
		const yearTotalCell = document.createElement('td');
		row.appendChild(yearTotalCell);
		yearTotalCell.innerText = getYearTotal(year).toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0});



		return row;

		/**
		 *
		 * @param {string} year
		 * @param {number} monthIndex
		 */
		function getMonthTotal(year, monthIndex) {
			const totalCalcChannels = ['tts', 'sp']
			let total = 0.0;
			for (const channel of totalCalcChannels) {
				/**
				 * @type {Channel}
				 */
				const channelData = channels[channel];
				try {
					total += channelData.getMonthTotal(year, monthIndex);

				}
				catch(err) {
					console.error(err);
					console.log(channel, channelData);
				}
			}
			return total;
		}

		/**
		 *
		 * @param {string} year Year for which to get data
		 * @param {number} quarter Which quarter
		 */
		function getQuarterTotal(year, quarter) {
			const totalCalcChannels = ['tts', 'sp']
			let total = 0.0;
			for (const channel of totalCalcChannels) {
				/**
				 * @type {Channel}
				 */
				const channelData = channels[channel];
				total += channelData.getQuarterTotal(year, quarter);
			}
			return total;
		}

		function getYearTotal(year) {
			const totalCalcChannels = ['tts', 'sp']
			let total = 0.0;
			for (const channel of totalCalcChannels) {
				/**
				 * @type {Channel}
				 */
				const channelData = channels[channel];
				total += channelData.getYearTotal(year);
			}
			return total;
		}
	}

}

function renderTotals() {
	const today = new Date();
	const currentMonthIndex = today.getMonth();
	const totalYearValue = getYearTotalValue(currentYear);
	const totalMonthValue = getMonthTotal(currentYear, currentMonthIndex);
	const totalSalesCurrentYearSpan = document.getElementById('totalSalesCurrentYear');
	const totalSalesCurrentMonthSpan = document.getElementById('totalSalesCurrentMonth');
	const projectedSalesDisplay = document.getElementById('projectedSalesCurrentMonth');
	totalSalesCurrentYearSpan.innerText = totalYearValue.toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0});
	totalSalesCurrentMonthSpan.innerText = totalMonthValue.toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0});
	const projectedSalesTotal = projectedSales + totalMonthValue;
	projectedSalesDisplay.innerText = projectedSalesTotal.toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0});

	/**
	 *
	 * @param {string} year
	 */
	function getYearTotalValue(year) {
		const totalCalcChannels = ['tts', 'sp']
		let total = 0.0;
		for (const channel of totalCalcChannels) {
			/**
			 * @type {Channel}
			 */
			const channelData = channels[channel];
			try {
				total += channelData.getYearTotal(year);
			}
			catch (err) {
				console.error(err);
				console.log(`failed to load: ${year} ${channel}`);
			}
		}
		return total;
	}

	/**
	 *
	 * @param {string} year
	 * @param {number} monthIndex
	 */
	function getMonthTotal(year, monthIndex) {
		const totalCalcChannels = ['tts', 'sp']
		let total = 0.0;
		for (const channel of totalCalcChannels) {
			/**
			 * @type {Channel}
			 */
			const channelData = channels[channel];
			try {
				total += channelData.getMonthTotal(year, monthIndex);

			}
			catch(err) {
				console.error(err);
				console.log(channel, channelData);
			}
		}
		return total;
	}
}

function renderProjectedSales() {
	renderTotals();
}

async function getPreviousYearData() {
	const nextYearButton = document.getElementById('nextYearButton');
	nextYearButton.disabled = false;
	otherYear -= 1;
	if (fetchedYears.includes(otherYear)) {
		renderTableBody(otherYear, 'other');
	}
	else {
		getYearData(otherYear, 'other');
	}
	const returnedData = await fetch(`${CONTROLLER_BASE_URL}?m=metrics_get_mtd_comparisons&year=${currentYear}&month=${currentMonthString}&day=${currentDayString}&otherYear=${otherYear}`)
		.then(response => response.text())
		.then(data => { return data });

	try {
		const parsedData = JSON.parse(returnedData);
		renderYearComparisonSpans(parsedData);
	}
	catch (err) {
		console.error(err);
		console.log(returnedData);
	}
	// .then(data => {
	// 	renderYearComparisonSpans(data);
	// });
}

async function getNextYearData() {
	const nextYearButton = document.getElementById('nextYearButton');
	nextYearButton.disabled = false;
	otherYear += 1;
	if (otherYear >= currentYear - 1) {
		nextYearButton.disabled = true;
	}
	if (fetchedYears.includes(otherYear)) {
		renderTableBody(otherYear, 'other');
	}
	else {
		getYearData(otherYear, 'other');
	}
	const returnedData = await fetch(`${CONTROLLER_BASE_URL}?m=metrics_get_mtd_comparisons&year=${currentYear}&month=${currentMonthString}&day=${currentDayString}&otherYear=${otherYear}`)
		.then(response => response.text())
		.then(data => { return data });

	try {
		const parsedData = JSON.parse(returnedData);
		renderYearComparisonSpans(parsedData);
	}
	catch (err) {
		console.error(err);
		console.log(returnedData);
	}
	// .then(data => {
	// 	renderYearComparisonSpans(data);
	// });
}

function processLegacyData(data) {
	console.log(data);
	const monthNames = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
	const monthNumbers = ['01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'];
	for (const year in data) {
		const yearData = data[year];
		for (const channelName in yearData) {
			if (channelName != 'TotalSales') {
				const channelData = yearData[channelName];
				const newChannelYearData = {
					year : year,
					months : []
				};

				for (let i = 0; i < channelData.length; i++) {
					const monthSubtotal = channelData[i];
					const constructorData = {
						month : {
							name : monthNames[i],
							number : monthNumbers[i]
						},
						subtotal : monthSubtotal
					};
					newChannelYearData.months.push(constructorData);
				}
				try {
					/**
					 * @type {Channel}
					 */
					const existingChannelData = channels[channelName];
					existingChannelData.addData(newChannelYearData);
				}
				catch (err) {
					console.error(err);
					console.log(channelName);
				}
			}
		}
		fetchedYears.push(parseInt(year));
	}
}

/**
 *
 * @param {string} yearType 'current' or 'other'
 */
function generateCsv(yearType) {
	const yearToExport = (yearType == 'other') ? otherYear.toString() : currentYear.toString();
	const rows = [generateCsvHeaderRow()];
	rows.push(generateTotalSalesRow());
	for (const channelName of compositeChannels) {
		/**
		 * @type {Channel}
		 */
		const channelData = channels[channelName];
		rows.push(channelData.generateCsvRow(yearToExport));
	}
	for (const channelName of ttsRegionIdentifiers) {
		/**
		 * @type {Channel}
		 */
		const channelData = channels[channelName];
		rows.push(channelData.generateCsvRow(yearToExport));
	}
	for (const channelName of ecommChannelIdentifiers) {
		/**
		 * @type {Channel}
		 */
		const channelData = channels[channelName];
		rows.push(channelData.generateCsvRow(yearToExport));
	}
	for (const channelName of wholesaleChannels) {
		/**
		 * @type {Channel}
		 */
		const channelData = channels[channelName];
		rows.push(channelData.generateCsvRow(yearToExport));
	}


	let csvContent = "data:text/csv;charset=utf-8," + rows.map(e => e.join(",")).join("\n");
	const encodedUri = encodeURI(csvContent);
	const link = document.createElement("a");
	link.setAttribute("href", encodedUri);
	link.setAttribute("download", `${yearToExport}_metrics_export_${getTimestamp(new Date())}.csv`);
	document.body.appendChild(link); // Required for FF

	link.click();
	delete link;

	function generateCsvHeaderRow() {
		const headerRow = [
			`"${yearToExport}"`,
			'"Jan"',
			'"Feb"',
			'"Mar"',
			'"Apr"',
			'"May"',
			'"Jun"',
			'"Jul"',
			'"Aug"',
			'"Sep"',
			'"Oct"',
			'"Nov"',
			'"Dec"',
			'"Q1"',
			'"Q2"',
			'"Q3"',
			'"Q4"',
			'"Yearly Total"'
		];
		return headerRow;
	}


	function generateTotalSalesRow(s) {
		const newRow = ['Total Sales'];
		for (let i = 0; i < 12; i++) {
			let monthTotal = 0.0;
			for (const channelName of compositeChannels) {
				/**
				 * @type {Channel}
				 */
				const channelData = channels[channelName];
				monthTotal += channelData.getMonthTotal(yearToExport, i);
			}
			newRow.push(`"${monthTotal.toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0})}"`);
		}
		for (let i = 0; i < 4; i++) {
			const quarter = i+1;
			let quarterTotal = 0.0;
			for (const channelName of compositeChannels) {
				/**
				 * @type {Channel}
				 */
				const channelData = channels[channelName];
				quarterTotal += channelData.getQuarterTotal(yearToExport, quarter);
			}
			newRow.push(`"${quarterTotal.toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0})}"`);
		}
		let yearTotal = 0.0;
		for (const channelName of compositeChannels) {
			/**
			 * @type {Channel}
			 */
			const channelData = channels[channelName];
			yearTotal += channelData.getYearTotal(yearToExport);
		}
		newRow.push(`"${yearTotal.toLocaleString('en-US', {style : 'currency', currency : 'USD', minimumFractionDigits : 0, maximumFractionDigits : 0})}"`);

		return newRow;
	}

	/**
	 *
	 * @param {Date} time
	 */
	function getTimestamp(time) {
		let timestamp = time.getFullYear().toString();
		if (time.getMonth()+1 < 10) {
			timestamp += '0';
		}
		timestamp += (time.getMonth()+1).toString();
		if (time.getDate() < 10) {
			timestamp += '0';
		}
		timestamp += time.getDate().toString();
		if (time.getHours() < 10) {
			timestamp += '0';
		}
		timestamp += time.getHours().toString();
		if (time.getMinutes() < 10) {
			timestamp += '0';
		}
		timestamp += time.getMinutes().toString();
		if (time.getSeconds() < 10) {
			timestamp += '0';
		}
		timestamp += time.getSeconds().toString();

		return timestamp
	}
}
