class YearSummary {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.year = data.year;
		/**
		 * @type {MonthSummary[]}
		 */
		this.months = [];

		for (const month of data.months) {
			this.months.push(new MonthSummary(month));
		}
	}

	getYearTotal() {
		let total = 0.0;
		for (const month of this.months) {
			total += month.getSubtotal();
		}
		return total;
	}

	/**
	 *
	 * @param {number} quarter
	 */
	getQuarterTotal(quarter) {
		const monthIndexStart = quarter * 3 - 3;
		const monthIndexEnd = quarter * 3;
		let total = 0.0;
		for (let i = monthIndexStart; i < monthIndexEnd; i++) {
			try {
				const monthData = this.months[i];
				total += monthData.getSubtotal();
			}
			catch(err) {
				console.error(err);
			}
		}
		return total;
	}

	/**
	 *
	 * @param {number} monthIndex Month index to check
	 */
	getMonthTotal(monthIndex) {
		try {
			const monthData = this.months[monthIndex];
			return monthData.getSubtotal();
		}
		catch(err) {
			console.error(err);
			return 0.0;
		}
	}
}
