const CONTROLLER_BASE_URL = 'admin_controller.php';

const orderNumberId = (window.location.href.indexOf('order_number_id') != -1) ? window.location.href.substring(window.location.href.lastIndexOf('=') + 1) : '';

/**
 * @type {ShippingBox[]}
 */
const shipBoxes = [];
const activeBoxes = [];

const values = {};

let newRowOpen = false;

/**
 * @type {HTMLTableSectionElement}
 */
const shippingBoxRowSection = document.getElementById('shipping_box_rows');

init();

function init() {
	setLoadingModalVisible(true);
	getShippingBoxes();
}

function getShippingBoxes() {
	const url = `${CONTROLLER_BASE_URL}?m=get_shipping_boxes`;

	const poststr = (orderNumberId) ? 'order_number_id=' + orderNumberId : '';
	makeAjaxRequest(url, poststr, 'POST', returnShippingBoxes);

	function returnShippingBoxes() {
		if (http_request.readyState == 4) {
			switch(http_request.status) {
				case 200:
					try {
						const data = JSON.parse(http_request.response);
						if (typeof data == "object") {
							for (const box of data['box_types']) {
								shipBoxes.push(new ShippingBox(box));
							}
						}
						for (const box of data['active_boxes']) {
							activeBoxes.push(box);
						}
						shippingBoxRowSection.innerHTML = '';
						let i = 0;
						for(const activeBox of activeBoxes) {
							shippingBoxRowSection.innerHTML += `
								<tr>
									<td>
										<select class="ship_box_type_select borderless" name="shipping_box_type[${i}]" box_index="${i}" title="Select Box Type">
											<option disabled selected value=''>Select</option>
										</select>
									</td>
									<td><input id="ship_box_devices_without_case[${i}]" name="ship_box_devices_without_case[${i}]" class="borderless" placeholder="Enter Quantity" value="${activeBox['devices_per_box_without_case']}" type="number" min="1"/></td>
									<td><input id="ship_box_devices_with_case[${i}]" name="ship_box_devices_with_case[${i}]" class="borderless" placeholder="Enter Quantity" value="${activeBox['devices_per_box_with_case']}" type="number" min="1"/></td>
									<td><button onclick='deleteShipBox(${i})'>Delete</button></td>
								</tr>`;
							i++;
						}
						/**
						 * @type {HTMLCollectionOf<HTMLSelectElement>}
						 */
						const shippingBoxSelects = document.getElementsByClassName('ship_box_type_select');
						for (const select of shippingBoxSelects) {
							for (const box of shipBoxes) {
								select.innerHTML += box.getSelectOption(parseInt(activeBoxes[parseInt(select.getAttribute('box_index'))]['id']));
							}
						}
					}
					catch (e) {
						console.warn(e);
					}
					// initListenersAndValues();
					setLoadingModalVisible(false);
					return true;
				default:
					setLoadingModalVisible(false);
					alert('Error with AJAX request. Check network connectivity and try again. HTTP request status: ' + http_request.status);
					return false;
			}
		}
	}
}

function addNewBox() {
	if (!newRowOpen) {
		newRowOpen = true;
		const i = activeBoxes.length;
		shippingBoxRowSection.innerHTML += `
			<tr>
				<td>
					<select class="ship_box_type_select borderless" id="shipping_box_type[${i}]" name="shipping_box_type[${i}]" box_index="${i}" title="Select Box Type">
						<option disabled selected value=''>Select</option>
					</select>
				</td>
				<td><input id="ship_box_devices_without_case[${i}]" name="ship_box_devices_without_case[${i}]" class="borderless" placeholder="Enter Quantity" value="" type="number" min="1"/></td>
				<td><input id="ship_box_devices_with_case[${i}]" name="ship_box_devices_with_case[${i}]" class="borderless" placeholder="Enter Quantity" value="" type="number" min="1"/></td>
				<td><button onclick='submit()'>Save</button></td>
			</tr>`;
		const newSelect = document.getElementById(`shipping_box_type[${i}]`);
		for (const box of shipBoxes) {
			newSelect.innerHTML += box.getSelectOption();
		}
	}
	return false;
}

async function submit() {
	setLoadingModalVisible(true);
	const values = {};
	/**
	 * @type {HTMLCollectionOf<HTMLInputElement>}
	 */
	const inputs = document.getElementsByTagName('input');
	const isValid = await validate();
	if (!isValid) {
		return false;
	}
	for (const input of inputs) {
		const name = input.name;
		if (input.getAttribute('category') && input.getAttribute('category') == 'ecomm_integration') {
			const category = input.getAttribute('category'), channel = input.getAttribute('channel'), column = input.getAttribute('column'), condition = input.getAttribute('condition'), value = input.value;
			if (value && value != '') {
				if (!values[category]) {
					values[category] = {};
				}
				if (!values[category][channel]) {
					values[category][channel] = {};
				}
				if (!values[category][channel][condition]) {
					values[category][channel][condition] = {};
				}
				(input.type != 'checkbox' || (input.type == 'checkbox' && input.checked)) ? values[category][channel][condition][column] = value : null;
			}
		}
		else if ((input.type != 'checkbox' && input.type != 'radio')) {
			if (name.indexOf('[') == -1) {
				values[name] = encodeURI(input.value);
			} else {
				const tempName = name.substring(0, name.indexOf('['));
				const index = parseInt(name.substring(name.indexOf('[') + 1, name.indexOf(']')));
				if (!values[tempName]) {
					values[tempName] = {};
				}
				values[tempName][index] = input.value;
			}
		} else if (input.type == 'checkbox') {
			const tempName = name.substring(0, name.indexOf('['));
			const index = parseInt(name.substring(name.indexOf('[') + 1, name.indexOf(']')));
			if (!values[tempName]) {
				values[tempName] = {};
			}
			if (input.checked) {
				values[tempName][index] = input.value;
			}
		}
	}
	/**
	 * @type {HTMLCollectionOf<HTMLSelectElement>}
	 */
	const selects = document.getElementsByTagName('select');
	for (const select of selects) {
		const name = select.name;
		if (name.indexOf('[') == -1) {
			values[name] = select.value;
		} else {
			const tempName = name.substring(0, name.indexOf('['));
			const index = parseInt(name.substring(name.indexOf('[') + 1, name.indexOf(']')));
			if (!values[tempName]) {
				values[tempName] = {};
			}
			values[tempName][index] = select.value;
		}
	}
	const url = `${CONTROLLER_BASE_URL}?m=submit_order_number`;
	let poststr = 'order_number_id=' + orderNumberId;
	for (const key in values) {
		poststr += `&${key}=${encodeURI(values[key])}`;
	}

	console.log(values);
	console.log(JSON.stringify(values));

	makeAjaxRequest(url, 'data=' + JSON.stringify(values), 'POST', returnSaveResults);

}

function deleteShipBox(index) {
	// delete values['shipping_box_type'][index];
	// delete values['ship_box_devices_with_case'][index];
	// delete values['ship_box_devices_without_case'][index];
	console.log(index);
	console.log(`deleting`, activeBoxes[index]);
	const url = `${CONTROLLER_BASE_URL}?m=delete_sku_ship_box`;
	const poststr = `ship_box_id=${activeBoxes[index]['id']}&order_number_id=${orderNumberId}`;
	makeAjaxRequest(url, poststr, 'POST', returnSaveResults);
}

async function deleteSku() {
	const sku = document.getElementById('order_number').value;
	if (confirm(`Are you SURE you want to delete this order number${(sku) ? ` (${sku})` : ''}? This action cannot be undone.`)) {
		console.log('deleting');
		await fetch(`${CONTROLLER_BASE_URL}?m=machinedb_delete_sku&orderNumberId=${orderNumberId}`);
		window.location.replace(`${CONTROLLER_BASE_URL}?m=machine_database`);
	}
	else {
		return false;
	}
}

function returnSaveResults() {
	if (http_request.readyState == 4) {
		switch(http_request.status) {
			case 200:
				location.reload();
				// console.log(http_request.response);
				setLoadingModalVisible(false);
				return true;
			default:
				setLoadingModalVisible(false);
				alert('Error with AJAX request. Check network connectivity and try again. HTTP request status: ' + http_request.status);
				return false;
		}
	}
}

async function validate(){
	let errormsg = "";
	/**
	 * @type {string}
	 */
	const sku = document.getElementById('order_number').value;
	if (sku.trim() == ""){
		errormsg = "Please enter an order number\n";
	}

	if (document.getElementById("machine_id").selectedIndex == 0){
		errormsg += "Please select a machine";
	}

	const skuDuplicate = await checkSkuUnique(sku);
	if (skuDuplicate) {
		console.log(skuDuplicate);

		errormsg += `SKU already in use (Order number ID: ${skuDuplicate['found']})\n`;
	}

	/**
	 * @type {HTMLInputElement}
	 */
	const configCodeInput = document.getElementById('configCodes');
	const configCodes = [...new Set(configCodeInput.value.trim().split(',').map(el => el.replace(' ', '').trim()).filter(el => el.trim() != ''))].join(','); // Clean up config codes, remove empty and duplicate entries
	configCodeInput.value = configCodes;

	/**
	 * Verifies that each config code is unique, and not in use by another machine.
	 */
	const configCodeDuplicates = await getDuplicateConfigCodes(configCodes);
	if (configCodeDuplicates) {
		for (const code in configCodeDuplicates) {
			/**
			 * @type {string}
			 */
			const duplicateSku = configCodeDuplicates[code];
			errormsg += `Config code ${code} is already in use by ${duplicateSku}.\n`;
		}
	}



	if (errormsg != ""){
		setLoadingModalVisible(false);
		alert(errormsg);
		return false;
	}else{
		return true;
	}
}

/**
 * Queries DB with list of config codes to ensure each entered code is unique and not in use by another machine.
 * @param {string} configCodes Comma-separated string of config codes to be verified for uniqueness
 */
async function getDuplicateConfigCodes(configCodes) {
	const duplicates = await fetch(`${CONTROLLER_BASE_URL}?m=machinedb_validate_unique_configcode&configCodes=${configCodes}&orderNumberId=${(orderNumberId) ? orderNumberId : ''}`)
		.then(response => response.json())
		.then(data => {
			return data;
		}
	);
	return duplicates;
}

/**
 * Validates that the entered SKU is unique
 * @param {string} sku SKU to check
 */
async function checkSkuUnique(sku) {
	const unique = await fetch(`${CONTROLLER_BASE_URL}?m=machinedb_validate_unique_sku&sku=${sku.trim()}&orderNumberId=${(orderNumberId) ? orderNumberId : ''}`)
		.then(response => response.json())
		.then(data => {
			return data;
		}
	);
	return unique;
}
