CONTROLLER_BASE_URL = 'admin_controller.php';
const SORT_ASC_URL = '../svg/sort_asc.svg';
const SORT_DESC_URL = '../svg/sort_desc.svg';
const SORT_NONE_URL = '../svg/sort.svg';
const DEFAULT_SORT = 'machine_description';

const pageElements = {
	/**
	 * @type {HTMLTableElement}
	 */
	table: document.getElementById('locked_item_table'),
	/**
	 * @type {HTMLTableRowElement}
	 */
	head_row: document.getElementById('locked_head_row'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	body: document.getElementById('locked'),
	sort_icons: document.getElementsByClassName('sort_icon')
}

const COLUMN_DEFINITIONS = {
	po_number: new ColumnDefinition('PO Number', 'po_number', {isSortable: true, isFilterable: true, linksTo: 'order_id', linkBase: `${CONTROLLER_BASE_URL}?m=bb_detail&order_id=LINKTO`}),
	account_name: new ColumnDefinition('Account', 'account_name', {isSortable: true, isFilterable: true}),
	total_lock_count: new ColumnDefinition('Total Lock Count', 'total_lock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	activation_lock_count: new ColumnDefinition('Activation Lock Count', 'activation_lock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	mdm_lock_count: new ColumnDefinition('MDM Lock Count', 'mdm_lock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	date_received: new ColumnDefinition('Date Received', 'date_received', {isSortable: true, isFilterable: true, isNumeric: true})
}

const columns = {
	default: [
		COLUMN_DEFINITIONS.po_number,
		COLUMN_DEFINITIONS.account_name,
		COLUMN_DEFINITIONS.total_lock_count,
		COLUMN_DEFINITIONS.activation_lock_count,
		COLUMN_DEFINITIONS.mdm_lock_count,
		COLUMN_DEFINITIONS.date_received,
	]
}

const orderDict = {};

const orderArray = [];

const filter = {};
const sort = {
	order: 1,
	by: ''
};


init();

function init() {
	getItems();
}


function setSort(newSort) {
	if (newSort == sort.by) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	sortItems();
	renderBody();
}

function sortItems() {
	orderArray.sort((a,b) => sortFunction(a,b));

	for (const icon of pageElements.sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}

	function sortFunction(a,b) {
		if(isNaN(a[sort.by])) {
			if(a[sort.by] < b[sort.by]) {
				return -1 * sort.order;
			}
			if(a[sort.by] > b[sort.by]) {
				return 1 * sort.order;
			}
		} else {
			if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
				return -1 * sort.order;
			}
			if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
				return 1 * sort.order;
			}
		}
	}
}

/**
 *
 * @param {HTMLInputElement} input
 */
function filterInput(input) {
	filter[input.getAttribute('filter')] = input.value;
	filterResults();

	function filterResults() {
		renderSection(pageElements.body, orderArray)
	}

	/**
	 *
	 * @param {HTMLTableSectionElement} section Section into which to render the rows
	 * @param {Object[]} array Array of order info
	 */
	function renderSection(section, array) {
		section.innerHTML = '';
		for (const row of array) {
			let valid = true;
			for(const entry in filter) {
				if (filter[entry] == '') {
					delete filter[entry];
				}
				else if (COLUMN_DEFINITIONS[entry] && COLUMN_DEFINITIONS[entry].isNumeric) {
					val = (row[entry]) ? row[entry] : 0;
					valid = filterNumbers(filter[entry], val);
				}
				else if(row[entry] && filter[entry] && !row[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
					valid = false;
				}
			}
			if (valid) {
				section.innerHTML += generateRow(row);
			}
		}
		/**
		 *
		 * @param {string} filterValue Value of the filter
		 * @param {string} inputValue Value of the input
		 */
		function filterNumbers(filterValue, inputValue) {
			const multiplier = inputValue.toString().endsWith('TB') ? 1024 : 1;
			inputValue = parseInt(inputValue) * multiplier;
			let comparator = '';
			if (filterValue.startsWith('>=') || filterValue.startsWith('<=') || filterValue.startsWith('!=')) {
				comparator = filterValue.substring(0, 2);
				filterValue = (isNaN(parseInt(filterValue.substring(2)))) ? 0 : parseInt(filterValue.substring(2));
			} else if (filterValue.startsWith('>') || filterValue.startsWith('<') || filterValue.startsWith('=')) {
				comparator = filterValue.substring(0, 1);
				filterValue = (isNaN(parseInt(filterValue.substring(1)))) ? 0 : parseInt(filterValue.substring(1));
			} else {
				comparator = '=';
			}
			if (comparator == '>=') {
				return (inputValue >= filterValue);
			} else if (comparator == '<=') {
				return (inputValue <= filterValue);
			} else if (comparator == '!=') {
				return (inputValue != filterValue);
			} else if (comparator == '>') {
				return (inputValue > filterValue);
			} else if (comparator == '<') {
				return (inputValue < filterValue);
			} else if (comparator == '=') {
				return (inputValue == filterValue);
			}
			return true;
		}
	}
}

function getItems() {
	setLoadingModalVisible(true);
	const url = `${CONTROLLER_BASE_URL}?m=get_inventory_items`;
	makeAjaxRequest(url, `page=locked_inventory`, "POST", returnItems);
	function returnItems() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const data = JSON.parse(http_request.response);
					for (const order of data['orders']) {
						order['activation_lock_count'] = parseInt(order['activation_lock_count']);
						order['mdm_lock_count'] = parseInt(order['mdm_lock_count']);
						order['total_lock_count'] = order['activation_lock_count'] + order['mdm_lock_count'];
						order['date_received'] = (order['date_received']) ? order['date_received'] : '0000-00-00';
						orderDict[order['order_id']] = order;
						orderArray.push(order);
					}
					renderHeader();
					renderBody();
					pageElements.table.hidden = false;
					setLoadingModalVisible(false);
					break;
				default:
					alert('Error with AJAX request.');
			}
		}
	}
}

function renderHeader() {
	buildHeaderRow(pageElements.head_row, columns.default);
	/**
	 *
	 * @param {HTMLTableRowElement} headRow
	 * @param {ColumnDefinition[]} headerArray
	 */
	function buildHeaderRow(headRow, headerArray) {
		for (const header of headerArray) {
			headRow.innerHTML += header.buildHeader();
		}
		headRow.innerHTML += `<th><button type='button' onclick='exportAllLockedItems()'>Export All Locked Items</button></th>`;
	}
}

function renderBody() {
	pageElements.body.innerHTML = '';
	for (const order of orderArray) {
		pageElements.body.innerHTML += generateRow(order);
	}
}

function exportAllLockedItems() {
	setLoadingModalVisible(true);
	const url = `${CONTROLLER_BASE_URL}?m=locked_inventory_export`;
	makeAjaxRequest(url, ``, "POST", returnItems);
	function returnItems() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					console.log(http_request);
					const now = new Date();
					const dateTimeString = `${now.getFullYear()}${now.getMonth()+1}${now.getDate()}${now.getHours()}${now.getMinutes()}${now.getSeconds()}`;
					const rows = http_request.response.split('\n');
					let csv = '';
					for (const row of rows) {
						csv += row;
						csv += '\n';
					}
					const hiddenElement = document.createElement('a');
					hiddenElement.href = 'data:text/csv;charset=utf-8,' + encodeURI(csv);
					hiddenElement.target = '_blank';
					hiddenElement.download = `${dateTimeString}_all_locked_devices.csv`;
					hiddenElement.click();
					delete hiddenElement;
					setLoadingModalVisible(false);
					break;
				default:
					alert('Error with AJAX request.');
			}
		}
	}
}

function exportLockedItems(poNumber) {
	if (poNumber == 'modal') {
		poNumber = modalData.poNumber;
	}
	setLoadingModalVisible(true);
	const url = `${CONTROLLER_BASE_URL}?m=locked_inventory_export`;
	makeAjaxRequest(url, `poNumber=${poNumber}`, "POST", returnItems);
	function returnItems() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					console.log(http_request);
					const rows = http_request.response.split('\n');
					let csv = '';
					for (const row of rows) {
						csv += row;
						csv += '\n';
					}
					const hiddenElement = document.createElement('a');
					hiddenElement.href = 'data:text/csv;charset=utf-8,' + encodeURI(csv);
					hiddenElement.target = '_blank';
					hiddenElement.download = `${poNumber}_locked_devices.csv`;
					hiddenElement.click();
					delete hiddenElement;
					setLoadingModalVisible(false);
					break;
				default:
					alert('Error with AJAX request.');
			}
		}
	}
}

function generateRow(rowData, type="default") {
	if (!columns[type]) {
		type = "default";
	}

	const columnDefs = columns[type];
	let newRow = "<tr>";
	for (const columnDef of columnDefs) {
		newRow += generateCell(columnDef, rowData);
	}
	newRow += `<td><button type='button' onclick='exportLockedItems("${rowData['po_number']}")'>Export MDM/Activation Locked Items</button></td>`
	newRow += "</tr>";
	return newRow;


	/**
	 *
	 * @param {ColumnDefinition} column
	 * @param {*} data
	 */
	function generateCell(column, data) {
		const isCountColumn = (column.identifier.indexOf('_count') > -1);
		// const content = (data[column.identifier] || data[column.identifier] === 0) ? `${column.prefix}${data[column.identifier]}` : `No Data`;
		const content = generateContent();
		if (isCountColumn) {
			const getCountType = () => {
				if (column.identifier.indexOf('activation') > -1) {
					return 'activation';
				}
				else if (column.identifier.indexOf('mdm') > -1) {
					return 'mdm';
				}
				else {
					return 'all';
				}
			}
			const countType = getCountType();
			return (parseInt(data['total_lock_count']) > 0) ? `<td><button class="link large" type="button" onclick="getAssetData('${data['po_number']}','${countType}')"><span>${data[column.identifier]}</span></button></td>` : '';
		}
		const inner = (column.linkBase != '' && data[column.identifier]) ? `<a href="${column.linkBase.replace('LINKTO', data['order_id'])}" target="_blank">${content}</a>` : content;
		return `<td>${inner}</td>`;

		function generateContent() {
			const datePattern = /^\d{4}-\d{2}-\d{2}$/;
			if (data[column.identifier] || data[column.identifier] === 0) {
				if (datePattern.test(data[column.identifier])) {
					return new Date(`${data[column.identifier]}T17:00:00`).toLocaleDateString();
				}
				else {
					return `${column.prefix}${data[column.identifier]}`;
				}
			} else {
				return 'No Data';
			}
		}
	}
}
