/**
 * @type {HTMLDivElement}
 */
const assetModal = document.getElementById('asset_modal');
let changed = false;
const modalData = {
	requestedAssetData: [],
	filter: {},
	sortBy: "oNum",
	sortOrder: 1,
	currentPage: 1,
	itemsPerPage: 50,
	maxPages: 0,
	poNumber: ''
}

window.onclick = function(event) {
	if (event.target == assetModal) {
		closeAssetModal();
	}
}

function closeAssetModal() {
	const content = document.getElementById('asset_modal_content');
	const serialList = document.getElementById('serials');
	assetModal.classList.remove('active');
	content.innerHTML = '';
	serialList.innerHTML = '';
	modalData.currentPage = 1;
	modalData.requestedAssetData.length = 0;
	if (changed) {
		getItems();
	}
}

function buildPageControls() {
	const pageControls = document.getElementById('pages');
	pageControls.innerHTML = "";
	pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.max(modalData.currentPage - 1, 1)})" pnum="prev" class="select-page-button">&laquo;</li>`;
	for (let i = 1; i <= modalData.maxPages; i++) {
		if (i == modalData.currentPage) {
			pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button active">${i}</li>`;
		} else {
			pageControls.innerHTML += `<li onclick="setCurrentPage(${i})" pnum="${i}" class="select-page-button">${i}</li>`;
		}
	}
	pageControls.innerHTML += `<li onclick="setCurrentPage(${Math.min(modalData.currentPage + 1, modalData.maxPages)})" pnum="next" class="select-page-button">&raquo;</li>`;
}

function populateModalData(rebuildPageControls=false) {
	const content = document.getElementById('asset_modal_content');
	if (rebuildPageControls) {
		buildPageControls();
	}
	content.innerHTML = "";
	for (let i = modalData.itemsPerPage * (modalData.currentPage - 1); i < modalData.requestedAssetData.length && i < modalData.itemsPerPage * modalData.currentPage; i++) {
		const row = modalData.requestedAssetData[i];
		let newRow = "<tr>"
		newRow += `<td><a href="${CONTROLLER_BASE_URL}?m=order_detail&oNum=${row['oNum']}" target="_blank">${row['oNum']}</a></td>`;
		newRow += `<td>${row['serialNumber']}</td>`;
		newRow += `<td>${row['grade']}</td>`;
		newRow += `<td>${new Date(`${row['dateMachineReceived']}T17:00:00`).toLocaleDateString()}</td>`;
		newRow += `<td>${row['cStatus']}</td>`;
		newRow += `<td>${(parseInt(row['activation_lock']) == 1) ? "Yes" : "No"}</td>`;
		newRow += `<td>${(parseInt(row['mdm_lock']) == 1) ? "Yes" : "No"}</td>`;
		newRow += `</tr>`;
		content.innerHTML += newRow;
	}
	setLoadingModalVisible(false);
	if(modalData.requestedAssetData.length > 0) {
		assetModal.classList.add('active');
	}
}


function getAssetData(poNumber, type) {
	setLoadingModalVisible(true);
	const assetModalTitle = document.getElementById('asset_modal_title');
	assetModalTitle.innerHTML = `${poNumber} - `;
	if (type == "all") {
		assetModalTitle.innerHTML += 'Activation/MDM Locked';
	} else if (type == "activation") {
		assetModalTitle.innerHTML += 'Activation Locked';
	} else if (type == "mdm") {
		assetModalTitle.innerHTML += 'MDM Locked';
	}
	const postStr = `poNumber=${poNumber}&type=${type}`;
	const url = `${CONTROLLER_BASE_URL}?m=get_locked_asset_data`;
	makeAjaxRequest(url, postStr, "POST", returnAssetData);
	function returnAssetData() {
		if (http_request.readyState == 4) {
			switch (http_request.status) {
				case 200:
					const serialList = document.getElementById('serials');
					// console.log(http_request.response);
					const data = JSON.parse(http_request.response);
					// console.log(data);
					modalData.poNumber = poNumber;
					if (data) {
						for (const datum of data) {
							modalData.requestedAssetData.push(datum);
							serialList.innerHTML += `${datum['serialNumber']}\n`;
						}
					}
					if (data.length > 0) {
						updateMaxPages();
						populateModalData(true);
					} else {
						setLoadingModalVisible(false);
					}
					break;
				default:
					alert('Error with AJAX request.');
			}
		}
	}
}


function updateMaxPages() {
	modalData.maxPages = Math.ceil(modalData.requestedAssetData.length / modalData.itemsPerPage);
	if (modalData.currentPage > modalData.maxPages) {
		modalData.currentPage = modalData.maxPages;
	}
}


function setItemsPerPage(num) {
	/**
	 * @type {HTMLCollectionOf<HTMLButtonElement>}
	 */
	const itemsPerPageButtons = document.getElementsByClassName('items-per-page-selection');
	for (const button of itemsPerPageButtons) {
		if (parseInt(button.getAttribute('itemnum')) == num) {
			button.classList.add('active');
			button.disabled = true;
		} else {
			button.classList.remove('active');
			button.disabled = false;
		}
	}
	modalData.itemsPerPage = num;
	updateMaxPages();
	populateModalData(true);
}

function setCurrentPage(num) {
	/**
	 * @type {HTMLCollectionOf<HTMLLIElement}
	 */
	const pageSelectButtons = document.getElementsByClassName('page-select-button');
	modalData.currentPage = num;

	populateModalData(true);
}

function copyAllSerialsToClipboard() {
	/**
	 * @type {HTMLTextAreaElement}
	 */
	const serialList = document.getElementById('serials');
	const el = document.createElement('textarea');
	el.value = serialList.value;
	el.setAttribute('readonly', '');
	el.style.position = 'absolute';
	el.style.left = '-9999px';
	document.body.appendChild(el);
	el.select();
	document.execCommand('copy');
	document.body.removeChild(el);
}
