const getModuleAndView = () => {
	let page = window.location.href.substring(window.location.href.indexOf('m=')+2);
	let view = '';
	if (page.indexOf(`&v=`) != -1) {
		view = page.substring(page.indexOf(`&v=`) + 3);
		page = page.substring(0, page.indexOf(`&v=`));
	}
	return [page, view];
}
const [page, view] = getModuleAndView();
const CONTROLLER_BASE_URL = 'admin_controller.php';
const SORT_ASC_URL = '../svg/sort_asc.svg';
const SORT_DESC_URL = '../svg/sort_desc.svg';
const SORT_NONE_URL = '../svg/sort.svg';
const DEFAULT_SORT = 'machine_description';
const ICON_PATH_BASE = '/img/icons';
const ICON_PATHS = {
	amazon : `${ICON_PATH_BASE}/amazon.png`,
	backmarket : `${ICON_PATH_BASE}/backmarket.png`,
	ebay : `${ICON_PATH_BASE}/ebay.png`,
	newegg : `${ICON_PATH_BASE}/newegg.png`,
}
/**
 * @type {HTMLTableSectionElement}
 */
const instock_items_section = document.getElementById('instock_items');
/**
 * @type {HTMLTableSectionElement}
 */
const instock_ipads_section = document.getElementById('instock_ipads');
/**
 * @type {HTMLTableSectionElement}
 */
const instock_imacs_section = document.getElementById('instock_imacs');
/**
 * @type {HTMLTableSectionElement}
 */
const instock_macbooks_section = document.getElementById('instock_macbooks');
/**
 * @type {HTMLTableSectionElement}
 */
const instock_chromebooks_section = document.getElementById('instock_chromebooks');
/**
 * @type {HTMLTableSectionElement}
 */
const instock_others_section = document.getElementById('instock_others');


const sections = {
	in_stock: {
		/**
		 * @type {HTMLTableSectionElement}
		 */
		all: document.getElementById('instock_items'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		ipad: document.getElementById('instock_ipads'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		imac: document.getElementById('instock_imacs'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		macbook: document.getElementById('instock_macbooks'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		chromebook: document.getElementById('instock_chromebooks'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		other: document.getElementById('instock_others'),
	},
	out_of_stock: {
		/**
		 * @type {HTMLTableSectionElement}
		 */
		all: document.getElementById('out_of_stock_items'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		ipad: document.getElementById('out_of_stock_ipads'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		imac: document.getElementById('out_of_stock_imacs'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		macbook: document.getElementById('out_of_stock_macbooks'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		chromebook: document.getElementById('out_of_stock_chromebooks'),
		/**
		 * @type {HTMLTableSectionElement}
		 */
		other: document.getElementById('out_of_stock_others'),
	}
}



/**
 * @type {HTMLTableSectionElement}
 */
const out_of_stock_items_section = document.getElementById('out_of_stock_items');
/**
 * @type {HTMLCollectionOf<HTMLImageElement>}
 */
const sort_icons = document.getElementsByClassName('sort_icon');


/**
 * @type {HTMLDivElement}
 */
const loadingModal = document.getElementById('loading_modal');

const titles = {
	in_stock: {
		/**
		 * @type {HTMLHeadingElement}
		 */
		ipad: document.getElementById('instock_ipad_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		macbook: document.getElementById('instock_macbook_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		imac: document.getElementById('instock_imac_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		chromebook: document.getElementById('instock_chromebook_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		other: document.getElementById('instock_other_title'),
	},
	out_of_stock: {
		/**
		 * @type {HTMLHeadingElement}
		 */
		ipad: document.getElementById('out_of_stock_ipad_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		macbook: document.getElementById('out_of_stock_macbook_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		imac: document.getElementById('out_of_stock_imac_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		chromebook: document.getElementById('out_of_stock_chromebook_title'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		other: document.getElementById('out_of_stock_other_title'),
	}
};

const headers = {
	in_stock: {
		/**
		 * @type {HTMLHeadingElement}
		 */
		ipad: document.getElementById('instock_ipad_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		macbook: document.getElementById('instock_macbook_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		imac: document.getElementById('instock_imac_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		chromebook: document.getElementById('instock_chromebook_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		other: document.getElementById('instock_other_head'),
	},
	out_of_stock: {
		/**
		 * @type {HTMLHeadingElement}
		 */
		ipad: document.getElementById('out_of_stock_ipad_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		macbook: document.getElementById('out_of_stock_macbook_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		imac: document.getElementById('out_of_stock_imac_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		chromebook: document.getElementById('out_of_stock_chromebook_head'),
		/**
		 * @type {HTMLHeadingElement}
		 */
		other: document.getElementById('out_of_stock_other_head'),
	}
}
const itemDict = {};
const items = {
	in_stock: {
		all: [],
		ipad: [],
		imac: [],
		macbook: [],
		chromebook: [],
		other: []
	},
	out_of_stock: {
		all: [],
		ipad: [],
		imac: [],
		macbook: [],
		chromebook: [],
		other: []
	}
}

const validItems = {
	in_stock: {
		all: [],
		ipad: [],
		imac: [],
		macbook: [],
		chromebook: [],
		other: []
	},
	out_of_stock: {
		all: [],
		ipad: [],
		imac: [],
		macbook: [],
		chromebook: [],
		other: []
	}
}


const filter = {};
const sort = {
	order: 1,
	by: ''
}

let isFirstLoad = true;
let showAll = true;

const columnDefinitions = {
	asset: new ColumnDefinition('SKU', 'asset', {isSortable: true, isFilterable: true}),
	machine_description: new ColumnDefinition('Description', 'machine_description', {isSortable: true, isFilterable: true}),
	ram: new ColumnDefinition('RAM', 'ram', {isNumeric: true, isFilterable: true, isSortable: true}),
	storage: new ColumnDefinition('Storage', 'storage', {isNumeric: true, isFilterable: true, isSortable: true}),
	processor: new ColumnDefinition('Processor', 'processor', {isSortable: true, isFilterable: true}),
	processor_speed: new ColumnDefinition('Processor Speed', 'processor_speed', {isSortable: true, isFilterable: true}),
	item_count: new ColumnDefinition('Total Available', 'item_count', {isNumeric: true, isFilterable: true, isSortable: true}),
	first_stock_count: new ColumnDefinition('First Stock', 'first_stock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	second_stock_count: new ColumnDefinition('Second Stock', 'second_stock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	first_stock_pricing: new ColumnDefinition('Pricing (First Stock)', 'first_stock_pricing', {isNumeric: true, isSortable: true, isFilterable: true, prefix: '$'}),
	second_stock_pricing: new ColumnDefinition('Pricing (Second Stock)', 'second_stock_pricing', {isNumeric: true, isSortable: true, isFilterable: true, prefix: '$'}),
	first_stock_ten_pack_pricing: new ColumnDefinition('10-Pack Pricing (First Stock)', 'first_stock_ten_pack_pricing', {isNumeric: true, isSortable: false, isFilterable: true, prefix: '$'}),
	second_stock_ten_pack_pricing: new ColumnDefinition('10-Pack Pricing (Second Stock)', 'second_stock_ten_pack_pricing', {isNumeric: true, isSortable: false, isFilterable: true, prefix: '$'}),
	first_stock_ten_pack_discount: new ColumnDefinition('10-Pack Discount (First Stock)', 'first_stock_ten_pack_discount', {isNumeric: true, isSortable: false, isFilterable: true, prefix: '$'}),
	second_stock_ten_pack_discount: new ColumnDefinition('10-Pack Discount (Second Stock)', 'second_stock_ten_pack_discount', {isNumeric: true, isSortable: false, isFilterable: true, prefix: '$'}),
	latest_os: new ColumnDefinition('Latest OS', 'latest_os'),
	auto_update_expiration: new ColumnDefinition('AUE', 'auto_update_expiration'),
	upgradeable: new ColumnDefinition('Upgradeable', 'upgradeable'),
	notes: new ColumnDefinition('Notes', 'notes'),
	color: new ColumnDefinition('Color', 'color'),
	activation_lock_count: new ColumnDefinition('Activation Locked', 'activation_lock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	mdm_lock_count: new ColumnDefinition('MDM Locked', 'mdm_lock_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	poNumber: new ColumnDefinition('PO Number', 'poNumber', {isSortable: true, isFilterable: true}),
	item_count_less_demand: new ColumnDefinition('Total Available', 'item_count_less_demand', {isNumeric: true, isFilterable: true, isSortable: true}),
	first_stock_count_less_demand: new ColumnDefinition('First Stock', 'first_stock_count_less_demand', {isSortable: true, isFilterable: true, isNumeric: true}),
	second_stock_count_less_demand: new ColumnDefinition('Second Stock', 'second_stock_count_less_demand', {isSortable: true, isFilterable: true, isNumeric: true}),
	average_cost: new ColumnDefinition('Average Cost', 'average_cost', {isSortable: true, isFilterable: true, isNumeric: true, prefix: '$'}),
	renewed_count: new ColumnDefinition('Renewed', 'renewed_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	certified_count: new ColumnDefinition('Certified Refurbished', 'certified_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	scratchdent_count: new ColumnDefinition('Scratch & Dent', 'scratchdent_count', {isSortable: true, isFilterable: true, isNumeric: true}),
	renewed_price: new ColumnDefinition('Pricing (Renewed)', 'renewed_price', {isSortable: true, isFilterable: true, isNumeric: true, prefix: '$'}),
	certified_price: new ColumnDefinition('Pricing (Certified)', 'certified_price', {isSortable: true, isFilterable: true, isNumeric: true, prefix: '$'}),
	scratchdent_price: new ColumnDefinition('Pricing (S & D)', 'scratchdent_price', {isSortable: true, isFilterable: true, isNumeric: true, prefix: '$'}),
	device_condition: new ColumnDefinition('Condition', 'device_condition'),
	touchscreen: new ColumnDefinition('Touchscreen', 'touchscreen')
}

const columns = {
	inventory: {
		default: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count_less_demand,
			columnDefinitions.first_stock_count_less_demand,
			columnDefinitions.second_stock_count_less_demand,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.first_stock_ten_pack_pricing,
			columnDefinitions.second_stock_ten_pack_pricing,
			columnDefinitions.first_stock_ten_pack_discount,
			columnDefinitions.second_stock_ten_pack_discount,
			columnDefinitions.latest_os,
			columnDefinitions.notes
		],
		ipad: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.storage,
			columnDefinitions.item_count_less_demand,
			columnDefinitions.first_stock_count_less_demand,
			columnDefinitions.second_stock_count_less_demand,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.first_stock_ten_pack_pricing,
			columnDefinitions.second_stock_ten_pack_pricing,
			columnDefinitions.first_stock_ten_pack_discount,
			columnDefinitions.second_stock_ten_pack_discount,
			columnDefinitions.processor,
			columnDefinitions.latest_os,
			columnDefinitions.color
		],
		imac: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count_less_demand,
			columnDefinitions.first_stock_count_less_demand,
			columnDefinitions.second_stock_count_less_demand,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.first_stock_ten_pack_pricing,
			columnDefinitions.second_stock_ten_pack_pricing,
			columnDefinitions.first_stock_ten_pack_discount,
			columnDefinitions.second_stock_ten_pack_discount,
			columnDefinitions.latest_os,
		],
		macbook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count_less_demand,
			columnDefinitions.first_stock_count_less_demand,
			columnDefinitions.second_stock_count_less_demand,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.first_stock_ten_pack_pricing,
			columnDefinitions.second_stock_ten_pack_pricing,
			columnDefinitions.first_stock_ten_pack_discount,
			columnDefinitions.second_stock_ten_pack_discount,
			columnDefinitions.latest_os,
		],
		chromebook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.device_condition,
			columnDefinitions.touchscreen,
			columnDefinitions.item_count_less_demand,
			columnDefinitions.first_stock_count_less_demand,
			columnDefinitions.second_stock_count_less_demand,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.first_stock_ten_pack_pricing,
			columnDefinitions.second_stock_ten_pack_pricing,
			columnDefinitions.first_stock_ten_pack_discount,
			columnDefinitions.second_stock_ten_pack_discount,
			columnDefinitions.auto_update_expiration,
		],
	},
	repair_queue: {
		default: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
			columnDefinitions.notes
		],
		ipad: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.storage,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.processor,
			columnDefinitions.latest_os,
			columnDefinitions.color
		],
		imac: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
		],
		macbook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
		],
		chromebook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.auto_update_expiration,
		],
	},
	locked_inventory: {
		default: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.activation_lock_count,
			columnDefinitions.mdm_lock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.latest_os,
			columnDefinitions.notes
		],
		ipad: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.storage,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.activation_lock_count,
			columnDefinitions.mdm_lock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.processor,
			columnDefinitions.latest_os,
			columnDefinitions.color
		],
		imac: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.mdm_lock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.latest_os,
		],
		macbook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.mdm_lock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.latest_os,
		],
		chromebook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.mdm_lock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.auto_update_expiration,
		],
	},
	picked_ecomm: {
		default: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor_speed,
			columnDefinitions.renewed_count,
			columnDefinitions.certified_count,
			columnDefinitions.scratchdent_count,
			columnDefinitions.renewed_price,
			columnDefinitions.certified_price,
			columnDefinitions.scratchdent_price,
		],
		ipad: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.storage,
			columnDefinitions.renewed_count,
			columnDefinitions.certified_count,
			columnDefinitions.scratchdent_count,
			columnDefinitions.renewed_price,
			columnDefinitions.certified_price,
			columnDefinitions.scratchdent_price,
		],
		imac: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor_speed,
			columnDefinitions.renewed_count,
			columnDefinitions.certified_count,
			columnDefinitions.scratchdent_count,
			columnDefinitions.renewed_price,
			columnDefinitions.certified_price,
			columnDefinitions.scratchdent_price,
		],
		macbook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor_speed,
			columnDefinitions.renewed_count,
			columnDefinitions.certified_count,
			columnDefinitions.scratchdent_count,
			columnDefinitions.renewed_price,
			columnDefinitions.certified_price,
			columnDefinitions.scratchdent_price,
		],
		chromebook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor_speed,
			columnDefinitions.renewed_count,
			columnDefinitions.certified_count,
			columnDefinitions.scratchdent_count,
			columnDefinitions.renewed_price,
			columnDefinitions.certified_price,
			columnDefinitions.scratchdent_price,
		],
	},
	picked_wholesale: {
		default: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
			columnDefinitions.notes
		],
		ipad: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.storage,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.processor,
			columnDefinitions.latest_os,
			columnDefinitions.color
		],
		imac: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
		],
		macbook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
		],
		chromebook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.auto_update_expiration,
		],
	},
	picked_ebay_auction: {
		default: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
			columnDefinitions.notes
		],
		ipad: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.storage,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.processor,
			columnDefinitions.latest_os,
			columnDefinitions.color
		],
		imac: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
		],
		macbook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.latest_os,
		],
		chromebook: [
			columnDefinitions.asset,
			columnDefinitions.machine_description,
			columnDefinitions.ram,
			columnDefinitions.storage,
			columnDefinitions.processor,
			columnDefinitions.processor_speed,
			columnDefinitions.item_count,
			columnDefinitions.first_stock_count,
			columnDefinitions.second_stock_count,
			columnDefinitions.first_stock_pricing,
			columnDefinitions.second_stock_pricing,
			columnDefinitions.average_cost,
			columnDefinitions.auto_update_expiration,
		],
	}
}


init();



function init() {
	if(page != 'inventory') {
		document.getElementById('exportButton').hidden = true;
		document.getElementById('in_stock_title').hidden = true;
		document.getElementById('out_of_stock_title').hidden = true;
	}
	else {
		renderShowAllToggle();
	}
	getItems();
}

function getItems() {
	setLoadingModalVisible(true);
	const url = `${CONTROLLER_BASE_URL}?m=get_inventory_items`;
	const poststr = (view != '') ? `page=${page}&view=${view}` : `page=${page}`;
	makeAjaxRequest(url, poststr, "POST", returnItems);
}

function returnItems() {
	if (http_request.readyState == 4) {
		switch (http_request.status) {
			case 200:
				for (const stockType in items) {
					for (const itemType in items[stockType]) {
						items[stockType][itemType].length = 0;
					}
				}
				const data = JSON.parse(http_request.response);
				console.log(data);
				if (data['items']) {
					const receivedItems = data['items'];
					for(const row of receivedItems) {
						processRowData(row);
					}
					if (data['average_costs']) {
						parseAverageCosts(data['average_costs']['averages']);
					}
					if (data['average_ecomm_prices']) {
						parseAverageEcommPrices(data['average_ecomm_prices']);
					}
					if (data['active_ecomm_channels']) {
						parseActiveEcommChannels(data['active_ecomm_channels']);
					}
					if (data['demand']) {
						parseDemand(data['demand']);
					}
					if (data['inbound']) {
						parseInbound(data['inbound']);
					}
				}
				renderHeaders();
				setSort(DEFAULT_SORT, isFirstLoad);
				isFirstLoad = false;
				break;
			default:
				alert('Error with AJAX request.');
		}
	}
}

function renderHeaders() {
	for (const stockType in items) {
		for (const itemType in items[stockType]) {
			if (items[stockType][itemType] && items[stockType][itemType].length > 0) {
				const columnDef = (columns[page][itemType]) ? columns[page][itemType] : columns[page].default;
				buildHeaderRow(document.getElementById(`${stockType}_${itemType}_head_row`), columnDef, (stockType == 'in_stock'));
			}
		}
	}
	/**
	 *
	 * @param {HTMLTableRowElement} headRow
	 * @param {ColumnDefinition[]} headerArray
	 */
	function buildHeaderRow(headRow, headerArray, showQuantities=true) {
		headRow.innerHTML = '';
		for (const header of headerArray) {
			if (header.identifier.includes('_count')) {
				if (showQuantities) {
					headRow.innerHTML += header.buildHeader();
				}
			}
			else {
				headRow.innerHTML += header.buildHeader();
			}
		}
	}
}

function renderTables(refreshSort=false) {
	if (refreshSort) sortItems();
	filterResults();
	setLoadingModalVisible(false);
}

function sortItems() {
	for (const stockType in items) {
		for (const itemType in items[stockType]) {
			items[stockType][itemType].sort((a,b) => sortFunction(a,b));
		}
	}
	for (const icon of sort_icons) {
		if (icon.parentElement.getAttribute('sort_order') != sort.by) {
			icon.src = SORT_NONE_URL;
		} else {
			if (sort.order == 1) {
				icon.src = SORT_ASC_URL;
			} else if (sort.order == -1) {
				icon.src = SORT_DESC_URL;
			}
		}
	}
}

function sortFunction(a,b) {
	if (sort.by == 'storage' && a[sort.by] && b[sort.by]) {
		return compareStorage(a[sort.by], b[sort.by]);
	}
	if(isNaN(a[sort.by])) {
		if(a[sort.by] < b[sort.by]) {
			return -1 * sort.order;
		}
		if(a[sort.by] > b[sort.by]) {
			return 1 * sort.order;
		}
	} else {
		if(parseInt(a[sort.by]) < parseInt(b[sort.by])) {
			return -1 * sort.order;
		}
		if(parseInt(a[sort.by]) > parseInt(b[sort.by])) {
			return 1 * sort.order;
		}
	}
	/**
	 *
	 * @param {string} first First storage value to compare
	 * @param {string} second Second storage value to compare
	 */
	function compareStorage(first, second) {
		firstMult = (first.endsWith('TB')) ? 1024 : 1;
		secondMult = (second.endsWith('TB')) ? 1024 : 1;
		firstVal = parseInt(first.substring(0,Math.max(first.indexOf('GB'), first.indexOf('TB'))).trim()) * firstMult;
		secondVal = parseInt(second.substring(0,Math.max(second.indexOf('GB'), second.indexOf('TB'))).trim()) * secondMult;
		if (firstVal > secondVal) {
			return 1 * sort.order;
		}
		if (firstVal < secondVal) {
			return -1 * sort.order;
		}
	}
}



function setSort(newSort, invertOrder=true) {
	if (newSort == sort.by && invertOrder) {
		sort.order *= -1;
	} else {
		sort.by = newSort;
	}
	renderTables(true);
}

/**
 *
 * @param {HTMLInputElement} input
 */
function filterInput(input) {
	filter[input.getAttribute('filter')] = input.value;
	const sameNameInputs = document.getElementsByClassName(input.getAttribute('filter') + '_filter');
	for(const elem of sameNameInputs) {
		elem.value = input.value;
	}
	filterResults();
}

function filterResults() {
	clearValidItems();
	for (const type in items.in_stock) {
		if (items.in_stock[type] && items.in_stock[type].length > 0) {
			for (const item of items.in_stock[type]) {
				let valid = true;
				for(const entry in filter) {
					if (filter[entry] == '') {
						delete filter[entry];
					}
					else if (columnDefinitions[entry] && columnDefinitions[entry].isNumeric) {
						val = (item[entry]) ? item[entry] : 0;
						valid = filterNumbers(filter[entry], val);
					}
					else if(item[entry] && filter[entry] && !item[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
						valid = false;
					}
				}
				if (page == 'inventory' && !showAll) {
					if (item['tts_active'] != "1") {
						valid = false;
					}
				}
				if (valid) {
					validItems.in_stock[type].push(item);
				}
			}
			renderSection(sections.in_stock[type], validItems.in_stock[type], type);
			if (type != 'all') {
				headers.in_stock[type].hidden = false;
				sections.in_stock[type].hidden = false;
				titles.in_stock[type].hidden = false;
			}
		}
	}
	if (page == 'inventory') {
		for (const type in items.out_of_stock) {
			if (items.out_of_stock[type] && items.out_of_stock[type].length > 0) {
				for (const item of items.out_of_stock[type]) {
					let valid = true;
					for(const entry in filter) {
						if (filter[entry] == '') {
							delete filter[entry];
						}
						else if (columnDefinitions[entry] && columnDefinitions[entry].isNumeric) {
							val = (item[entry]) ? item[entry] : 0;
							valid = filterNumbers(filter[entry], val);
						}
						else if(item[entry] && filter[entry] && !item[entry].toString().toLowerCase().includes(filter[entry].toLowerCase())) {
							valid = false;
						}
					}
					if (valid) {
						validItems.out_of_stock[type].push(item);
					}
				}
				renderSection(sections.out_of_stock[type], validItems.out_of_stock[type], type);
				if (type != 'all') {
					headers.out_of_stock[type].hidden = false;
					sections.out_of_stock[type].hidden = false;
					titles.out_of_stock[type].hidden = false;
				}
			}
		}
	}
	/**
	 *
	 * @param {string} filterValue Value of the filter
	 * @param {string} inputValue Value of the input
	 */
	function filterNumbers(filterValue, inputValue) {
		const multiplier = inputValue.toString().endsWith('TB') ? 1024 : 1;
		inputValue = parseInt(inputValue) * multiplier;
		let comparator = '';
		if (filterValue.startsWith('>=') || filterValue.startsWith('<=') || filterValue.startsWith('!=')) {
			comparator = filterValue.substring(0, 2);
			filterValue = (isNaN(parseInt(filterValue.substring(2)))) ? 0 : parseInt(filterValue.substring(2));
		} else if (filterValue.startsWith('>') || filterValue.startsWith('<') || filterValue.startsWith('=')) {
			comparator = filterValue.substring(0, 1);
			filterValue = (isNaN(parseInt(filterValue.substring(1)))) ? 0 : parseInt(filterValue.substring(1));
		} else {
			comparator = '=';
		}
		if (comparator == '>=') {
			return (inputValue >= filterValue);
		} else if (comparator == '<=') {
			return (inputValue <= filterValue);
		} else if (comparator == '!=') {
			return (inputValue != filterValue);
		} else if (comparator == '>') {
			return (inputValue > filterValue);
		} else if (comparator == '<') {
			return (inputValue < filterValue);
		} else if (comparator == '=') {
			return (inputValue == filterValue);
		}
		return true;
	}

	function clearValidItems() {
		for (const stockStatus in validItems) {
			for (const type in validItems[stockStatus]) {
				validItems[stockStatus][type].length = 0;
			}
		}
	}
}

/**
 *
 * @param {HTMLTableSectionElement} section Section into which to render the rows
 * @param {Object[]} array Array of object info
 * @param {string} type The type of item (eg. ipad, imac, macbook, chromebook, default)
 */
function renderSection(section, array, type) {
	section.innerHTML = '';
	for (const row of array) {
		let valid = true;
		if (row['tts_active'] != '1' && !showAll) {
			valid = false;
		}
		if (valid) {
			const countToCheck = (page == 'inventory') ? 'item_count_less_demand' : 'item_count';
			section.innerHTML += addRow(row, type);
			if (row['limited_to_inventory'] && row['limited_to_inventory'] == 1) {
				section.lastElementChild.classList.add('limited-to-inventory');
			}
			else if (row[countToCheck] && row[countToCheck] < 0) {
				section.lastElementChild.classList.add('negative-stock');
			}
			else if (row[countToCheck] && row[countToCheck] > 0 && row[countToCheck] <= 10) {
				section.lastElementChild.classList.add('low-stock');
			} else if (row[countToCheck] && row[countToCheck] > 10) {
				section.lastElementChild.classList.add('high-stock');
			}
		}
	}
}

function addRow(rowData, type="default") {
	if (!columns[page][type]) {
		type="default"; // If there is no specially defined column structure for a given type, revert to default.
	}
	/**
	 * @type {ColumnDefinition[]}
	 */
	const columnDefinitions = columns[page][type];
	let newRow = "<tr>";
	for (const column of columnDefinitions) {
		newRow += getColumnCell(column, rowData);
	}
	newRow += '</tr>';
	return newRow;

	/**
	 *
	 * @param {ColumnDefinition} columnDefinition
	 * @param {*} data
	 */
	function getColumnCell(columnDefinition, data) {
		const booleanColumns = ['touchscreen'];
		const specialConfigPattern = /-\d+\/\d+/;
		const isAssetColumn = (columnDefinition.identifier == 'asset');
		const isDescriptionColumn = (columnDefinition.identifier == 'machine_description');
		const isCountColumn = (columnDefinition.identifier.indexOf('_count') > -1);
		const isBooleanColumn = (booleanColumns.includes(columnDefinition.identifier));
		if (isAssetColumn) {
			const displayAsset = (data['asset'] && specialConfigPattern.test(data['asset'])) ? data['asset'].substring(0, data['asset'].indexOf('-')) : data['asset'];
			return `<td><a href="${CONTROLLER_BASE_URL}?m=order_number_edit&order_number_id=${data['order_number_id']}" target="_blank">${displayAsset}</a></td>`;
		} else if (isDescriptionColumn) {
			return `<td><a href="${CONTROLLER_BASE_URL}?m=machine_detail&machine_id=${data['machine_id']}" target="_blank">${data['machine_description']}</a></td>`;
		} else if (isCountColumn) {
			const getCountType = () => {
				if (columnDefinition.identifier.indexOf('first') > -1) {
					return 'first';
				}
				else if (columnDefinition.identifier.indexOf('second') > -1) {
					return 'second';
				}
				else if (columnDefinition.identifier.indexOf('engraved') > -1) {
					return 'engraved';
				}
				else if (columnDefinition.identifier.indexOf('activation') > -1) {
					return 'activation';
				}
				else if (columnDefinition.identifier.indexOf('mdm') > -1) {
					return 'mdm';
				}
				else if (columnDefinition.identifier.indexOf('renewed') > -1) {
					return 'renewed';
				}
				else if (columnDefinition.identifier.indexOf('certified') > -1) {
					return 'certified';
				}
				else if (columnDefinition.identifier.indexOf('scratchdent') > -1) {
					return 'scratchdent';
				}
				else {
					return 'all';
				}
			}
			const countType = getCountType();
			const hasStock = (parseInt(data['item_count']) > 0);
			let iconRow = '';
			if (page == 'picked_ecomm') {
				if (data['channels'] && data['channels'][countType]) {
					if (data['channels'][countType]['amazon'] && data['channels'][countType]['amazon'] == 1) {
						iconRow += `<img style="width:18px; display: inline-block; vertical-align: middle; margin-left: 2px;" src=${ICON_PATHS.amazon} />`;
					}
					if (data['channels'][countType]['backmarket'] && data['channels'][countType]['backmarket'] == 1) {
						iconRow += `<img style="width:18px; display: inline-block; vertical-align: middle; margin-left: 2px;" src=${ICON_PATHS.backmarket} />`;
					}
					if (data['channels'][countType]['ebay'] && data['channels'][countType]['ebay'] == 1) {
						iconRow += `<img style="width:18px; display: inline-block; vertical-align: middle; margin-left: 2px;" src=${ICON_PATHS.ebay} />`;
					}
					if (data['channels'][countType]['newegg'] && data['channels'][countType]['newegg'] == 1) {
						iconRow += `<img style="width:18px; display: inline-block; vertical-align: middle; margin-left: 2px;" src=${ICON_PATHS.newegg} />`;
					}
				}
			}
			const numDisplay = (hasStock) ? `<td><button class="link large" type="button" onclick="getAssetData('${data['asset']}', '${countType}')"><span style="vertical-align: middle; ${(iconRow) ? 'margin-right: 5px;' : ''}">${data[columnDefinition.identifier]}</span></button>${iconRow}</td>` : `<td><span style="vertical-align: middle; ${(iconRow) ? 'margin-right: 5px;' : ''}" class="large">${data[columnDefinition.identifier]}</span>${iconRow}</td>`
			return (shouldDisplayNum(data)) ? numDisplay : '';
		}
		else if (isBooleanColumn) {
			if (data[columnDefinition.identifier] == '1' || data[columnDefinition.identifier] == 1 || data[columnDefinition.identifier] == 'true' ||data[columnDefinition.identifier] == true) {
				return `<td>Yes</td>`;
			}
			else {
				return `<td>No</td>`;
			}
		}
		else {
			return (data[columnDefinition.identifier]) ? `<td>${columnDefinition.prefix}${data[columnDefinition.identifier]}</td>` : `<td>N/A</td>`;
		}
	}

	function shouldDisplayNum(data) {
		if (parseInt(data['item_count']) > 0) {
			return true;
		}
		else if (page == 'inventory' && (parseInt(data['item_count']) != parseInt(data['item_count_less_demand']))) {
			return true;
		}
		else if (page != 'inventory' && parseInt(data['itemCount']) > 0) {
			return true;
		}
		else {
			return false;
		}
	}
}


function setLoadingModalVisible(visible) {
	if (visible) {
		loadingModal.classList.add('active');
	} else {
		loadingModal.classList.remove('active');
	}
}

function processRowData(row) {
	const ipadPattern = /^ipad/;
	const imacPattern = /^imac/;
	const macbookPattern = /^macbook/;
	const chromebookPattern = /chromebook/;
	const machineDescription = (row['machine_description']) ? row['machine_description'].toLowerCase().trim() : null;
	row['processor'] = (row['mon_processor']) ? row['mon_processor'] : (row['ml_processor']) ? row['ml_processor'] : "";
	row['processor_speed'] = (row['mon_processor_speed']) ? row['mon_processor_speed'] : (row['ml_processor_speed']) ? row['ml_processor_speed'] : "";
	row['first_stock_count'] = parseInt(row['a_grade_count']) + parseInt(row['b_grade_count']);
	row['second_stock_count'] = parseInt(row['c_grade_count']);
	if (page == 'picked_ecomm') {
		row['item_count'] = parseInt(row['renewed_count']) + parseInt(row['certified_count']) + parseInt(row['scratchdent_count']);
		row['renewed_count'] = parseInt(row['renewed_count']);
		row['certified_count'] = parseInt(row['certified_count']);
		row['scratchdent_count'] = parseInt(row['scratchdent_count']);
	} else {
		row['item_count'] = parseInt(row['a_grade_count']) + parseInt(row['b_grade_count']) + parseInt(row['c_grade_count']);
	}
	const demand = {
		all: parseInt(row['first_stock_demand']) + parseInt(row['second_stock_demand']),
		first: parseInt(row['first_stock_demand']),
		second: parseInt(row['second_stock_demand']),
	}
	row['item_count_less_demand'] = row['item_count'] - demand.all;
	row['first_stock_count_less_demand'] = row['first_stock_count'] - demand.first;
	row['second_stock_count_less_demand'] = row['second_stock_count'] - demand.second;
	row['item_count_less_demand'] += row['inbound'];
	if (row['activation_lock_count']) {row['activation_lock_count'] = parseInt(row['activation_lock_count']);}
	if (row['mdm_lock_count']) {row['mdm_lock_count'] = parseInt(row['mdm_lock_count']);}
	if(row['asset']) {
		const assetNum = row['asset'];
		const assetId = row['order_number_id'];
		itemDict[assetId] = row;
		if (itemDict[assetId]['limited_to_inventory'] && itemDict[assetId]['limited_to_inventory'] == 1) {
			itemDict[assetId]['notes'] = (itemDict[assetId]['notes']) ? itemDict[assetId]['notes'] + ". Limited to inventory on hand." : "Limited to inventory on hand";
		}
		if (itemDict[assetId]['first_stock_pricing'] && itemDict[assetId]['first_stock_ten_pack_pricing']) {
			itemDict[assetId]['first_stock_ten_pack_discount'] = parseInt(itemDict[assetId]['first_stock_pricing']) - (parseInt(itemDict[assetId]['first_stock_ten_pack_pricing']) / 10);
		}
		if (itemDict[assetId]['second_stock_pricing'] && itemDict[assetId]['second_stock_ten_pack_pricing']) {
			itemDict[assetId]['second_stock_ten_pack_discount'] = parseInt(itemDict[assetId]['second_stock_pricing']) - (parseInt(itemDict[assetId]['second_stock_ten_pack_pricing']) / 10);
		}
		if (ipadPattern.test(machineDescription)) {
			(hasItemStock(itemDict[assetId], (page=='inventory'))) ? items.in_stock.ipad.push(itemDict[assetId]) : items.out_of_stock.ipad.push(itemDict[assetId]);
		}
		else if (imacPattern.test(machineDescription)) {
			(hasItemStock(itemDict[assetId], (page=='inventory'))) ? items.in_stock.imac.push(itemDict[assetId]) : items.out_of_stock.imac.push(itemDict[assetId]);
		}
		else if (macbookPattern.test(machineDescription)) {
			(hasItemStock(itemDict[assetId], (page=='inventory'))) ? items.in_stock.macbook.push(itemDict[assetId]) : items.out_of_stock.macbook.push(itemDict[assetId]);
		}
		else if (chromebookPattern.test(machineDescription)) {
			(hasItemStock(itemDict[assetId], (page=='inventory'))) ? items.in_stock.chromebook.push(itemDict[assetId]) : items.out_of_stock.chromebook.push(itemDict[assetId]);
		}
		else {
			(hasItemStock(itemDict[assetId], (page=='inventory'))) ? items.in_stock.other.push(itemDict[assetId]) : items.out_of_stock.other.push(itemDict[assetId]);
		}
	}

	function hasItemStock(item, isInventoryPage=true) {
		let inStock = false;
		if (item['item_count'] > 0) {
			inStock = true;
		} else if (isInventoryPage && item['item_count_less_demand'] != item['item_count']) {
			inStock = true;
		}
		return inStock;
	}
}

function parseAverageCosts(avgs) {
	const keyPattern = /^\d{1}$/;
	for (const key in avgs) {
		if (key.match(keyPattern)) {
			delete avgs[key];
		}
		else {
			for(const itemName in itemDict) {
				if (itemDict[itemName]['asset'].includes(key)) {
					itemDict[itemName]['average_cost'] = parseInt(avgs[key]);
				}
			}
		}
	}
}

function parseAverageEcommPrices(avgs) {
	for (const id in avgs) {
		for (const key in avgs[id]) {
			if (itemDict[id]) {
				itemDict[id][key] = parseInt(avgs[id][key]);
			}
		}
	}
}

function parseActiveEcommChannels(channelRecords) {
	for (const id in channelRecords) {
		if(itemDict[id]) {
			itemDict[id]['channels'] = channelRecords[id];
		}
	}
}

function parseDemand(demand) {
	for(const machineOrderId in demand) {
		if (itemDict[machineOrderId]) {
			for (const condition in demand[machineOrderId]) {
				const quantity = parseInt(demand[machineOrderId][condition]['quantity']);
				itemDict[machineOrderId][`${condition}_count`] -= quantity;
			}
		}
	}
}

function parseInbound(inboundItems) {
	for (const inbound of inboundItems) {
		const inboundZohoId = inbound['zohoId'];
		/**
		 * @type {number}
		 */
		const quantity = inbound['quantity'];
		for (const machineOrderId in itemDict) {
			const item = itemDict[machineOrderId];
			const fsIndZohoId = item['first_stock_zoho_id_individual'];
			const fsTenZohoId = item['first_stock_zoho_id_tenpack'];
			const ssIndZohoId = item['second_stock_zoho_id_individual'];
			const ssTenZohoId = item['second_stock_zoho_id_tenpack'];
			if (inboundZohoId == fsIndZohoId || inboundZohoId == ssIndZohoId) {
				if (!itemDict[machineOrderId['inbound']]) {
					itemDict[machineOrderId]['inbound'] = 0;
				}
				itemDict[machineOrderId]['inbound'] += quantity;
				itemDict[machineOrderId]['item_count'] += quantity;
				itemDict[machineOrderId]['item_count_less_demand'] += quantity;
			}
			else if (inboundZohoId == fsTenZohoId || inboundZohoId == ssTenZohoId) {
				if (!itemDict[machineOrderId['inbound']]) {
					itemDict[machineOrderId]['inbound'] = 0;
				}
				itemDict[machineOrderId]['inbound'] += quantity * 10;
				itemDict[machineOrderId]['item_count'] += quantity * 10;
				itemDict[machineOrderId]['item_count_less_demand'] += quantity * 10;
			}
		}
	}
}

function generateCsv() {
	const rows = [];
	// const rows = [generateCsvHeaderRow()];
	if (validItems.in_stock.ipad.length > 0) {
		rows.push(['"iPads"']);
		rows.push(generateCsvHeaderRow('ipad'));
		for (const item of validItems.in_stock.ipad) {
			const fallback = "N/A";
			const sku = (item['asset']) ? item['asset'] : fallback;
			const description = (item['machine_description']) ? item['machine_description'] : fallback;
			const storage = (item['storage']) ? item['storage'] : fallback;
			const processor = (item['processor']) ? item['processor'] : fallback;
			const latestOs = (item['latest_os']) ? item['latest_os'] : fallback;
			const firstStockPricing = (item['first_stock_pricing']) ? parseInt(item['first_stock_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
			const secondStockPricing = (item['second_stock_pricing']) ? parseInt(item['second_stock_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
			const firstStockTenPackPricing = (item['first_stock_ten_pack_pricing']) ? parseInt(item['first_stock_ten_pack_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
			const secondStockTenPackPricing = (item['second_stock_ten_pack_pricing']) ? parseInt(item['second_stock_ten_pack_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
			const newRow = [
				`"${sku}"`,
				`"${description}"`,
				`"${storage}"`,
				`"${firstStockPricing}"`,
				`"${secondStockPricing}"`,
				`"${firstStockTenPackPricing}"`,
				`"${secondStockTenPackPricing}"`,
				`"${processor}"`,
				`"${latestOs}"`,
			];
			rows.push(newRow);
		}
		rows.push(generateEmptyRow());
	}

	if (validItems.in_stock.macbook.length > 0) {
		rows.push(['"MacBooks"']);
		rows.push(generateCsvHeaderRow('macbook'));
		for (const item of validItems.in_stock.macbook) {
			rows.push(generateItemRow(item));
		}
		rows.push(generateEmptyRow());
	}

	if (validItems.in_stock.imac.length > 0) {
		rows.push(['"iMacs"']);
		rows.push(generateCsvHeaderRow('imac'));
		for (const item of validItems.in_stock.imac) {
			rows.push(generateItemRow(item));
		}
		rows.push(generateEmptyRow());
	}

	if (validItems.in_stock.chromebook.length > 0) {
		rows.push(['"Chromebooks"']);
		rows.push(generateCsvHeaderRow('chromebook'));
		for (const item of validItems.in_stock.chromebook) {
			rows.push(generateItemRow(item, 'chromebook'));
		}
		rows.push(generateEmptyRow());
	}

	if (validItems.in_stock.other.length > 0) {
		rows.push(['"Others"']);
		rows.push(generateCsvHeaderRow('other'));
		for (const item of validItems.in_stock.other) {
			rows.push(generateItemRow(item));
		}
	}

	let csvContent = "data:text/csv;charset=utf-8," + rows.map(e => e.join(",")).join("\n");
	const encodedUri = encodeURI(csvContent);
	const link = document.createElement("a");
	link.setAttribute("href", encodedUri);
	link.setAttribute("download", `inventory_export_${getTimestamp(new Date())}.csv`);
	document.body.appendChild(link); // Required for FF

	link.click();
	delete link;

	function generateItemRow(item, type='') {
		const fallback = "N/A";
		const sku = (item['asset']) ? item['asset'] : fallback;
		const description = (item['machine_description']) ? item['machine_description'] : fallback;
		const storage = (item['storage']) ? item['storage'] : fallback;
		const ram = (item['ram']) ? item['ram'] : fallback;
		const processor = (item['processor']) ? item['processor'] : fallback;
		const processorSpeed = (item['processor_speed']) ? item['processor_speed'] : fallback;
		const latestOs = (item['latest_os']) ? item['latest_os'] : fallback;
		const autoUpdateExpiration = (item['auto_update_expiration']) ? item['auto_update_expiration'] : fallback;
		const firstStockPricing = (item['first_stock_pricing']) ? parseInt(item['first_stock_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
		const secondStockPricing = (item['second_stock_pricing']) ? parseInt(item['second_stock_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
		const firstStockTenPackPricing = (item['first_stock_ten_pack_pricing']) ? parseInt(item['first_stock_ten_pack_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
		const secondStockTenPackPricing = (item['second_stock_ten_pack_pricing']) ? parseInt(item['second_stock_ten_pack_pricing']).toLocaleString('en-US', {style: 'currency', currency: 'USD'}) : fallback;
		const newRow = [
			`"${sku}"`,
			`"${description}"`,
			`"${ram}"`,
			`"${storage}"`,
			`"${processor}"`,
			`"${processorSpeed}"`,
			`"${firstStockPricing}"`,
			`"${secondStockPricing}"`,
			`"${firstStockTenPackPricing}"`,
			`"${secondStockTenPackPricing}"`,
			`"${(type == 'chromebook') ? autoUpdateExpiration : latestOs}"`,
		];
		return newRow;
	}

	function generateCsvHeaderRow(type) {
		if (type == 'ipad') {
			return generateCsvIpadHeaderRow();
		}
		else if (type == 'chromebook') {
			return generateChromebookCsvHeaderRow();
		}
		else {
			return generateOthersCsvHeaderRow();
		}

		function generateCsvIpadHeaderRow() {
			const headerRow = [
				'SKU', 'Description', 'Storage', 'Pricing (First)', 'Pricing (Second)', '10-Pack Pricing (First)', '10-Pack Pricing (Second)', 'Processor', 'Latest OS'
			];
			return headerRow;
		}

		function generateChromebookCsvHeaderRow() {
			const headerRow = [
				'SKU', 'Description', 'RAM', 'Storage', 'Processor', 'Processor Speed', 'Pricing (First)', 'Pricing (Second)', '10-Pack Pricing (First)', '10-Pack Pricing (Second)', 'AUE'
			];
			return headerRow;
		}

		function generateOthersCsvHeaderRow() {
			const headerRow = [
				'SKU', 'Description', 'RAM', 'Storage', 'Processor', 'Processor Speed', 'Pricing (First)', 'Pricing (Second)', '10-Pack Pricing (First)', '10-Pack Pricing (Second)', 'Latest OS'
			];
			return headerRow;
		}
	}

	function generateEmptyRow() {
		const emptyRow = [''];
		return emptyRow;
	}

	/**
	 *
	 * @param {Date} time
	 */
	function getTimestamp(time) {
		let timestamp = time.getFullYear().toString();
		if (time.getMonth()+1 < 10) {
			timestamp += '0';
		}
		timestamp += (time.getMonth()+1).toString();
		if (time.getDate() < 10) {
			timestamp += '0';
		}
		timestamp += time.getDate().toString();
		if (time.getHours() < 10) {
			timestamp += '0';
		}
		timestamp += time.getHours().toString();
		if (time.getMinutes() < 10) {
			timestamp += '0';
		}
		timestamp += time.getMinutes().toString();
		if (time.getSeconds() < 10) {
			timestamp += '0';
		}
		timestamp += time.getSeconds().toString();

		return timestamp
	}
}

function renderShowAllToggle() {
	/**
	 * @type {HTMLSpanElement}
	 */
	const containerSpan = document.getElementById('showAllToggleSpan');
	while (containerSpan.firstChild) {
		containerSpan.removeChild(containerSpan.firstChild);
	}
	if (showAll) {
		const showAllSpan = document.createElement('span');
		containerSpan.appendChild(showAllSpan);
		showAllSpan.innerText = "(show all)";
	}
	else {
		const showAllLink = document.createElement('a');
		containerSpan.appendChild(showAllLink);
		showAllLink.href = "javascript:void(0)";
		showAllLink.setAttribute('onclick', 'toggleShowAll()');
		showAllLink.innerText = "(show all)";
	}
	const dividerSpan = document.createElement('span');
	containerSpan.appendChild(dividerSpan);
	dividerSpan.innerText = " | ";
	if (!showAll) {
		const showActiveSpan = document.createElement('span');
		containerSpan.appendChild(showActiveSpan);
		showActiveSpan.innerText = "(show TTS active)";
	}
	else {
		const showActiveLink = document.createElement('a');
		containerSpan.appendChild(showActiveLink);
		showActiveLink.href = "javascript:void(0)";
		showActiveLink.setAttribute('onclick', 'toggleShowAll()');
		showActiveLink.innerText = "(show TTS active)";
	}
}

function toggleShowAll() {
	showAll = !showAll;
	renderShowAllToggle();
	filterResults();
}
