class ZohoContact {
	constructor(data) {
		this.id = (data['id']) ? data['id'] : (data['dbId']) ? data['dbId'] : '';
		this.zohoId = (data['zohoId']) ? data['zohoId'] : (data['zoho_id']) ? data['zoho_id'] : '';

		/**
		 * @type {string}
		 */
		 this.salutation = data['salutation'];
		/**
		 * @type {string}
		 */
		this.firstName = data['firstName'];
		/**
		 * @type {string}
		 */
		this.lastName = data['lastName'];
		/**
		 * @type {string}
		 */
		this.title = data['title'];

		/**
		 * @type {string}
		 */
		this.phoneNumber = data['phoneNumber'];
		/**
		 * @type {string}
		 */
		this.fax = data['fax'];
		/**
		 * @type {string}
		 */
		this.email = data['email'];

		/**
		 * @type {string}
		 */
		 this.leadSource = data['leadSource'];


		this.address = {
			/**
			 * @type {string}
			 */
			street : data['addressStreet'],
			/**
			 * @type {string}
			 */
			city : data['addressCity'],
			/**
			 * @type {string|State}
			 */
			state : data['addressState'] || STATE_DICT[data['stateId']],
			/**
			 * @type {string}
			 */
			code : data['addressCode']
		};

		if (data['account']) {
			this.account = new Account(data['account']);
		}
		else {
			this.account = null;
		}

		/**
		 * @type {boolean}
		 */
		this.emailOptOut = data['emailOptOut'];
	}

	getId() {
		return this.id;
	}

	getZohoId() {
		return this.zohoId;
	}

	getZohoLinkUrl() {
		const urlBase = "https://crm.zoho.com/crm/org26161413/tab/Contacts/";
		return urlBase.concat(this.getZohoId());
	}

	getSalutation() {
		return this.salutation;
	}

	getFirstName() {
		return this.firstName;
	}

	getLastName() {
		return this.lastName;
	}

	getEmail() {
		return this.email;
	}

	getAccount() {
		return this.account;
	}

	getOrganization() {
		if (this.getAccount()) {
			return this.getAccount().getName();
		}
		else {
			return '';
		}
	}

	getTitle() {
		return this.title;
	}

	getPhoneNumber() {
		return this.phoneNumber;
	}

	getFax() {
		return this.fax;
	}

	getLeadSource() {
		return this.leadSource;
	}

	getAddressStreet() {
		return this.address.street;
	}

	getAddressCity() {
		return this.address.city;
	}

	getAddressCode() {
		return this.address.code;
	}

	getAddressState() {
		return this.address.state;
	}

	getEmailOptOut() {
		return this.emailOptOut;
	}

	getRow() {
		return this.row;
	}
	/**
	 *
	 * @param {HTMLTableRowElement} row
	 */
	setRow(row) {
		this.row = row;
	}

	/* Cell builders start */

	/*
		zohoLeadLink : new ColumnDefinition('Zoho Lead', 'zohoLeadLink'),
		emailAddress : new ColumnDefinition('Email', 'emailAddress'),
		salutation : new ColumnDefinition('Salutation', 'salutation'),
		firstName : new ColumnDefinition('First Name', 'firstName'),
		lastName : new ColumnDefinition('Last Name', 'lastName'),
		phoneNumber : new ColumnDefinition('Phone Number', 'phoneNumber'),
		fax : new ColumnDefinition('Fax', 'fax'),
		organization : new ColumnDefinition('Organization', 'organization'),
		title : new ColumnDefinition('Title', 'title'),
		leadSource : new ColumnDefinition('Lead Source', 'leadSource'),
		street : new ColumnDefinition('Street', 'street'),
		city : new ColumnDefinition('City', 'city'),
		state : new ColumnDefinition('State', 'state'),
		code : new ColumnDefinition('Code', 'code'),
		emailOptOut : new ColumnDefinition('Opt Out', 'emailOptOut'),
	*/

	getCellByIdentifier(identifier, classes=[]) {
		const textCellIdentifiers = [
			'emailAddress',
			'salutation',
			'firstName',
			'lastName',
			'phoneNumber',
			'fax',
			'organization',
			'title',
			'leadSource',
			'street',
			'city',
			'state',
			'code',
			'emailOptOut'
		];
		if (textCellIdentifiers.includes(identifier)) {
			return this.getTextCell(this.getValueByIdentifier(identifier), classes);
		}
		else if (identifier == 'zohoContactLink') {
			return this.getLinkCell('Zoho Contact', this.getZohoLinkUrl(), classes);
		}
	}

	/**
	 * Builds cell with email address
	 * @param {string[]} classes List of classes for the cell
	 * @returns Cell with email address
	 */
	getEmailAddressCell(classes=[]) {
		return this.getTextCell(this.getEmailAddress(), classes);
	}

	getNameCell(classes=[]) {
		return this.getTextCell(this.getName(), classes);
	}

	/* Generic cell builders begin */

	/**
	 * Builds a data cell with text
	 * @param {string} textContent Text to put in the cell
	 * @param {string[]} classes List of classes for the cell
	 * @returns Cell node
	 */
	getTextCell(textContent, classes=[]) {
		const cell = document.createElement('td');
		cell.innerText = textContent;
		if (classes.length > 0) {
			cell.classList.add(classes);
		}
		return cell;
	}

	getPlaceholderCell(classes=[]) {
		return this.getTextCell('placeholder', classes);
	}

	getErrorCell(classes=[]) {
		return this.getTextCell('ERROR', classes);
	}

	/**
	 * Builds a cell with a URL link
	 * @param {string} linkText Text for the link
	 * @param {string} href URL to link to
	 * @param {string[]} classes List of cell classes
	 * @returns Cell containing link
	 */
	getLinkCell(linkText, href, classes=[]) {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		link.href = href;
		link.innerText = linkText;
		link.target = "_blank";
		cell.appendChild(link);
		if (classes.length > 0) {
			cell.classList.add(classes);
		}
		return cell;

	}
	/* Cell builders end */

	/**
	 *
	 * @param {ColumnDefinition[]} columns
	 */
	buildRow(columns) {
		const row = document.createElement('tr');
		// row.setAttribute('onclick', `openModal(${this.getId()})`);

		// const classList = ['cursor-pointer'];
		const classList = [];
		for (const column of columns) {
			const identifier = column.getIdentifier();

			try {
				row.appendChild(this.getCellByIdentifier(identifier, classList));
			}
			catch(err) {
				console.error(err);
				row.appendChild(this.getErrorCell());
			}
		}
		this.setRow(row);
		return row;
	}

	/*
		street : new ColumnDefinition('Street', 'street'),
		city : new ColumnDefinition('City', 'city'),
		state : new ColumnDefinition('State', 'state'),
		code : new ColumnDefinition('Code', 'code'),
		emailOptOut : new ColumnDefinition('Opt Out', 'emailOptOut'),
	*/

	/**
	 *
	 * @param {string} identifier
	 */
	getValueByIdentifier(identifier) {
		if (identifier == 'emailAddress') {
			return this.getEmail();
		}
		else if (identifier == 'salutation') {
			return this.getSalutation();
		}
		else if (identifier == 'firstName') {
			return this.getFirstName();
		}
		else if (identifier == 'lastName') {
			return this.getLastName();
		}
		else if (identifier == 'phoneNumber') {
			return this.getPhoneNumber();
		}
		else if (identifier == 'fax') {
			return this.getFax();
		}
		else if (identifier == 'organization') {
			return this.getOrganization();
		}
		else if (identifier == 'title') {
			return this.getTitle();
		}
		else if (identifier == 'leadSource') {
			return this.getLeadSource();
		}
		else if (identifier == 'street') {
			return this.getAddressStreet();
		}
		else if (identifier == "city") {
			return this.getAddressCity();
		}
		else if (identifier == "code") {
			return this.getAddressCode();
		}
		else if (identifier == "state") {
			if (this.getAddressState()) {
				if (this.getAddressState() instanceof State) {
					return this.getAddressState().getName();
				}
				else {
					return this.getAddressState();
				}
			}
		}
		else if (identifier == "emailOptOut") {
			return this.getEmailOptOut();;
		}
	}
}
