class State {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.abbreviation = data['abbreviation'];
	}

	getId() {
		return this.id;
	}

	getName() {
		return this.name;
	}

	getAbbreviation() {
		return this.abbreviation;
	}

	getStateOption() {
		const option = document.createElement('option');
		option.value = this.getId();
		option.innerText = this.getName();
		return option;
	}
}
