class Region {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.identifier = data['identifier'];
		/**
		 * @type {State[]}
		 */
		this.states = [];

		for (const stateData of data['states']) {
			this.states.push(new State(stateData));
		}
	}

	getId() {
		return this.id;
	}

	getName() {
		return this.name;
	}

	getIdentifier() {
		return this.identifier;
	}

	getStates() {
		return this.states;
	}

	getRegionOption() {
		const option = document.createElement('option');
		option.value = this.getId();
		option.innerText = this.getName();
		return option;
	}
}
