CONTROLLER_BASE_URL = 'admin_controller.php';


/**
 * @type {HTMLDivElement}
 */
const newBoxRow = document.getElementById('box_row_new');
/**
 * @type {HTMLButtonElement}
 */
const createNewBoxButton = document.getElementById('create_new_btn');

const newBoxElements = {
	row : document.getElementById('box_row_new'),
	createButton : document.getElementById('create_new_btn'),
	form : {
		/**
		 * @type {HTMLInputElement}
		 */
		name : document.getElementById('name_new'),
		/**
		 * @type {HTMLInputElement}
		 */
		length : document.getElementById('length_new'),
		/**
		 * @type {HTMLInputElement}
		 */
		width : document.getElementById('width_new'),
		/**
		 * @type {HTMLInputElement}
		 */
		height : document.getElementById('height_new'),
		/**
		 * @type {HTMLInputElement}
		 */
		lbs : document.getElementById('lbs_new'),
		/**
		 * @type {HTMLInputElement}
		 */
		oz : document.getElementById('oz_new'),
		/**
		 * @type {HTMLSelectElement}
		 */
		type_code : document.getElementById(`ups_type_code_new`)
	}
}


function toggleCreateNew() {
	newBoxElements.row.hidden = !newBoxElements.row.hidden;
	newBoxElements.createButton.hidden = !newBoxElements.createButton.hidden;
	for (element in newBoxElements.form) {
		newBoxElements.form[element].value = '';
	}
}

function saveNewBox() {
	const name = newBoxElements.form.name.value,
		length = newBoxElements.form.length.value,
		width = newBoxElements.form.width.value,
		height = newBoxElements.form.height.value,
		lbs = newBoxElements.form.lbs.value,
		oz = newBoxElements.form.oz.value,
		type_code = newBoxElements.form.type_code.value
	const values = {
		name : name,
		length : length,
		width : width,
		height : height,
		lbs : lbs,
		oz : oz,
		type_code : type_code
	}
	const errorMsg = validate(values);
	if (errorMsg) {
		alert(errorMsg);
		return false;
	}
	const url = `${CONTROLLER_BASE_URL}?m=save_new_shipping_box`;
	const poststr = `name=${name}&length=${length}&width=${width}&height=${height}&lbs=${lbs}&oz=${oz}&type_code=${type_code}`;
	makeAjaxRequest(url, poststr, 'POST', returnResult);
}

function updateWeight(id) {
	if (id == 0) {
		id = 'new';
	}
	const elements = {
		/**
		 * @type {HTMLInputElement}
		 */
		lbs : document.getElementById(`lbs_${id}`),
		/**
		 * @type {HTMLInputElement}
		 */
		oz : document.getElementById(`oz_${id}`)
	}
	if (parseInt(elements.oz.value) < 0) {
		elements.lbs.value = parseInt(elements.lbs.value) - 1;
		elements.oz.value = 16 - Math.abs(parseInt(elements.oz.value));
	}
	if (parseInt(elements.oz.value) > 15) {
		elements.lbs.value = parseInt(elements.lbs.value) + Math.floor(elements.oz.value / 16);
		elements.oz.value = elements.oz.value % 16;
	}
}

function editBox(id) {
	const rowElements = {
		/**
		 * @type {HTMLDivElement}
		 */
		row : document.getElementById(`box_row_${id}`),
		buttons : {
			/**
			 * @type {HTMLButtonElement}
			 */
			edit : document.getElementById(`edit_${id}`),
			/**
			 * @type {HTMLButtonElement}
			 */
			delete : document.getElementById(`delete_${id}`),
			/**
			 * @type {HTMLButtonElement}
			 */
			save : document.getElementById(`save_${id}`),
		},
		inputs : {
			/**
			 * @type {HTMLInputElement}
			 */
			name : document.getElementById(`name_${id}`),
			/**
			 * @type {HTMLInputElement}
			 */
			length : document.getElementById(`length_${id}`),
			/**
			 * @type {HTMLInputElement}
			 */
			width : document.getElementById(`width_${id}`),
			/**
			 * @type {HTMLInputElement}
			 */
			height : document.getElementById(`height_${id}`),
			/**
			 * @type {HTMLInputElement}
			 */
			lbs : document.getElementById(`lbs_${id}`),
			/**
			 * @type {HTMLInputElement}
			 */
			oz : document.getElementById(`oz_${id}`),
			/**
			 * @type {HTMLSelectElement}
			 */
			type_code : document.getElementById(`ups_type_code_${id}`)
		}
	}
	for (input in rowElements.inputs) {
		rowElements.inputs[input].disabled = !rowElements.inputs[input].disabled;
	}
	rowElements.buttons.save.hidden = !rowElements.buttons.save.hidden;
}

function deleteBox(id) {
	const name = document.getElementById(`name_${id}`).value;
	const confirmMsg = `Are you sure you want to delete box '${name}'? This cannot be undone.`;
	if (confirm(confirmMsg)) {
		const url = `${CONTROLLER_BASE_URL}?m=delete_shipping_box`;
		const poststr = `id=${id}`;
		makeAjaxRequest(url, poststr, 'POST', returnResult);
	}
}

function saveBox(id) {
	const values = {
		name : document.getElementById(`name_${id}`).value,
		length : document.getElementById(`length_${id}`).value,
		width : document.getElementById(`width_${id}`).value,
		height : document.getElementById(`height_${id}`).value,
		lbs : document.getElementById(`lbs_${id}`).value,
		oz : document.getElementById(`oz_${id}`).value,
		type_code : document.getElementById(`ups_type_code_${id}`).value
	}
	const errorMsg = validate(values);
	if (errorMsg) {
		alert(errorMsg);
		return false;
	}
	const url = `${CONTROLLER_BASE_URL}?m=save_shipping_box`;
	const poststr = `id=${id}&name=${values.name}&length=${values.length}&width=${values.width}&height=${values.height}&lbs=${values.lbs}&oz=${values.oz}&type_code=${values.type_code}`;
	makeAjaxRequest(url, poststr, 'POST', returnResult);
}

function returnResult() {
	if (http_request.readyState == 4) {
		switch(http_request.status) {
			case 200:
				location.reload();
				return true;
			default:
				alert('Error with AJAX request. Check network connectivity and try again. HTTP request status: ' + http_request.status);
				return false;
		}
	}
}

function validate(values) {
	let errorMsg = '';
	if (!values.name) {
		errorMsg += 'Please enter a name.\n';
	}
	if (!values.length) {
		errorMsg += 'Please enter a length.\n';
	}
	if (!values.width) {
		errorMsg += 'Please enter a width.\n';
	}
	if (!values.height) {
		errorMsg += 'Please enter a height.\n';
	}
	if (!values.lbs && !values.oz) {
		errorMsg += 'Please enter a weight.\n';
	}
	if (parseInt(values.lbs) < 0 || parseInt(values.oz) < 0) {
		errorMsg += 'Invalid weight entered.';
	}
	return errorMsg;
}
