class ConstantContact {
	constructor(data) {
		this.id = (data['id']) ? data['id'] : (data['dbId']) ? data['dbId'] : '';

		/**
		 * @type {string}
		 */
		this.firstName = data['firstName'];
		/**
		 * @type {string}
		 */
		this.lastName = data['lastName'];
		/**
		 * @type {string}
		 */
		this.title = data['title'];
		/**
		 * @type {string}
		 */
		this.organization = data['organization'];

		/**
		 * @type {string}
		 */
		this.email = data['email'];
		/**
		 * @type {string}
		 */
		this.emailLists = data['emailLists'];

		/**
		 * @type {string}
		 */
		 this.leadSource = data['leadSource'];

		/**
		 * @type {string}
		 */
		this.tags = data['tags'];

		/**
		 * @type {string}
		 */
		this.notes = data['notes'];


		this.row = null;
	}

	getFirstName() {
		return this.firstName;
	}

	getLastName() {
		return this.lastName;
	}

	getEmail() {
		return this.email;
	}

	getOrganization() {
		return this.organization;
	}

	getTitle() {
		return this.title;
	}

	getLeadSource() {
		return this.leadSource;
	}

	getRow() {
		return this.row;
	}
	/**
	 *
	 * @param {HTMLTableRowElement} row
	 */
	setRow(row) {
		this.row = row;
	}

	/* Cell builders start */

	/*
		emailAddress : new ColumnDefinition('Email', 'emailAddress'),
		firstName : new ColumnDefinition('First Name', 'firstName'),
		lastName : new ColumnDefinition('Last Name', 'lastName'),
		organization : new ColumnDefinition('Organization', 'organization'),
		title : new ColumnDefinition('Title', 'title'),
		leadSource : new ColumnDefinition('Lead Source', 'leadSource'),
	*/

	getCellByIdentifier(identifier, classes=[]) {
		const textCellIdentifiers = [
			'emailAddress',
			'firstName',
			'lastName',
			'organization',
			'title',
			'leadSource'
		];
		if (textCellIdentifiers.includes(identifier)) {
			return this.getTextCell(this.getValueByIdentifier(identifier), classes);
		}
	}

	/**
	 * Builds cell with email address
	 * @param {string[]} classes List of classes for the cell
	 * @returns Cell with email address
	 */
	getEmailAddressCell(classes=[]) {
		return this.getTextCell(this.getEmailAddress(), classes);
	}

	getNameCell(classes=[]) {
		return this.getTextCell(this.getName(), classes);
	}

	/* Generic cell builders begin */

	/**
	 * Builds a data cell with text
	 * @param {string} textContent Text to put in the cell
	 * @param {string[]} classes List of classes for the cell
	 * @returns Cell node
	 */
	getTextCell(textContent, classes=[]) {
		const cell = document.createElement('td');
		cell.innerText = textContent;
		if (classes.length > 0) {
			cell.classList.add(classes);
		}
		return cell;
	}

	getPlaceholderCell(classes=[]) {
		return this.getTextCell('placeholder', classes);
	}

	getErrorCell(classes=[]) {
		return this.getTextCell('ERROR', classes);
	}

	/**
	 * Builds a cell with a URL link
	 * @param {string} linkText Text for the link
	 * @param {string} href URL to link to
	 * @param {string[]} classes List of cell classes
	 * @returns Cell containing link
	 */
	getLinkCell(linkText, href, classes=[]) {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		link.href = href;
		link.innerText = linkText;
		link.target = "_blank";
		cell.appendChild(link);
		if (classes.length > 0) {
			cell.classList.add(classes);
		}
		return cell;

	}
	/* Cell builders end */

	/**
	 *
	 * @param {ColumnDefinition[]} columns
	 */
	buildRow(columns) {
		const row = document.createElement('tr');
		// row.setAttribute('onclick', `openModal(${this.getId()})`);

		// const classList = ['cursor-pointer'];
		const classList = [];
		for (const column of columns) {
			const identifier = column.getIdentifier();

			try {
				row.appendChild(this.getCellByIdentifier(identifier, classList));
			}
			catch(err) {
				console.error(err);
				row.appendChild(this.getErrorCell());
			}
		}
		this.setRow(row);
		return row;
	}

	/*
		street : new ColumnDefinition('Street', 'street'),
		city : new ColumnDefinition('City', 'city'),
		state : new ColumnDefinition('State', 'state'),
		code : new ColumnDefinition('Code', 'code'),
		emailOptOut : new ColumnDefinition('Opt Out', 'emailOptOut'),
	*/

	/**
	 *
	 * @param {string} identifier
	 */
	getValueByIdentifier(identifier) {
		if (identifier == 'emailAddress') {
			return this.getEmail();
		}
		else if (identifier == 'firstName') {
			return this.getFirstName();
		}
		else if (identifier == 'lastName') {
			return this.getLastName();
		}
		else if (identifier == 'organization') {
			return this.getOrganization();
		}
		else if (identifier == 'title') {
			return this.getTitle();
		}
		else if (identifier == 'leadSource') {
			return this.getLeadSource();
		}
	}

	/*
	leadSource: "Added by you"
	notes: ""
	tags: "ALCUSTOMER,ZOHOIMPORT"
	*/
}
