class ConsolidatedContact {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		/**
		 * @type {string}
		 */
		this.emailAddress = data['emailAddress'];

		this.emailOptOut = (data['emailOptOut'] == '1') ? true : false;

		if (data['zohoLead']) {
			this.zohoLead = new ZohoLead(data['zohoLead']);
		}
		else {
			this.zohoLead = null;
		}

		if (data['zohoContact']) {
			this.zohoContact = new ZohoContact(data['zohoContact']);
		}
		else {
			this.zohoContact = null;
		}

		if (data['constantContact']) {
			this.constantContact = new ConstantContact(data['constantContact']);
		}
		else {
			this.constantContact = null;
		}

		/**
		 * @type {HTMLTableRowElement}
		 */
		this.row = null;
	}

	getId() {
		return this.id;
	}

	getEmailAddress() {
		return this.emailAddress;
	}

	getEmailOptOut() {
		return this.emailOptOut;
	}

	getZohoLead() {
		return this.zohoLead;
	}

	getZohoContact() {
		return this.zohoContact;
	}

	getConstantContact() {
		return this.constantContact;
	}

	getName() {
		return `${this.getFirstName()} ${this.getLastName()}`;
	}

	getFirstName() {
		if (this.getZohoContact()) {
			return this.getZohoContact().getFirstName();
		}
		else if (this.getConstantContact()) {
			return this.getConstantContact().getFirstName();
		}
		else if (this.getZohoLead()) {
			return this.getZohoLead().getFirstName();
		}
		else {
			return '';
		}
	}

	getLastName() {
		if (this.getZohoContact()) {
			return this.getZohoContact().getLastName();
		}
		else if (this.getConstantContact()) {
			return this.getConstantContact().getLastName();
		}
		else if (this.getZohoLead()) {
			return this.getZohoLead().getLastName();
		}
		else {
			return '';
		}
	}

	getAccountType() {
		if (this.getZohoContact() && this.getZohoContact().getAccount()) {
			return this.getZohoContact().getAccount().getAccountType();
		}
		else {
			return '';
		}
	}

	getOrganization() {
		if (this.getZohoContact() && this.getZohoContact().getAccount() && this.getZohoContact().getAccount().getName()) {
			return this.getZohoContact().getAccount().getName();
		}
		else if (this.getConstantContact() && this.getConstantContact().getOrganization()) {
			return this.getConstantContact().getOrganization();
		}
		else if (this.getZohoLead() && this.getZohoLead().getOrganization()) {
			return this.getZohoLead().getOrganization();
		}
		else {
			return '';
		}
	}

	getTitle() {
		if (this.getZohoContact() && this.getZohoContact().getTitle()) {
			return this.getZohoContact().getTitle();
		}
		else if (this.getConstantContact() && this.getConstantContact().getTitle()) {
			return this.getConstantContact().getTitle();
		}
		else if (this.getZohoLead() && this.getZohoLead().getTitle()) {
			return this.getZohoLead().getTitle();
		}
		else {
			return '';
		}
	}

	getTotalSpent() {
		if (this.getZohoContact() && this.getZohoContact().getAccount()) {
			return this.getZohoContact().getAccount().getTotalSpent();
		}
		else {
			return 0;
		}
	}

	getEnrollment() {
		if (this.getZohoContact() && this.getZohoContact().getAccount()) {
			return this.getZohoContact().getAccount().getEnrollment();
		}
		else {
			return 0;
		}
	}

	getAddressStreet() {
		if (this.getZohoContact() && this.getZohoContact().getAddressStreet()) {
			return this.getZohoContact().getAddressStreet();
		}
		else if (this.getZohoLead() && this.getZohoLead().getAddressStreet()) {
			return this.getZohoLead().getAddressStreet();
		}
		else if (this.getZohoContact().getAccount().getAddressStreet()) {
			return this.getZohoContact().getAccount().getAddressStreet();
		}
	}

	getAddressCity() {
		if (this.getZohoContact() && this.getZohoContact().getAddressCity()) {
			return this.getZohoContact().getAddressCity();
		}
		else if (this.getZohoLead() && this.getZohoLead().getAddressCity()) {
			return this.getZohoLead().getAddressCity();
		}
		else if (this.getZohoContact().getAccount().getAddressCity()) {
			return this.getZohoContact().getAccount().getAddressCity();
		}
	}

	getAddressState() {
		if (this.getZohoContact() && this.getZohoContact().getAddressState()) {
			const state = this.getZohoContact().getAddressState();
			if (state instanceof State) {
				return state.getName();
			}
			else {
				return state;
			}
		}
		else if (this.getZohoLead() && this.getZohoLead().getAddressState()) {
			const state = this.getZohoLead().getAddressState();
			if (state instanceof State) {
				return state.getName();
			}
			else {
				return state;
			}
		}
		else if (this.getZohoContact().getAccount().getAddressState()) {
			return this.getZohoContact().getAccount().getAddressState();
		}
	}

	getLeadSource() {
		/**
		 * @type {string[]}
		 */
		const sourceStrings = [];
		if (this.onZohoLeads() && this.getZohoLead().getLeadSource()) {
			sourceStrings.push(`Zoho Leads: ${this.getZohoLead().getLeadSource()}`);
		}
		if (this.onZohoContacts() && this.getZohoContact().getLeadSource()) {
			sourceStrings.push(`Zoho Contacts: ${this.getZohoContact().getLeadSource()}`);
		}
		if (this.onConstantContact() && this.getConstantContact().getLeadSource()) {
			sourceStrings.push(`Constant Contact: ${this.getConstantContact().getLeadSource()}`);
		}
		return sourceStrings.join('<br/>');
	}

	getRow() {
		return this.row;
	}
	/**
	 *
	 * @param {HTMLTableRowElement} row
	 */
	setRow(row) {
		this.row = row;
	}

	onZohoLeads() {
		return (this.getZohoLead()) ? true : false;
	}

	onZohoContacts() {
		return (this.getZohoContact()) ? true : false;
	}

	onConstantContact() {
		return (this.getConstantContact()) ? true : false;
	}

	/* Cell builders start */


	/**
	 * Builds cell with email address
	 * @param {string[]} classes List of classes for the cell
	 * @returns Cell with email address
	 */
	getEmailAddressCell(classes=[]) {
		return this.getTextCell(this.getEmailAddress(), classes);
	}

	getNameCell(classes=[]) {
		return this.getTextCell(this.getName(), classes);
	}

	/**
	 * Builds a data cell with text
	 * @param {string} textContent Text to put in the cell
	 * @param {string[]} classes List of classes for the cell
	 * @returns Cell node
	 */
	getTextCell(textContent, classes=[]) {
		const cell = document.createElement('td');
		cell.innerHTML = textContent;
		if (classes) {
			cell.classList.add(...classes);
		}
		return cell;
	}
	/* Cell builders end */

	/**
	 *
	 * @param {ColumnDefinition[]} columns
	 */
	getContactRow(columns) {
		const row = document.createElement('tr');
		row.setAttribute('onclick', `openModal(${this.getId()})`);

		const booleanCells = ['onZohoLeads', 'onZohoContacts', 'onConstantContact'];
		const currencyCells = ['totalSpent'];
		const numberCells = ['enrollment'];

		const classList = ['cursor-pointer'];
		for (const column of columns) {
			const identifier = column.getIdentifier();
			if (booleanCells.includes(identifier)) {
				/**
				 * @type {boolean}
				 */
				const boolValue = this.getValueByIdentifier(identifier);
				const value = (boolValue) ? "Yes" : "No";
				row.appendChild(this.getTextCell(value, (boolValue) ? classList.concat('in-list') : classList.concat('not-in-list')));
			}
			else if (identifier == 'emailOptOut') {
				/**
				 * @type {boolean}
				 */
				const boolValue = this.getValueByIdentifier(identifier);
				const value = (boolValue) ? "Yes" : "No";
				row.appendChild(this.getTextCell(value, (boolValue) ? classList.concat('not-in-list') : classList.concat('in-list')));
			}
			else if (currencyCells.includes(identifier)) {
				/**
				 * @type {number}
				 */
				const numValue = (typeof this.getValueByIdentifier(identifier) == "number") ? this.getValueByIdentifier(identifier) : 0;
				const value = numValue.toLocaleString('en-US', {style: 'currency', currency: 'USD'});
				row.appendChild(this.getTextCell(value));
			}
			else if (numberCells.includes(identifier)) {
				/**
				 * @type {number}
				 */
				const numValue = (typeof this.getValueByIdentifier(identifier) == "number") ? this.getValueByIdentifier(identifier) : 0;
				const value = numValue.toLocaleString();
				row.appendChild(this.getTextCell(value));
			}
			else {

				row.appendChild(this.getTextCell(this.getValueByIdentifier(identifier), classList));
			}
		}
		this.setRow(row);
		return row;
	}

	/**
	 *
	 * @param {string} identifier
	 */
	getValueByIdentifier(identifier) {
		if (identifier == 'emailAddress') {
			return this.getEmailAddress();
		}
		else if (identifier == 'emailOptOut') {
			return this.getEmailOptOut();
		}
		else if (identifier == 'name') {
			return this.getName();
		}
		else if (identifier == 'organization') {
			return this.getOrganization();
		}
		else if (identifier == 'title') {
			return this.getTitle();
		}
		else if (identifier == "totalSpent") {
			return this.getTotalSpent();
		}
		else if (identifier == "enrollment") {
			return this.getEnrollment();
		}
		else if (identifier == "accountType") {
			return this.getAccountType();
		}
		else if (identifier == "city") {
			return this.getAddressCity();
		}
		else if (identifier == 'state') {
			return this.getAddressState();
		}
		else if (identifier == "code") {
			return this.getAddressCode();
		}
		else if (identifier == "onZohoLeads") {
			return this.onZohoLeads();
		}
		else if (identifier == "onZohoContacts") {
			return this.onZohoContacts();
		}
		else if (identifier == "onConstantContact") {
			return this.onConstantContact();
		}
		else if (identifier == "leadSource") {
			return this.getLeadSource();
		}
		else {
			console.warn(`Attempted to get value for unknown identifier ${identifier}. No value returned.`);
			return null;
		}
	}

	/**
	 * Builds cell by identifier
	 * @param {string} identifier Identifier string
	 * @returns Cell
	 */
	getCellByIdentifier(identifier) {
		if (identifier == 'emailAddress') {
			return this.getEmailAddressCell();
		}
		else if (idenfitier == 'name') {
			return this.getNameCell();
		}
	}
}
