/**
 * @type {HTMLDivElement}
 */
const CONTACT_MODAL = document.getElementById('contact_modal');

const CONTACT_MODAL_ELEMENTS = {
	/**
	 * @type {HTMLHeadingElement}
	 */
	modalTitle : document.getElementById('contact_modal_title'),
	/**
	 * @type {HTMLTableElement}
	 */
	zohoLeadTable : document.getElementById('zoho_lead_table'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	zohoLeadTableHead : document.getElementById('zoho_lead_table_head'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	zohoLeadTableBody : document.getElementById('zoho_lead_table_body'),
	/**
	 * @type {HTMLTableElement}
	 */
	zohoContactTable : document.getElementById('zoho_contact_table'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	zohoContactTableHead : document.getElementById('zoho_contact_table_head'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	zohoContactTableBody : document.getElementById('zoho_contact_table_body'),
	/**
	 * @type {HTMLTableElement}
	 */
	constantContactTable : document.getElementById('constant_contact_table'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	constantContactTableHead : document.getElementById('constant_contact_table_head'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	constantContactTableBody : document.getElementById('constant_contact_table_body'),
	/**
	 * @type {HTMLTableElement}
	 */
	zohoAccountTable : document.getElementById('zoho_account_table'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	zohoAccountTableHead : document.getElementById('zoho_account_table_head'),
	/**
	 * @type {HTMLTableSectionElement}
	 */
	zohoAccountTableBody : document.getElementById('zoho_account_table_body'),
}

const MODAL_COLUMN_DEFINES = {
	zohoLeads : {
		zohoLeadLink : new ColumnDefinition('Zoho Lead', 'zohoLeadLink'),
		emailAddress : new ColumnDefinition('Email', 'emailAddress'),
		salutation : new ColumnDefinition('Salutation', 'salutation'),
		firstName : new ColumnDefinition('First Name', 'firstName'),
		lastName : new ColumnDefinition('Last Name', 'lastName'),
		phoneNumber : new ColumnDefinition('Phone Number', 'phoneNumber'),
		fax : new ColumnDefinition('Fax', 'fax'),
		organization : new ColumnDefinition('Organization', 'organization'),
		title : new ColumnDefinition('Title', 'title'),
		leadSource : new ColumnDefinition('Lead Source', 'leadSource'),
		street : new ColumnDefinition('Street', 'street'),
		city : new ColumnDefinition('City', 'city'),
		state : new ColumnDefinition('State', 'state'),
		code : new ColumnDefinition('Code', 'code'),
		emailOptOut : new ColumnDefinition('Opt Out', 'emailOptOut'),
	},
	zohoContacts : {
		zohoContactLink : new ColumnDefinition('Zoho Contact', 'zohoContactLink'),
		emailAddress : new ColumnDefinition('Email', 'emailAddress'),
		salutation : new ColumnDefinition('Salutation', 'salutation'),
		firstName : new ColumnDefinition('First Name', 'firstName'),
		lastName : new ColumnDefinition('Last Name', 'lastName'),
		phoneNumber : new ColumnDefinition('Phone Number', 'phoneNumber'),
		fax : new ColumnDefinition('Fax', 'fax'),
		organization : new ColumnDefinition('Organization', 'organization'),
		title : new ColumnDefinition('Title', 'title'),
		leadSource : new ColumnDefinition('Lead Source', 'leadSource'),
		street : new ColumnDefinition('Street', 'street'),
		city : new ColumnDefinition('City', 'city'),
		state : new ColumnDefinition('State', 'state'),
		code : new ColumnDefinition('Code', 'code'),
		emailOptOut : new ColumnDefinition('Opt Out', 'emailOptOut'),
	},
	zohoAccounts: {
		zohoAccountLink : new ColumnDefinition('Zoho Account', 'zohoAccountLink'),
		name : new ColumnDefinition('Name', 'name'),
		phoneNumber : new ColumnDefinition('Phone Number', 'phoneNumber'),
		website : new ColumnDefinition('Website', 'website'),
		accountType : new ColumnDefinition('Account Type', 'accountType'),
		enrollment : new ColumnDefinition('Enrollment', 'enrollment'),
		totalSpent : new ColumnDefinition('Total Spent', 'totalSpent'),
		billingStreet : new ColumnDefinition('Billing Street', 'billingStreet'),
		billingCity : new ColumnDefinition('Billing City', 'billingCity'),
		billingState : new ColumnDefinition('Billing State', 'billingState'),
		billingCode : new ColumnDefinition('Billing Code', 'billingCode'),
		shippingStreet : new ColumnDefinition('Shipping Street', 'shippingStreet'),
		shippingCity : new ColumnDefinition('Shipping City', 'shippingCity'),
		shippingState : new ColumnDefinition('Shipping State', 'shippingState'),
		shippingCode : new ColumnDefinition('Shipping Code', 'shippingCode')
	},
	constantContacts : {
		emailAddress : new ColumnDefinition('Email', 'emailAddress'),
		firstName : new ColumnDefinition('First Name', 'firstName'),
		lastName : new ColumnDefinition('Last Name', 'lastName'),
		organization : new ColumnDefinition('Organization', 'organization'),
		title : new ColumnDefinition('Title', 'title'),
		leadSource : new ColumnDefinition('Lead Source', 'leadSource'),
	}
}

const modalColumns = {
	zohoLeads : [
		MODAL_COLUMN_DEFINES.zohoLeads.zohoLeadLink,
		// MODAL_COLUMN_DEFINES.zohoLeads.emailAddress,
		MODAL_COLUMN_DEFINES.zohoLeads.salutation,
		MODAL_COLUMN_DEFINES.zohoLeads.firstName,
		MODAL_COLUMN_DEFINES.zohoLeads.lastName,
		MODAL_COLUMN_DEFINES.zohoLeads.phoneNumber,
		MODAL_COLUMN_DEFINES.zohoLeads.fax,
		MODAL_COLUMN_DEFINES.zohoLeads.organization,
		MODAL_COLUMN_DEFINES.zohoLeads.title,
		MODAL_COLUMN_DEFINES.zohoLeads.leadSource,
		MODAL_COLUMN_DEFINES.zohoLeads.street,
		MODAL_COLUMN_DEFINES.zohoLeads.city,
		MODAL_COLUMN_DEFINES.zohoLeads.state,
		MODAL_COLUMN_DEFINES.zohoLeads.code,
		MODAL_COLUMN_DEFINES.zohoLeads.emailOptOut,
	],
	zohoContacts : [
		MODAL_COLUMN_DEFINES.zohoContacts.zohoContactLink,
		// MODAL_COLUMN_DEFINES.zohoContacts.emailAddress,
		MODAL_COLUMN_DEFINES.zohoContacts.salutation,
		MODAL_COLUMN_DEFINES.zohoContacts.firstName,
		MODAL_COLUMN_DEFINES.zohoContacts.lastName,
		MODAL_COLUMN_DEFINES.zohoContacts.phoneNumber,
		MODAL_COLUMN_DEFINES.zohoContacts.fax,
		MODAL_COLUMN_DEFINES.zohoContacts.organization,
		MODAL_COLUMN_DEFINES.zohoContacts.title,
		MODAL_COLUMN_DEFINES.zohoContacts.leadSource,
		MODAL_COLUMN_DEFINES.zohoContacts.street,
		MODAL_COLUMN_DEFINES.zohoContacts.city,
		MODAL_COLUMN_DEFINES.zohoContacts.state,
		MODAL_COLUMN_DEFINES.zohoContacts.code,
		MODAL_COLUMN_DEFINES.zohoContacts.emailOptOut,
	],
	zohoAccounts : [
		MODAL_COLUMN_DEFINES.zohoAccounts.zohoAccountLink,
		MODAL_COLUMN_DEFINES.zohoAccounts.name,
		MODAL_COLUMN_DEFINES.zohoAccounts.phoneNumber,
		MODAL_COLUMN_DEFINES.zohoAccounts.website,
		MODAL_COLUMN_DEFINES.zohoAccounts.accountType,
		MODAL_COLUMN_DEFINES.zohoAccounts.enrollment,
		MODAL_COLUMN_DEFINES.zohoAccounts.totalSpent,
		MODAL_COLUMN_DEFINES.zohoAccounts.billingStreet,
		MODAL_COLUMN_DEFINES.zohoAccounts.billingCity,
		MODAL_COLUMN_DEFINES.zohoAccounts.billingState,
		MODAL_COLUMN_DEFINES.zohoAccounts.billingCode,
		MODAL_COLUMN_DEFINES.zohoAccounts.shippingStreet,
		MODAL_COLUMN_DEFINES.zohoAccounts.shippingCity,
		MODAL_COLUMN_DEFINES.zohoAccounts.shippingState,
		MODAL_COLUMN_DEFINES.zohoAccounts.shippingCode,
	],
	constantContacts : [
		// MODAL_COLUMN_DEFINES.constantContacts.emailAddress,
		MODAL_COLUMN_DEFINES.constantContacts.firstName,
		MODAL_COLUMN_DEFINES.constantContacts.lastName,
		MODAL_COLUMN_DEFINES.constantContacts.organization,
		MODAL_COLUMN_DEFINES.constantContacts.title,
		MODAL_COLUMN_DEFINES.constantContacts.leadSource,
	]
};

window.onclick = function(event) {
	if (event.target == CONTACT_MODAL) {
		closeContactModal();
	}
}

function closeContactModal() {
	CONTACT_MODAL.classList.remove('active');

	for (const element in CONTACT_MODAL_ELEMENTS) {
		const section = CONTACT_MODAL_ELEMENTS[element];
		if (section instanceof HTMLTableElement) {
			section.hidden = true;
		}
		else if (section instanceof HTMLTableSectionElement) {
			section.innerHTML = '';
		}
	}
}

function openModal(contactId) {
	console.log(contactId);
	console.log(CONTACT_DICT[contactId]);
	/**
	 * @type {ConsolidatedContact}
	 */
	const contact = CONTACT_DICT[contactId];
	CONTACT_MODAL_ELEMENTS.modalTitle.innerText = contact.getEmailAddress();
	console.log(CONTACT_MODAL);
	if (contact.getZohoLead()) {
		buildZohoLeadTable(contact.getZohoLead());
		CONTACT_MODAL_ELEMENTS.zohoLeadTable.hidden = false;
	}
	if (contact.getZohoContact()) {
		buildZohoContactTable(contact.getZohoContact());
		CONTACT_MODAL_ELEMENTS.zohoContactTable.hidden = false;
		if (contact.getZohoContact().getAccount()) {
			buildZohoAccountTable(contact.getZohoContact().getAccount());
			CONTACT_MODAL_ELEMENTS.zohoAccountTable.hidden = false;

		}
	}
	if (contact.getConstantContact()) {
		buildConstantContactTable(contact.getConstantContact());
		CONTACT_MODAL_ELEMENTS.constantContactTable.hidden = false;
	}

	CONTACT_MODAL.classList.add('active');
}

/**
 *
 * @param {ZohoLead} zohoLead
 */
function buildZohoLeadTable(zohoLead) {
	const tableHead = CONTACT_MODAL_ELEMENTS.zohoLeadTableHead;
	const tableBody = CONTACT_MODAL_ELEMENTS.zohoLeadTableBody;

	const headRow = document.createElement('tr');
	for (const column of modalColumns.zohoLeads) {
		headRow.appendChild(column.getHeaderCellElement());
	}
	tableHead.appendChild(headRow);
	tableBody.appendChild(zohoLead.buildRow(modalColumns.zohoLeads));

}

/**
 *
 * @param {ZohoContact} zohoContact
 */
function buildZohoContactTable(zohoContact) {
	const tableHead = CONTACT_MODAL_ELEMENTS.zohoContactTableHead;
	const tableBody = CONTACT_MODAL_ELEMENTS.zohoContactTableBody;

	const headRow = document.createElement('tr');
	for (const column of modalColumns.zohoContacts) {
		headRow.appendChild(column.getHeaderCellElement());
	}
	tableHead.appendChild(headRow);
	tableBody.appendChild(zohoContact.buildRow(modalColumns.zohoContacts));
}

/**
 *
 * @param {ConstantContact} constantContact
 */
function buildConstantContactTable(constantContact) {
	const tableHead = CONTACT_MODAL_ELEMENTS.constantContactTableHead;
	const tableBody = CONTACT_MODAL_ELEMENTS.constantContactTableBody;

	const headRow = document.createElement('tr');
	for (const column of modalColumns.constantContacts) {
		headRow.appendChild(column.getHeaderCellElement());
	}
	tableHead.appendChild(headRow);
	tableBody.appendChild(constantContact.buildRow(modalColumns.constantContacts));
}

/**
 *
 * @param {Account} zohoAccount
 */
function buildZohoAccountTable(zohoAccount) {
	const tableHead = CONTACT_MODAL_ELEMENTS.zohoAccountTableHead;
	const tableBody = CONTACT_MODAL_ELEMENTS.zohoAccountTableBody;

	const headRow = document.createElement('tr');
	for (const column of modalColumns.zohoAccounts) {
		headRow.appendChild(column.getHeaderCellElement());
	}
	tableHead.appendChild(headRow);
	tableBody.appendChild(zohoAccount.buildRow(modalColumns.zohoAccounts));

}
