const CONTROLLER_BASE_URL = "admin_controller.php";

const FREIGHT_CARRIER_DICT = {};
/**
 * @type {FreightCarrier[]}
 */
const FREIGHT_CARRIER_ARRAY = [];

/**
 * @type {HTMLTableSectionElement}
 */
const FREIGHT_CARRIER_TABLE_BODY = document.getElementById('freightCarriersTableBody');

let newCount = 0;

init();

async function init() {
	setLoadingModalVisible(true);
	for (const id in FREIGHT_CARRIER_DICT) {
		delete FREIGHT_CARRIER_DICT[id];
	}
	FREIGHT_CARRIER_ARRAY.length = 0;

	const responseText = await fetch(`${CONTROLLER_BASE_URL}?m=getFreightCarriers`)
		.then(response => response.text());

	try {
		const data = JSON.parse(responseText);
		processFreightCarriers(data);
	}
	catch (err) {
		console.error(err);
		console.log(responseText);
	}

	renderFreightCarriers();
	setLoadingModalVisible(false);
}

function processFreightCarriers(data) {
	for (const member of data) {
		const carrier = new FreightCarrier(member);
		const id = carrier.getId();
		FREIGHT_CARRIER_DICT[id] = carrier;
		FREIGHT_CARRIER_ARRAY.push(carrier);
	}
}

function renderFreightCarriers() {
	FREIGHT_CARRIER_TABLE_BODY.innerHTML = '';
	for (const carrier of FREIGHT_CARRIER_ARRAY) {
		delete carrier.row;
		FREIGHT_CARRIER_TABLE_BODY.appendChild(carrier.generateRow());
	}
}

/**
 *
 * @param {HTMLButtonElement} button
 */
function toggleEdit(button) {
	const carrierID = button.getAttribute('carrierid');
	const carrierInputID = button.getAttribute('carrierinputid');
	/**
	 * @type {HTMLInputElement}
	 */
	const input = document.getElementById(carrierInputID);
	/**
	 * @type {FreightCarrier}
	 */
	const carrier = FREIGHT_CARRIER_DICT[carrierID];
	carrier.editActive = input.disabled;
	input.disabled = !input.disabled;
}

/**
 *
 * @param {HTMLInputElement} input
 */
function editCarrier(input) {
	const id = input.getAttribute('carrierid');
	const value = input.value;

	/**
	 * @type {FreightCarrier}
	 */
	const carrier = FREIGHT_CARRIER_DICT[id];

	carrier.setName(value);
	carrier.updateRowClasses();
}

function addNew() {
	const newData = {
		'id' : `new_${newCount}`,
		'name' : '',
		'isNew' : true,
		'editActive' : true
	}
	newCount++;
	const newCarrier = new FreightCarrier(newData);
	FREIGHT_CARRIER_DICT[newCarrier.getId()] = newCarrier;
	FREIGHT_CARRIER_ARRAY.unshift(newCarrier);

	renderFreightCarriers();

}


/**
 *
 * @param {HTMLButtonElement} button
 */
async function save(button) {
	const carrierID = button.getAttribute('carrierid');
	/**
	 * @type {FreightCarrier}
	 */
	const carrier = FREIGHT_CARRIER_DICT[carrierID];

	if (carrier.getHasChangedName()) {
		const saveData = {
			carriers : [carrier.getSaveData()]
		};
		console.log(saveData);
		const stringified = JSON.stringify(saveData).replaceAll("\\", '').replaceAll("\"[", "[").replaceAll("]\"", "]");;
		console.log(stringified);
		setLoadingModalVisible(true);
		const responseText = await fetch(`${CONTROLLER_BASE_URL}?m=freightCarriers_save`, {
			method: 'POST',
			headers: {
				'Accept' : 'application/json',
				'Content-Type': 'application/json'
			},
			body: stringified
		})
		.then(res => res.text());
		console.log(responseText);
		carrier.setOriginalName(carrier.getName());
		carrier.updateRowClasses();
		setLoadingModalVisible(false);
	}
}

async function saveAll() {
	const saveData = {
		carriers : []
	}
	for (const carrier of FREIGHT_CARRIER_ARRAY) {
		if (carrier.getHasChangedName()) {
			saveData.carriers.push(carrier.getSaveData());
		}
	}
	console.log(saveData);
	if (saveData.carriers.length > 0) {
		const stringified = JSON.stringify(saveData).replaceAll("\\", '').replaceAll("\"[", "[").replaceAll("]\"", "]");;
		console.log(stringified);
		setLoadingModalVisible(true);
		const responseText = await fetch(`${CONTROLLER_BASE_URL}?m=freightCarriers_save`, {
			method: 'POST',
			headers: {
				'Accept' : 'application/json',
				'Content-Type': 'application/json'
			},
			body: stringified
		})
		.then(res => res.text());
		console.log(responseText);
		init();
	}
}

/**
 *
 * @param {HTMLButtonElement} button
 */
async function deleteCarrier(button) {
	setLoadingModalVisible(true);
	const carrierID = button.getAttribute('carrierid');
	const carrierInputID = button.getAttribute('carrierinputid');
	/**
	 * @type {HTMLInputElement}
	 */
	const input = document.getElementById(carrierInputID);
	/**
	 * @type {FreightCarrier}
	 */
	const carrier = FREIGHT_CARRIER_DICT[carrierID];

	const responseText = await fetch(`${CONTROLLER_BASE_URL}?m=freightCarriers_delete&carrierId=${carrierID}`);

	init();
}
