class FreightCarrier {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.id = data['id'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.originalName = data['name'];

		/**
		 * @type {HTMLTableRowElement}
		 */
		this.row = null;

		this.changed = false;

		if (data['isNew']) {
			this.isNew = true;
		}
		else {
			this.isNew = false;
		}

		if (data['editActive']) {
			this.editActive = true;
		}
		else {
			this.editActive = false;
		}

		return this;
	}

	getId() {
		return this.id;
	}

	getName() {
		return this.name;
	}
	setName(name) {
		this.name = name;
		this.changed = this.getHasChangedName();
	}

	getOriginalName() {
		return this.originalName;
	}
	setOriginalName(originalName) {
		this.originalName = originalName;
		this.changed = this.getHasChangedName();
	}

	getRow() {
		return this.row;
	}
	setRow(row) {
		this.row = row;
	}

	getSaveData() {
		const saveData = {
			'id' : (this.isNew) ? '' : this.getId(),
			'name' : this.getName()
		}
		return saveData;
	}

	updateRowClasses() {
		if (this.changed) {
			this.row.classList.add('changed');
		}
		else {
			this.row.classList.remove('changed');
		}
		if (this.isNew) {
			this.row.classList.add('new');
		}
		else {
			this.row.classList.remove('new');
		}
	}

	generateRow() {
		const row = document.createElement('tr');

		row.appendChild(this.generateNameCell());
		row.appendChild(this.generateToggleEditButtonCell());
		row.appendChild(this.generateSaveButtonCell());
		row.appendChild(this.generateDeleteButtonCell());

		this.setRow(row);
		this.updateRowClasses();
		return this.getRow();
	}

	generateNameCell() {
		const cell = document.createElement('td');

		const input = document.createElement('input');
		cell.appendChild(input);

		input.type = 'text';
		input.id = `editName_${this.getId()}`;
		input.value = this.getName();
		input.classList.add('borderless');
		input.style.width = '240px';
		input.setAttribute('carrierId', this.getId());
		input.setAttribute('onInput', 'editCarrier(this)');

		input.disabled = !this.editActive;

		return cell;
	}

	generateToggleEditButtonCell() {
		const cell = document.createElement('td');

		const button = document.createElement('button');
		cell.appendChild(button);

		button.innerText = "Edit";
		button.setAttribute('carrierId', this.getId());
		button.setAttribute('carrierInputId', `editName_${this.getId()}`);
		button.setAttribute('onClick', 'toggleEdit(this)');

		return cell;
	}

	generateSaveButtonCell() {
		const cell = document.createElement('td');

		const button = document.createElement('button');
		cell.appendChild(button);

		button.innerText = "Save";
		button.setAttribute('carrierId', this.getId());
		button.setAttribute('carrierInputId', `editName_${this.getId()}`);
		button.setAttribute('onClick', 'save(this)');

		return cell;
	}

	generateDeleteButtonCell() {
		const cell = document.createElement('td');

		const button = document.createElement('button');
		cell.appendChild(button);

		button.innerText = "Delete";
		button.setAttribute('carrierId', this.getId());
		button.setAttribute('carrierInputId', `editName_${this.getId()}`);
		button.setAttribute('onClick', 'deleteCarrier(this)');

		return cell;
	}

	getHasChangedName() {
		return (this.name != this.originalName);
	}
}
