CONTROLLER_BASE_URL = "admin_controller.php";

init();

/**
 * @type {DeductedItem[]}
 */
const openOrderDeductions = [];
/**
 * @type {DeductedItem[]}
 */
const shipLogDeductions = [];

async function init() {
	console.log("in init, before getting deducted skus");
	await getDeductedSkus();
	console.log("in init, after getting deducted skus");
	// await fetch(`${CONTROLLER_BASE_URL}?m=getDeductedSkus`)
	// 	.then(response => response.json())
	// 	.then(data => processDeductedSkus(data))
	// 	.then(() => renderPage());
}

async function getDeductedSkus() {
	setLoadingModalVisible(true);
	await fetch(`${CONTROLLER_BASE_URL}?m=getDeductedSkus`)
		.then(response => response.json())
		.then(data => processDeductedSkus(data))
		.then(() => renderPage());
}


function processDeductedSkus(data) {
	openOrderDeductions.length = 0;
	shipLogDeductions.length = 0;
	for (const record of data['openOrderDeductions']) {
		openOrderDeductions.push(new DeductedItem(record));
	}
	for (const record of data['shipLogDeductions']) {
		shipLogDeductions.push(new DeductedItem(record));
	}
	console.log(openOrderDeductions);
	console.log(shipLogDeductions);
}

function renderPage() {
	setLoadingModalVisible(true);
	/**
	 * @type {HTMLTableSectionElement}
	 */
	const shipLogDeductionsBody = document.getElementById('ship_log_deductions_body');
	/**
	 * @type {HTMLTableSectionElement}
	 */
	const openOrderDeductionsBody = document.getElementById('open_order_deductions_body');
	shipLogDeductionsBody.innerHTML = '';
	openOrderDeductionsBody.innerHTML = '';

	for (const item of openOrderDeductions) {
		openOrderDeductionsBody.appendChild(item.getItemRow());
	}
	for (const item of shipLogDeductions) {
		shipLogDeductionsBody.appendChild(item.getItemRow());
	}

	document.getElementById('bodycontainer').hidden = false;
	setLoadingModalVisible(false);
}

/**
 *
 * @param {string} itemId
 * @param {string} view
 */
function removeFromDeductions(itemId, view) {
	console.log(itemId, view);
	fetch(`${CONTROLLER_BASE_URL}?m=removeFromDeductions&id=${itemId}&view=${view}`)
	.then(() => getDeductedSkus());
}
