class DeductedItem {
	constructor({id, zoho_id, code, name, view}) {
		/**
		 * @type {String}
		 */
		this.id = id;
		/**
		 * @type {String}
		 */
		this.zohoId = zoho_id;
		/**
		 * @type {String}
		 */
		this.code = code;
		/**
		 * @type {String}
		 */
		this.name = name;
		/**
		 * @type {String}
		 */
		this.view = view;
	}

	getId() {
		return this.id;
	}

	getZohoId() {
		return this.zohoId;
	}

	getCode() {
		return this.code;
	}

	getName() {
		return this.name;
	}

	getZohoLink() {
		return `https://crm.zoho.com/crm/org26161413/tab/Products/${this.getZohoId()}`;
	}

	getItemRow() {
		const row = document.createElement('tr');
		row.appendChild(this.getNameCell());
		row.appendChild(this.getCodeCell());
		row.appendChild(this.getActionCell());
		return row;
	}

	getCodeCell() {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		cell.appendChild(link);
		if (this.getCode()) {
			link.innerText = this.getCode();
		}
		else {
			link.innerText = "No Product Code Assigned";
		}
		link.href = this.getZohoLink();
		link.target = "_blank";
		return cell;
	}

	getNameCell() {
		const cell = document.createElement('td');
		const link = document.createElement('a');
		cell.appendChild(link);
		link.innerText = this.getName();
		link.href = this.getZohoLink();
		link.target = "_blank";
		return cell;
	}

	getActionCell() {
		const cell = document.createElement('td');
		const button = document.createElement('button');
		cell.appendChild(button);

		button.setAttribute('onclick', `removeFromDeductions('${this.getId()}', '${this.view}')`);
		button.innerText = "Remove From Deductions";
		return cell;
	}
}
