
/*
 * Constants
 */
var THIS_MONTH = "month";
var LAST_MONTH = "prev_mo";
var THIS_YEAR = "year";
var LAST_YEAR = "prev_year";
var THIS_QUARTER = "quarter";
var LAST_QUARTER = "prev_quarter";

var JANUARY = 0;
var DECEMBER = 11;
var LAST_DAY_IN_DECEMBER = 31;
var FIRST_DAY_IN_MONTH = 1;
var FOURTH_QUARTER = 4;

var YYYY_FORMAT = "yyyy";
var YY_FORMAT = "yy";
var DD_FORMAT = "dd";
var MM_FORMAT = "mm";


/*
 * Simply returns the number of days in the given month.
 */
function lastDayOfMonth(thisDate) {
    with (new Date(thisDate)) {
        setDate(32);
        return 32-getDate();
    }
}


/*
 * Some JavaScript implementations return the difference between the
 * year and 1900 rather than the actual year.
 */
function filterYear(year) {
    if (year < 1900) {
        return (year + 1900);
    }

    return year;
}


/*
 * Determines to-date and from-date for the given timeframe.
 * Expects two hidden fields in the given form: fromDateGMT, toDateGMT
 *
 */
function setMonthValues(whichOne, formName) {
    var thisForm = "document." + formName;
    var format = eval(thisForm + ".format.value");

    if (THIS_YEAR == whichOne.value ||
        LAST_YEAR == whichOne.value) {
        var today = new Date();

        thisYear = filterYear(today.getYear());
        fromYear = (LAST_YEAR == whichOne.value) ? thisYear - 1 : thisYear;
        fromMonth = JANUARY;
        fromDay = FIRST_DAY_IN_MONTH;

        toYear = fromYear;
        toMonth = DECEMBER;
        toDay = LAST_DAY_IN_DECEMBER;
    } else if (THIS_QUARTER == whichOne.value ||
               LAST_QUARTER == whichOne.value) {
        var today = new Date();
        var quarter = quarterOfYear(today);
        var year = filterYear(today.getYear());

        if (LAST_QUARTER == whichOne.value) {
            quarter -= 1;
            if (quarter <= 0) {
                quarter = FOURTH_QUARTER;
                year--;
            }
        }

        lastDate = new Date(year, lastMonthInQuarter(quarter), FIRST_DAY_IN_MONTH);

        fromYear = year;
        fromMonth = firstMonthInQuarter(quarter);
        fromDay = FIRST_DAY_IN_MONTH;

        toYear = year;
        toMonth = lastMonthInQuarter(quarter);
        toDay = lastDayOfMonth(lastDate);
    } else {
        var today = new Date();
        fromYear = filterYear(today.getYear());
        fromMonth = today.getMonth();
        if (LAST_MONTH == whichOne.value) {
            fromMonth--;
            if (fromMonth <= 0) {
                fromMonth = DECEMBER;
                fromYear--;
            }

            today = new Date(fromYear, fromMonth, FIRST_DAY_IN_MONTH);
        }

        fromDay = FIRST_DAY_IN_MONTH;

        toYear = filterYear(today.getYear());
        toMonth = today.getMonth();
        toDay = lastDayOfMonth(today);
    }

    var fromDate = new Date(fromYear, fromMonth, fromDay);
    var toDate = new Date(toYear, toMonth, toDay);

    var fromGmtSeconds = convertDateToGMTSeconds(fromDate, format);
    var toGmtSeconds = convertDateToGMTSeconds(toDate, format);

    setFieldValue(thisForm, "fromDateGMT", fromGmtSeconds)
    setFieldValue(thisForm, "toDateGMT", toGmtSeconds)
}


/*
 * Sets a field value.
 */
function setFieldValue(formName, fieldName, fieldValue) {
    var dateField = formName + "." + fieldName + ".value";
    eval(dateField + " = " + fieldValue);
}


/*
 * date.getTime() returns the milliseconds since epoch of the date object. This function returns
 * the seconds since epoch.
 */
function getSeconds(thisDate) {
    if (null != thisDate) {
        return thisDate.getTime()/1000;
    }
}


/*
 * Determines which quarter the given date belongs to.
 */
function quarterOfYear(thisDate) {
    var month = thisDate.getMonth();
    quarter = Math.floor((month / 3 + 1));
    return quarter;
}


/*
 * Returns the int of the first month in the given quarter.
 */
function firstMonthInQuarter(quarter) {
    return (quarter - 1) * 3;
}


/*
 * Returns the int of the last month in the given quarter.
 */
function lastMonthInQuarter(quarter) {
    return firstMonthInQuarter(quarter) + 2;
}


function addZero(vNumber){
    return ((vNumber < 10) ? "0" : "") + vNumber
}


function formatDate(vDate, vFormat) {
    var vDay              = addZero(vDate.getDate());
    var vMonth            = addZero(vDate.getMonth()+1);
    var vYearLong         = addZero(vDate.getFullYear());
    var vYearShort        = addZero(vDate.getFullYear().toString().substring(3,4));
    var vYear             = (vFormat.indexOf("yyyy")>-1?vYearLong:vYearShort)
    var vHour             = addZero(vDate.getHours());
    var vMinute           = addZero(vDate.getMinutes());
    var vSecond           = addZero(vDate.getSeconds());
    var vDateString       = vFormat.replace(/dd/g, vDay).replace(/mm/g, vMonth).replace(/y{1,4}/g, vYear)

    return vDateString
}



/*
 * Splits a format based on "/" and "-" characters. Usefull for date formats.
 */
function splitFormat(format) {
    return format.split(/\/|-/);
}


/*
 * Converts a date object to GMT seconds based on the format. Note, this is a date
 * object, not a date string. See convertToGMTSeconds to convert date strings.
 */
function convertDateToGMTSeconds(date, format) {
    return convertToGMTSeconds(formatDate(date, format), format);
}


/*
 * Converts a date string to GMT seconds based on the format. Note, this is a date
 * string, not a date object. See convertDateToGMTSeconds to convert Date objects.
 */
function convertToGMTSeconds(dateString, format) {

    var formatArr = splitFormat(format);
    var dateArr = splitFormat(dateString);

    var year;
    var day;
    var mo;
    for (var i=0; i<formatArr.length; i++) {
        if (YYYY_FORMAT == formatArr[i] || YY_FORMAT == formatArr[i]) {
            year = dateArr[i];
            if (year.length <= 2) {
                year = year - 0; // explicitly converts to int.
                year += 2000;
            }
        } else if (DD_FORMAT == formatArr[i]) {
            day = dateArr[i];
        } else if (MM_FORMAT == formatArr[i]) {
            mo = dateArr[i];
            mo--; // JavaScript 1-off
        }
    }

    var date = new Date(year, mo, day);
    return getSeconds(date);
}


/*
 * Sets a hidden date field to the desired GMT value.
 */
function setGMTSeconds(thisDate, formName, whichOne) {
    var thisForm = "document." + formName;
    var format = (eval(thisForm + ".format.value"));

    var gmtSeconds = convertToGMTSeconds(thisDate.value, format);
    setFieldValue(thisForm, whichOne, gmtSeconds)
    var formattedDate = formatDate(new Date(gmtSeconds*1000), format);
    thisDate.value = formattedDate.replace(/-/g, "/");
}