class TableTemplate {
	constructor(data) {
		/**
		 * @type {string}
		 */
		this.identifier = data['identifier'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		this.active = false;

		/**
		 * @type {HTMLHeadingElement}
		 */
		this.heading = null;
		/**
		 * @type {HTMLTableElement}
		 */
		this.table = null;
		/**
		 * @type {HTMLTableRowElement}
		 */
		this.headerRow = null;
		/**
		 * @type {HTMLTableSectionElement}
		 */
		this.body = null;
	}

	getIdentifier() {
		return this.identifier;
	}

	getName() {
		return this.name;
	}

	getHeading() {
		return this.heading;
	}

	getTable() {
		return this.table;
	}

	getHeaderRow() {
		return this.headerRow;
	}

	getBody() {
		return this.body;
	}

	setHeading(element) {
		this.heading = element;
	}

	setTable(element) {
		this.table = element;
	}

	setHeaderRow(element) {
		this.headerRow = element;
	}

	setBody(element) {
		this.body = element;
	}

	deleteHeading() {
		delete this.heading;
	}

	deleteTable() {
		delete this.table;
	}

	deleteHeaderRow() {
		delete this.headerRow;
	}

	deleteBody() {
		delete this.body;
	}

	generateSection() {
		const elements = {
			heading : this.generateHeading(),
			table : this.generateTable()
		};
		return elements;
	}

	generateHeading() {
		if (this.getHeading() != null) {
			this.deleteHeading();
		}
		const heading = document.createElement('h3');
		heading.id = this.generateElementId('heading');
		heading.innerText = this.getName();
		this.setHeading(heading);
		return heading;
	}

	generateTable() {
		const tableClasses = ['content-valign-middle', 'bordered', 'striped', 'space-5'];

		if (this.getTable() != null) {
			this.deleteTable();
		}
		const table = document.createElement('table');
		table.id = this.generateElementId('table');

		for(const tableClass of tableClasses) {
			table.classList.add(tableClass);
		}
		table.appendChild(this.generateHeaderRow());
		table.appendChild(this.generateBody());
		this.setTable(table);
		return table;
	}

	generateHeaderRow() {
		if (this.getHeaderRow() != null) {
			this.deleteHeaderRow();
		}
		const tHead = document.createElement('thead');
		const row = document.createElement('tr');
		row.id = this.generateElementId('headerRow');
		tHead.appendChild(row);
		this.setHeaderRow(row);
		return tHead;
	}

	generateBody() {
		if (this.getBody() != null) {
			this.deleteBody();
		}
		const body = document.createElement('tbody');
		body.id = this.generateElementId('body');
		this.setBody(body);
		return body;
	}

	generateElementId(elementName) {
		return `${this.getIdentifier()}_${elementName}`;
	}



	// <h3 hidden id="pricingNeeded_heading">Pricing Needed</h3>
	// <table id="pricingNeeded_table" class="content-valign-middle bordered striped space-5">
	// 	<thead>
	// 		<tr id="pricingNeeded_header_row">
	// 		</tr>
	// 	</thead>
	// 	<tbody id="pricingNeeded_body">
	// 	</tbody>
	// </table>
}
