class LineItem {
	constructor(data) {
		if (data['id']) {
			/**
			 * @type {string}
			 */
			this.id = data['id'];
		}
		else if (data['dbId']) {
			/**
			 * @type {string}
			 */
			this.id = data['dbId'];
		}
		/**
		 * @type {string}
		 */
		this.zohoId = data['zohoId'];
		/**
		 * @type {string}
		 */
		this.name = data['name'];
		/**
		 * @type {string}
		 */
		this.code = data['code'];
		/**
		 * @type {string}
		 */
		this.description = data['description'];

		this.quantity = parseInt(data['quantity']);
		this.total = parseFloat(data['total']) || 0.0;

		/**
		 * @type {string}
		 */
		this.filter = (data['code']) ? data['code'] : data['name'];

		this.isVisible = true;
	}

	getId() {
		return this.id;
	}

	getZohoId() {
		return this.zohoId;
	}

	getCode() {
		return this.code;
	}

	getName() {
		return this.name;
	}

	getDescription() {
		return this.description;
	}

	getQuantity() {
		return this.quantity;
	}

	getIsVisible() {
		return this.isVisible;
	}

	/**
	 * Fetches a parameter by name, or false if no such name
	 * @param {string} fieldName Name of the field to fetch
	 */
	getFieldByName(fieldName) {
		if (fieldName == 'id') {
			return this.getId();
		}
		else if (fieldName == 'zohoId') {
			return this.getZohoId();
		}
		else if (fieldName == 'name') {
			return this.getName();
		}
		else if (fieldName == 'code') {
			return this.getCode();
		}
		else if (fieldName == 'description') {
			return this.getDescription();
		}
		else if (fieldName == 'quantity' || fieldName == 'lineItemQuantity') {
			return this.getQuantity();
		}
		else if (fieldName == 'lineItemSku') {
			return (this.getCode()) ? this.getCode() : this.getName();
		}
	}

	getFieldByNameAsText(fieldName) {
		const returnedValue = this.getFieldByName(fieldName);
		if (typeof returnedValue == 'string') {
			return returnedValue;
		}
		else if (typeof returnedValue == 'number') {
			return returnedValue.toLocaleString();
		}
	}

	/**
	 *
	 * @param {boolean} isVisible
	 */
	setIsVisible(isVisible) {
		if (typeof isVisible == 'boolean') {
			this.isVisible = isVisible;
		}
	}

	getSaveableFieldsAsObject() {
		const toSave = {
			id : this.getId(),
			zohoId: this.getZohoId(),
			fields: {
			}
		};
		return toSave;
	}
}
