const CONTROLLER_BASE_URL = "admin_controller.php";

/**
 * @type {HTMLButtonElement}
 */
const submitButton = document.getElementById('submitButton');

/**
 * @type {HTMLTextAreaElement}
 */
const serialNumberInput = document.getElementById('serialNumbers');

/**
 * @type {HTMLInputElement}
 */
const ramInput = document.getElementById('ram');
/**
 * @type {HTMLInputElement}
 */
const ssdInput = document.getElementById('ssd');
/**
 * @type {HTMLInputElement}
 */
const poNumberInput = document.getElementById('poNumber');
/**
 * @type {HTMLInputElement}
 */
const identifierInput = document.getElementById('identifier');

const inputArray = [serialNumberInput, ramInput, ssdInput, poNumberInput, identifierInput];

/**
 * @type {HTMLSelectElement}
 */
const printerSelect = document.getElementById('printer');


let enteredPoNumber = '';
const skuData = {
	identifier : '',
	sku : ''
}


let poValid = false;
let identifierValid = false;
let serialsValid = false;

init();

function init() {
	document.addEventListener("DOMContentLoaded", function() {
		setLoadingModalVisible(false);
	});
}

/**
 *
 * @param {HTMLInputElement} identifierInput
 */
async function verifyIdentifierValid(identifierInput) {
	skuData.identifier = '';
	skuData.sku = '';
	identifierValid = false;
	const value = identifierInput.value;
	/**
	 * @type {HTMLSpanElement}
	 */
	const inputAlertSpan = document.getElementById("identifierInputAlerts");
	if (value.length != 4) {
		// TODO invalid length logic
		identifierValid = false;
	}
	else {
		inputAlertSpan.innerText = '';
		const sku = await fetch(`${CONTROLLER_BASE_URL}?m=get_sku_by_identifier&identifier=${value.toUpperCase()}`)
		.then(response => response.text())
		.then(data => {
			return data;
		})
		.catch(error => console.error(error));
		if (sku) {
			console.log(`${value} found sku: ${sku}`);
			inputAlertSpan.innerText = `SKU: ${sku}`;
			identifierValid = true;
			skuData.sku = sku;
			skuData.identifier = value;
		}
		else {
			console.log(`did not find sku with ${value}`);
			const inputAlertFirstPart = document.createElement('span');
			inputAlertFirstPart.innerText = `No SKU associated with identifier ${value} found.\n\nPlease double-check it was entered correctly; if so, please visit `;
			const inputAlertLink = document.createElement('a');
			inputAlertLink.href = `${CONTROLLER_BASE_URL}?m=machine_database`;
			inputAlertLink.target = "_blank";
			inputAlertLink.innerText = "Machine Database";
			const inputAlertLastPart = document.createElement('span');
			inputAlertLastPart.innerText = ` and add the identifier code to the desired SKU.`;
			inputAlertSpan.appendChild(inputAlertFirstPart);
			inputAlertSpan.appendChild(inputAlertLink);
			inputAlertSpan.appendChild(inputAlertLastPart);
		}
		inputAlertSpan.hidden = false;
	}
	enableSubmitIfValid();
}

/**
 *
 * @param {HTMLInputElement} poNumberInput
 */
async function verifyPoNumberValid(poNumberInput) {
	enteredPoNumber = '';
	poValid = false;
	const poNumberPattern = /^((SP|MTS|PO)1?\d{5})$/;
	const value = poNumberInput.value;
	/**
	 * @type {HTMLSpanElement}
	 */
	const inputAlertSpan = document.getElementById("poNumberInputAlerts");
	if (!poNumberPattern.test(value)) {
		// TODO invalid pattern logic
		poValid = false;
	}
	else {
		inputAlertSpan.innerText = '';
		const orderId = await fetch(`${CONTROLLER_BASE_URL}?m=verify_po_number&poNumber=${value.toUpperCase()}`)
		.then(response => response.text())
		.then(data => {
			return data;
		})
		.catch(error => console.error(error));
		if (orderId) {
			console.log(`${value} found order id: ${orderId}`);
			inputAlertSpan.innerText = `${value} valid.`;
			poValid = true;
			enteredPoNumber = value;
		}
		else {
			console.log(`did not find sku with ${value}`);
			const inputAlertFirstPart = document.createElement('span');
			inputAlertFirstPart.innerText = `No open PO with number ${value} found. Please double-check it was entered correctly.`;
			inputAlertSpan.appendChild(inputAlertFirstPart);
			poValid = false;
		}
		inputAlertSpan.hidden = false;
	}
	enableSubmitIfValid();
}

function enableSubmitIfValid() {
	submitButton.disabled = !(poValid && identifierValid && serialsValid);
}

/**
 *
 * @param {HTMLTextAreaElement} input
 */
function validateSerialInput(input) {
	serialsValid = false;
	if (getNumEnteredLines() && input.value) {
		serialsValid = true;
	}
	enableSubmitIfValid();
}

function getNumEnteredLines() {
	const numEnteredLines = getSubmittedSerials().size;
	return numEnteredLines;
}

async function submit() {
	serialNumberInput.value = [...getSubmittedSerials()].join('\n');
	const confirmationMessage = `Submitting ${getNumEnteredLines()} items with identifier ${skuData.identifier} (SKU: ${skuData.sku}) to ${enteredPoNumber}.\n\nConfirm?`;
	if (confirm(confirmationMessage)) {
		const submitData = {
			poNumber : enteredPoNumber,
			configCode : skuData.identifier,
			ssd : ssdInput.value + 'GB',
			ram : ramInput.value + 'GB',
			printer : printerSelect.value,
			serialNumbers : [...getSubmittedSerials()]
		}
		// const serials = [...getSubmittedSerials()];
		console.log(submitData);
		const stringified = JSON.stringify(submitData).replaceAll("\\", '').replaceAll("\"[", "[").replaceAll("]\"", "]");;
		console.log(stringified);
		setLoadingModalVisible(true);
		const rawResponse = await fetch(`${CONTROLLER_BASE_URL}?m=device_receiving_submit`, {
			method: 'POST',
			headers: {
				'Accept' : 'application/json',
				'Content-Type': 'application/json'
			},
			body: stringified
		});
		const content = await rawResponse.text();
		resetForm();
		setLoadingModalVisible(false);
		alert("Success!");

		console.log(content);
	}
}

function getSubmittedSerials() {
	const serials = new Set(serialNumberInput.value.trim().split('\n').map(s => s.trim().toUpperCase()).filter(el => el != ''));
	return serials;
}

function resetForm() {
	for (const element of inputArray) {
		element.value = '';
	}
	serialsValid = false;
	poValid = false;
	identifierValid = false;
	document.getElementById("poNumberInputAlerts").innerText = '';
	document.getElementById("identifierInputAlerts").innerText = '';
	enableSubmitIfValid();
}
